/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.Arrays;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;

@ParameterizedClass
@MethodSource(value={"params"})
public class ITestAzureBlobFileSystemRenameUnicode
extends AbstractAbfsIntegrationTest {
    public String srcDir;
    public String destDir;
    public String filename;

    public static Iterable<Object[]> params() {
        return Arrays.asList({"/src", "/dest", "filename"}, {"/%2c%26", "/abc\u00d6\u21d2123", "%2c%27"}, {"/\u00d6\u00e1\u03a0\u21d2", "/abc\u00d6\u00e1\u03a0\u21d2123", "\u4e2d\u6587"}, {"/A +B", "/B+ C", "C +D"}, {"/A~`!@#$%^&*()-_+={};:'>,<B", "/B~`!@#$%^&*()-_+={};:'>,<C", "C~`!@#$%^&*()-_+={};:'>,<D"});
    }

    public ITestAzureBlobFileSystemRenameUnicode(String pSrcDir, String pDestDir, String pFilename) throws Exception {
        this.srcDir = pSrcDir;
        this.destDir = pDestDir;
        this.filename = pFilename;
    }

    @Test
    public void testRenameFileUsingUnicode() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path folderPath1 = this.path(this.srcDir);
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)folderPath1);
        ContractTestUtils.assertIsDirectory((FileSystem)fs, (Path)folderPath1);
        Path filePath = new Path(folderPath1 + "/" + this.filename);
        this.touch(filePath);
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)filePath);
        Path folderPath2 = new Path(this.destDir);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)folderPath1, (Path)folderPath2, (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"renamed", (Path)folderPath1);
        ContractTestUtils.assertIsDirectory((FileSystem)fs, (Path)folderPath2);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"renamed file", (Path)new Path(folderPath2 + "/" + this.filename));
        FileStatus[] fileStatus = fs.listStatus(folderPath2);
        ITestAzureBlobFileSystemRenameUnicode.assertNotNull((Object)fileStatus);
        ITestAzureBlobFileSystemRenameUnicode.assertTrue((fileStatus.length > 0 ? 1 : 0) != 0, (String)("Empty listing returned from listStatus(\"" + folderPath2 + "\")"));
        ITestAzureBlobFileSystemRenameUnicode.assertEquals((Object)fileStatus[0].getPath().getName(), (Object)this.filename);
    }
}

