/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.RenameAtomicity;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.AbfsTestUtils;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ITestAzureBlobFileSystemRenameRecovery
extends AbstractAbfsIntegrationTest {
    private static final int FAILED_CALL = 15;
    private static final int TOTAL_FILES = 25;

    @Test
    public void testRenameCopyFailureInBetween() throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem(this.getConfig()));){
            this.assumeBlobServiceType();
            AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
            fs.getAbfsStore().setClient((AbfsClient)client);
            Path src = new Path("/hbase/A1/A2");
            Path dst = new Path("/hbase/A1/A3");
            AbfsTestUtils.createFiles(fs, src, 25);
            AtomicInteger copyCall = new AtomicInteger(0);
            this.renameCrashInBetween(fs, src, dst, client, copyCall);
        }
    }

    @Test
    public void testRenameDeleteFailureInBetween() throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem(this.getConfig()));){
            this.assumeBlobServiceType();
            AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
            fs.getAbfsStore().setClient((AbfsClient)client);
            Path src = new Path("/hbase/A1/A2");
            Path dst = new Path("/hbase/A1/A3");
            AbfsTestUtils.createFiles(fs, src, 25);
            AtomicInteger deleteCall = new AtomicInteger(0);
            ((AbfsBlobClient)Mockito.doAnswer(deleteRequest -> {
                if (deleteCall.get() == 15) {
                    throw new AbfsRestOperationException(AzureServiceErrorCode.BLOB_PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.BLOB_PATH_NOT_FOUND.getErrorCode(), AzureServiceErrorCode.BLOB_PATH_NOT_FOUND.getErrorMessage(), new Exception());
                }
                deleteCall.incrementAndGet();
                return deleteRequest.callRealMethod();
            }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), Mockito.anyString(), (TracingContext)Mockito.any(TracingContext.class));
            this.renameOperationWithRecovery(fs, src, dst, deleteCall);
        }
    }

    @Test
    public void testRenameRecoveryWhenDestAlreadyExist() throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem(this.getConfig()));){
            this.assumeBlobServiceType();
            AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
            fs.getAbfsStore().setClient((AbfsClient)client);
            Path src = new Path("/hbase/A1/A2");
            Path dst = new Path("/hbase/A1/A3");
            AbfsTestUtils.createFiles(fs, src, 25);
            fs.mkdirs(dst);
            AtomicInteger copyCall = new AtomicInteger(0);
            this.validateRename(fs, src, dst, true, true, false);
            this.renameCrashInBetween(fs, src, dst, client, copyCall);
        }
    }

    @Test
    public void testRenameRecoveryWithMarkerPresentInDest() throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem(this.getConfig()));){
            this.assumeBlobServiceType();
            AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
            fs.getAbfsStore().setClient((AbfsClient)client);
            Path src = new Path("/hbase/A1/A2");
            Path dst = new Path("/hbase/A1/A3");
            AbfsTestUtils.createFiles(fs, src, 25);
            AtomicInteger copyCall = new AtomicInteger(0);
            this.renameCrashInBetween(fs, src, dst, client, copyCall);
        }
    }

    @Test
    public void testRenameWhenAlreadyRenamePendingJsonFilePresent() throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem(this.getConfig()));){
            this.assumeBlobServiceType();
            AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
            fs.getAbfsStore().setClient((AbfsClient)client);
            Path src = new Path("/hbase/A1/A2");
            Path dst = new Path("/hbase/A1/A3");
            AbfsTestUtils.createFiles(fs, src, 25);
            AtomicInteger copyCall = new AtomicInteger(0);
            this.renameCrashInBetween(fs, src, dst, client, copyCall);
        }
    }

    @Test
    public void testListCrashRecoveryWithSingleChildFolder() throws Exception {
        Path path = new Path("/hbase/A1/A2");
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        AzureBlobFileSystem fs = this.createJsonFile(path, renameJson);
        FileStatus[] fileStatuses = fs.listStatus(new Path("/hbase/A1"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List should return 0 file", new Object[0])).isEqualTo(0);
        this.assertPendingJsonFile(fs, renameJson, fileStatuses, path, false);
    }

    @Test
    public void testListCrashRecoveryWithMultipleChildFolder() throws Exception {
        Path path = new Path("/hbase/A1/A2");
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        AzureBlobFileSystem fs = this.createJsonFile(path, renameJson);
        fs.create(new Path("/hbase/A1/file1.txt"));
        fs.create(new Path("/hbase/A1/file2.txt"));
        FileStatus[] fileStatuses = fs.listStatus(new Path("/hbase/A1"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List should return 2 files", new Object[0])).isEqualTo(2);
        this.assertPendingJsonFile(fs, renameJson, fileStatuses, path, false);
    }

    @Test
    public void testListCrashRecoveryWithPendingJsonFile() throws Exception {
        Path path = new Path("/hbase/A1/A2");
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        AzureBlobFileSystem fs = this.createJsonFile(path, renameJson);
        fs.delete(path, true);
        fs.create(new Path("/hbase/A1/file1.txt"));
        fs.create(new Path("/hbase/A1/file2.txt"));
        FileStatus[] fileStatuses = fs.listStatus(path.getParent());
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List should return 2 files", new Object[0])).isEqualTo(2);
        this.assertPendingJsonFile(fs, renameJson, fileStatuses, path, false);
    }

    @Test
    public void testListCrashRecoveryWithoutAnyPendingJsonFile() throws Exception {
        Path path = new Path("/hbase/A1/A2");
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        AzureBlobFileSystem fs = this.createJsonFile(path, renameJson);
        fs.delete(renameJson, true);
        fs.create(new Path("/hbase/A1/file1.txt"));
        fs.create(new Path("/hbase/A1/file2.txt"));
        FileStatus[] fileStatuses = fs.listStatus(path.getParent());
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List should return 3 files", new Object[0])).isEqualTo(3);
        this.assertPendingJsonFile(fs, renameJson, fileStatuses, path, true);
    }

    @Test
    public void testListCrashRecoveryWithPendingJsonDir() throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());){
            this.assumeBlobServiceType();
            AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
            Path path = new Path("/hbase/A1/A2");
            Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
            fs.mkdirs(renameJson);
            fs.create(new Path(path.getParent(), "file1.txt"));
            fs.create(new Path(path, "file2.txt"));
            AtomicInteger redoRenameCall = new AtomicInteger(0);
            ((AbfsBlobClient)Mockito.doAnswer(answer -> {
                redoRenameCall.incrementAndGet();
                return answer.callRealMethod();
            }).when((Object)client)).getRedoRenameAtomicity((Path)Mockito.any(Path.class), Mockito.anyInt(), (TracingContext)Mockito.any(TracingContext.class));
            FileStatus[] fileStatuses = fs.listStatus(path.getParent());
            ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List should return 3 files", new Object[0])).isEqualTo(3);
            ((AbstractIntegerAssert)Assertions.assertThat((int)redoRenameCall.get()).describedAs("No redo rename call should be made", new Object[0])).isEqualTo(0);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)Arrays.stream(fileStatuses).anyMatch(status -> renameJson.toUri().getPath().equals(status.getPath().toUri().getPath()))).describedAs("Directory with suffix -RenamePending.json should exist.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testListCrashRecoveryWithMultipleJsonFile() throws Exception {
        Path path = new Path("/hbase/A1/A2");
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        AzureBlobFileSystem fs = this.createJsonFile(path, renameJson);
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        Path path2 = new Path("/hbase/A1/A3");
        fs.create(new Path(path2, "file3.txt"));
        Path renameJson2 = new Path(path2.getParent(), path2.getName() + "-RenamePending.json");
        VersionedFileStatus fileStatus = (VersionedFileStatus)fs.getFileStatus(path2);
        new RenameAtomicity(path2, new Path("/hbase/test4"), renameJson2, this.getTestTracingContext(fs, true), fileStatus.getEtag(), (AbfsClient)client).preRename();
        fs.create(new Path(path, "file2.txt"));
        AtomicInteger redoRenameCall = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            redoRenameCall.incrementAndGet();
            return answer.callRealMethod();
        }).when((Object)client)).getRedoRenameAtomicity((Path)Mockito.any(Path.class), Mockito.anyInt(), (TracingContext)Mockito.any(TracingContext.class));
        FileStatus[] fileStatuses = fs.listStatus(path.getParent());
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List should return 0 paths", new Object[0])).isEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)redoRenameCall.get()).describedAs("2 redo rename calls should be made", new Object[0])).isEqualTo(2);
        this.assertPathStatus(fs, path, false, "Source directory should not exist.");
        this.assertPathStatus(fs, new Path("/hbase/test4/file.txt"), true, "File in destination directory should exist.");
        this.assertPathStatus(fs, path2, false, "Source directory should not exist");
        this.assertPathStatus(fs, new Path("/hbase/test4/file2.txt"), true, "File in destination directory should exist.");
        this.assertPathStatus(fs, renameJson, false, "Rename Pending Json file should not exist.");
        this.assertPathStatus(fs, renameJson2, false, "Rename Pending Json file should not exist.");
    }

    @Test
    public void testGetPathStatusWithPendingJsonFile() throws Exception {
        Path path = new Path("/hbase/A1/A2");
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        AzureBlobFileSystem fs = this.createJsonFile(path, renameJson);
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.create(new Path("/hbase/A1/file1.txt"));
        fs.create(new Path("/hbase/A1/file2.txt"));
        AbfsConfiguration conf = fs.getAbfsStore().getAbfsConfiguration();
        AtomicInteger redoRenameCall = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            redoRenameCall.incrementAndGet();
            return answer.callRealMethod();
        }).when((Object)client)).getRedoRenameAtomicity((Path)Mockito.any(Path.class), Mockito.anyInt(), (TracingContext)Mockito.any(TracingContext.class));
        TracingContext tracingContext = new TracingContext(conf.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.GET_FILESTATUS, TracingHeaderFormat.ALL_ID_FORMAT, null);
        AzureServiceErrorCode azureServiceErrorCode = ((AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> client.getPathStatus(path.toUri().getPath(), true, tracingContext, null))).getErrorCode();
        ((AbstractStringAssert)Assertions.assertThat((String)azureServiceErrorCode.getErrorCode()).describedAs("Path had to be recovered from atomic rename operation.", new Object[0])).isEqualTo((Object)AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode());
        ((AbstractIntegerAssert)Assertions.assertThat((int)redoRenameCall.get()).describedAs("There should be one redo rename call", new Object[0])).isEqualTo(1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(renameJson)).describedAs("Rename Pending Json file should not exist.", new Object[0])).isFalse();
    }

    @Test
    public void testETagChangedDuringRename() throws Exception {
        this.assumeBlobServiceType();
        Path path = new Path("/hbase/A1/A2");
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        AzureBlobFileSystem fs = this.createJsonFile(path, renameJson);
        AbfsBlobClient abfsBlobClient = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.getAbfsStore().setClient((AbfsClient)abfsBlobClient);
        fs.delete(path, true);
        fs.create(new Path(path, "file1.txt"));
        fs.create(new Path(path, "file2.txt"));
        AtomicInteger numberOfCopyBlobCalls = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(copyBlob -> {
            numberOfCopyBlobCalls.incrementAndGet();
            return copyBlob.callRealMethod();
        }).when((Object)abfsBlobClient)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        AtomicInteger numberOfRedoRenameAtomicityCalls = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(redoRenameAtomicity -> {
            numberOfRedoRenameAtomicityCalls.incrementAndGet();
            return redoRenameAtomicity.callRealMethod();
        }).when((Object)abfsBlobClient)).getRedoRenameAtomicity((Path)Mockito.any(Path.class), Mockito.anyInt(), (TracingContext)Mockito.any(TracingContext.class));
        fs.listStatus(path.getParent());
        ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfRedoRenameAtomicityCalls.get()).describedAs("There should be one call to getRedoRenameAtomicity", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfCopyBlobCalls.get()).describedAs("There should be no copy blob call", new Object[0])).isEqualTo(0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(renameJson)).describedAs("Rename Pending Json file should not exist.", new Object[0])).isFalse();
    }

    private void triggerRenameRecovery(AzureBlobFileSystem fs, Path src) throws Exception {
        TracingContext tracingContext = new TracingContext(this.getConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.GET_FILESTATUS, TracingHeaderFormat.ALL_ID_FORMAT, null);
        AzureServiceErrorCode errorCode = ((AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.getAbfsStore().getClient().getPathStatus(src.toUri().getPath(), true, tracingContext, null))).getErrorCode();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)errorCode).describedAs("Path had to be recovered from atomic rename operation.", new Object[0])).isEqualTo((Object)AzureServiceErrorCode.PATH_NOT_FOUND);
    }

    private void renameCrashInBetween(AzureBlobFileSystem fs, Path src, Path dst, AbfsBlobClient client, AtomicInteger copyCall) throws Exception {
        ((AbfsBlobClient)Mockito.doAnswer(copyRequest -> {
            if (copyCall.get() == 15) {
                throw new AbfsRestOperationException(AzureServiceErrorCode.BLOB_ALREADY_EXISTS.getStatusCode(), AzureServiceErrorCode.BLOB_ALREADY_EXISTS.getErrorCode(), AzureServiceErrorCode.BLOB_ALREADY_EXISTS.getErrorMessage(), new Exception());
            }
            copyCall.incrementAndGet();
            return copyRequest.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        this.renameOperationWithRecovery(fs, src, dst, copyCall);
    }

    private Configuration getConfig() {
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.blob.dir.list.producer.queue.max.size", "5");
        config.set("fs.azure.blob.dir.list.consumer.max.lag", "3");
        config.set("fs.azure.blob.dir.rename.max.thread", "2");
        return config;
    }

    private AbfsClient addSpyHooksOnClient(AzureBlobFileSystem fs) {
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        AbfsClient client = (AbfsClient)Mockito.spy((Object)store.getClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        return client;
    }

    private void validateRename(AzureBlobFileSystem fs, Path src, Path dst, boolean isSrcExist, boolean isDstExist, boolean isJsonExist) throws Exception {
        this.assertPathStatus(fs, new Path(src.getParent(), src.getName() + "-RenamePending.json"), isJsonExist, "Pending JSON file");
        this.assertPathStatus(fs, src, isSrcExist, "Source directory");
        this.assertPathStatus(fs, dst, isDstExist, "Destination directory");
    }

    private void assertPathStatus(AzureBlobFileSystem fs, Path path, boolean shouldExist, String description) throws Exception {
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsClient();
        if (shouldExist) {
            int actualStatus = client.getPathStatus(path.toUri().getPath(), tracingContext, null, true).getResult().getStatusCode();
            ((AbstractIntegerAssert)Assertions.assertThat((int)actualStatus).describedAs("%s should exists", new Object[]{description})).isEqualTo(200);
        } else {
            AzureServiceErrorCode errorCode = ((AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> client.getPathStatus(path.toUri().getPath(), true, tracingContext, null))).getErrorCode();
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)errorCode).describedAs("%s should not exists", new Object[]{description})).isEqualTo((Object)AzureServiceErrorCode.BLOB_PATH_NOT_FOUND);
        }
    }

    private AzureBlobFileSystem createJsonFile(Path path, Path renameJson) throws IOException {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        AbfsClient client = (AbfsClient)Mockito.spy((Object)store.getClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        fs.setWorkingDirectory(new Path("/"));
        fs.create(new Path(path, "file.txt"));
        VersionedFileStatus fileStatus = (VersionedFileStatus)fs.getFileStatus(path);
        new RenameAtomicity(path, new Path("/hbase/test4"), renameJson, this.getTestTracingContext(fs, true), fileStatus.getEtag(), client).preRename();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(renameJson)).describedAs("Rename Pending Json file should exist.", new Object[0])).isTrue();
        return fs;
    }

    private void renameOperationWithRecovery(AzureBlobFileSystem fs, Path src, Path dst, AtomicInteger countCall) throws Exception {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should crash in between.", new Object[0])).isFalse();
        ((AbstractIntegerAssert)Assertions.assertThat((int)countCall.get()).describedAs("Operation count should be less than 10.", new Object[0])).isLessThan(25);
        this.validateRename(fs, src, dst, true, true, true);
        countCall.set(0);
        this.triggerRenameRecovery(fs, src);
        ((AbstractIntegerAssert)Assertions.assertThat((int)countCall.get()).describedAs("Operation count should be greater than 0.", new Object[0])).isGreaterThan(0);
        this.validateRename(fs, src, dst, false, true, false);
    }

    private void assertPendingJsonFile(AzureBlobFileSystem fs, Path renameJson, FileStatus[] fileStatuses, Path srcPath, boolean isSrcPathExist) throws Exception {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(renameJson)).describedAs("Rename Pending Json file should not exist.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Arrays.stream(fileStatuses).anyMatch(status -> renameJson.toUri().getPath().equals(status.getPath().toUri().getPath()))).describedAs("List status should not contains any file with suffix -RenamePending.json.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Arrays.stream(fileStatuses).anyMatch(status -> srcPath.toUri().getPath().equals(status.getPath().toUri().getPath()))).describedAs("List status should not contains source path.", new Object[0])).isEqualTo(isSrcPathExist);
    }
}

