/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.ITestAbfsStreamStatistics;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.io.IOUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAzureBlobFileSystemOauth
extends AbstractAbfsIntegrationTest {
    private static final Path FILE_PATH = new Path("/testFile");
    private static final String EXISTED_FILE_PATH = "/existedFile";
    private static final String EXISTED_FOLDER_PATH = "/existedFolder";
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsStreamStatistics.class);

    public ITestAzureBlobFileSystemOauth() throws Exception {
        Assumptions.assumeThat((Comparable)this.getAuthType()).isEqualTo((Object)AuthType.OAuth);
    }

    @Test
    public void testBlobDataContributor() throws Exception {
        String clientId = this.getConfiguration().get("fs.azure.account.oauth2.contributor.client.id");
        ((AbstractStringAssert)Assumptions.assumeThat((String)clientId).as("Contributor client id not provided", new Object[0])).isNotNull();
        String secret = this.getConfiguration().get("fs.azure.account.oauth2.contributor.client.secret");
        ((AbstractStringAssert)Assumptions.assumeThat((String)secret).as("Contributor client secret not provided", new Object[0])).isNotNull();
        Path existedFilePath = this.path(EXISTED_FILE_PATH);
        Path existedFolderPath = this.path(EXISTED_FOLDER_PATH);
        this.prepareFiles(existedFilePath, existedFolderPath);
        AzureBlobFileSystem fs = this.getBlobConributor();
        try (FSDataOutputStream stream = fs.create(FILE_PATH);){
            stream.write(0);
        }
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)FILE_PATH);
        FileStatus fileStatus = fs.getFileStatus(FILE_PATH);
        ITestAzureBlobFileSystemOauth.assertEquals((long)1L, (long)fileStatus.getLen());
        ITestAzureBlobFileSystemOauth.assertTrue((boolean)fs.delete(FILE_PATH, true));
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)FILE_PATH);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)existedFolderPath);
        fs.delete(existedFolderPath, true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)existedFolderPath);
        try (FSDataInputStream stream = fs.open(existedFilePath);){
            ITestAzureBlobFileSystemOauth.assertTrue((stream.read() != 0 ? 1 : 0) != 0);
        }
        ITestAzureBlobFileSystemOauth.assertEquals((long)0L, (long)fs.getFileStatus(existedFilePath).getLen());
        stream = fs.append(existedFilePath);
        try {
            stream.write(0);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        ITestAzureBlobFileSystemOauth.assertEquals((long)1L, (long)fs.getFileStatus(existedFilePath).getLen());
        fs.delete(existedFilePath, true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)existedFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlobDataReader() throws Exception {
        String clientId = this.getConfiguration().get("fs.azure.account.oauth2.reader.client.id");
        ((AbstractStringAssert)Assumptions.assumeThat((String)clientId).as("Reader client id not provided", new Object[0])).isNotNull();
        String secret = this.getConfiguration().get("fs.azure.account.oauth2.reader.client.secret");
        ((AbstractStringAssert)Assumptions.assumeThat((String)secret).as("Reader client secret not provided", new Object[0])).isNotNull();
        Path existedFilePath = this.path(EXISTED_FILE_PATH);
        Path existedFolderPath = this.path(EXISTED_FOLDER_PATH);
        this.prepareFiles(existedFilePath, existedFolderPath);
        AzureBlobFileSystem fs = this.getBlobReader();
        AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        Hashtable properties = abfsStore.getFilesystemProperties(tracingContext);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)existedFolderPath);
        try {
            abfsStore.delete(existedFolderPath, true, tracingContext);
        }
        catch (AbfsRestOperationException e) {
            ITestAzureBlobFileSystemOauth.assertEquals((Object)AzureServiceErrorCode.AUTHORIZATION_PERMISSION_MISS_MATCH, (Object)e.getErrorCode());
        }
        try (AbfsInputStream inputStream = abfsStore.openFileForRead(existedFilePath, null, tracingContext);){
            ITestAzureBlobFileSystemOauth.assertTrue((inputStream.read() != 0 ? 1 : 0) != 0);
        }
        try {
            abfsStore.openFileForWrite(existedFilePath, fs.getFsStatistics(), true, tracingContext);
        }
        catch (AbfsRestOperationException e) {
            try {
                ITestAzureBlobFileSystemOauth.assertEquals((Object)AzureServiceErrorCode.AUTHORIZATION_PERMISSION_MISS_MATCH, (Object)e.getErrorCode());
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{abfsStore});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{abfsStore});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{abfsStore});
    }

    @Test
    public void testGetPathStatusWithReader() throws Exception {
        String clientId = this.getConfiguration().get("fs.azure.account.oauth2.reader.client.id");
        ((AbstractStringAssert)Assumptions.assumeThat((String)clientId).as("Reader client id not provided", new Object[0])).isNotNull();
        String secret = this.getConfiguration().get("fs.azure.account.oauth2.reader.client.secret");
        ((AbstractStringAssert)Assumptions.assumeThat((String)secret).as("Reader client secret not provided", new Object[0])).isNotNull();
        Path existedFolderPath = this.path(EXISTED_FOLDER_PATH);
        this.createAzCopyFolder(existedFolderPath);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getBlobReader());
        AzureBlobFileSystemStore abfsStore = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)abfsStore).when((Object)fs)).getAbfsStore();
        AbfsBlobClient abfsClient = (AbfsBlobClient)Mockito.spy((Object)abfsStore.getClientHandler().getBlobClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)abfsClient).when((Object)abfsStore)).getClient();
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatCode(() -> abfsStore.getPathStatus(existedFolderPath, tracingContext)).as("Expected getPathStatus to complete without throwing an exception", new Object[0])).doesNotThrowAnyException();
        ((AbfsBlobClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)1))).createMarkerAtPath(Mockito.anyString(), (String)Mockito.nullable(String.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.nullable(TracingContext.class));
    }

    private void prepareFiles(Path existedFilePath, Path existedFolderPath) throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(existedFilePath).close();
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)existedFilePath);
        fs.mkdirs(existedFolderPath);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)existedFolderPath);
    }

    private AzureBlobFileSystem getBlobConributor() throws Exception {
        AbfsConfiguration abfsConfig = this.getConfiguration();
        abfsConfig.set("fs.azure.account.oauth2.client.id." + this.getAccountName(), abfsConfig.get("fs.azure.account.oauth2.contributor.client.id"));
        abfsConfig.set("fs.azure.account.oauth2.client.secret." + this.getAccountName(), abfsConfig.get("fs.azure.account.oauth2.contributor.client.secret"));
        Configuration rawConfig = abfsConfig.getRawConfiguration();
        return this.getFileSystem(rawConfig);
    }

    private AzureBlobFileSystem getBlobReader() throws Exception {
        AbfsConfiguration abfsConfig = this.getConfiguration();
        abfsConfig.set("fs.azure.account.oauth2.client.id." + this.getAccountName(), abfsConfig.get("fs.azure.account.oauth2.reader.client.id"));
        abfsConfig.set("fs.azure.account.oauth2.client.secret." + this.getAccountName(), abfsConfig.get("fs.azure.account.oauth2.reader.client.secret"));
        Configuration rawConfig = abfsConfig.getRawConfiguration();
        return this.getFileSystem(rawConfig);
    }
}

