/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ITestAzureBlobFileSystemMkDir
extends AbstractAbfsIntegrationTest {
    @Test
    public void testCreateDirWithExistingDir() throws Exception {
        Assumptions.assumeThat((boolean)true).isTrue();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = this.path("testFolder");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)path);
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)path);
    }

    @Test
    public void testMkdirExistingDirOverwriteFalse() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)true).as("Ignore test until default overwrite is set to false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.getIsNamespaceEnabled(this.getFileSystem())).as("Ignore test for Non-HNS accounts", new Object[0])).isTrue();
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.enable.mkdir.overwrite", Boolean.toString(false));
        AzureBlobFileSystem fs = this.getFileSystem(config);
        Path path = this.path("testFolder");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)path);
        long timeCreated = fs.getFileStatus(path).getModificationTime();
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)path);
        ITestAzureBlobFileSystemMkDir.assertEquals((long)timeCreated, (long)fs.getFileStatus(path).getModificationTime(), (String)"LMT should not be updated for existing dir");
    }

    @Test
    public void createDirWithExistingFilename() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.getIsNamespaceEnabled(this.getFileSystem())).as("Ignore test until default overwrite is set to false", new Object[0])).isFalse();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = this.path("testFilePath");
        fs.create(path).close();
        ITestAzureBlobFileSystemMkDir.assertTrue((boolean)fs.getFileStatus(path).isFile());
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.mkdirs(path));
    }

    @Test
    public void testCreateRoot() throws Exception {
        ContractTestUtils.assertMkdirs((FileSystem)this.getFileSystem(), (Path)new Path("/"));
    }

    @Test
    public void testDefaultCreateOverwriteDirTest() throws Throwable {
        this.testCreateDirOverwrite(true);
        this.testCreateDirOverwrite(false);
    }

    public void testCreateDirOverwrite(boolean enableConditionalCreateOverwrite) throws Throwable {
        AzureBlobFileSystem currentFs = this.getFileSystem();
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.enable.conditional.create.overwrite", Boolean.toString(enableConditionalCreateOverwrite));
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);
        long totalConnectionMadeBeforeTest = (Long)fs.getInstrumentationMap().get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
        int mkdirRequestCount = 0;
        Path dirPath = new Path("/DirPath_" + UUID.randomUUID().toString());
        fs.mkdirs(dirPath);
        AbfsClient client = fs.getAbfsStore().getClientHandler().getIngressClient();
        mkdirRequestCount = client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs) ? (mkdirRequestCount += 3) : ++mkdirRequestCount;
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)mkdirRequestCount, fs.getInstrumentationMap());
        fs.mkdirs(dirPath);
        mkdirRequestCount = client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs) ? (mkdirRequestCount += 2) : ++mkdirRequestCount;
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)mkdirRequestCount, fs.getInstrumentationMap());
    }

    @Test
    public void testMkdirWithExistingFilename() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        fs.create(new Path("/testFilePath"));
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.mkdirs(new Path("/testFilePath")));
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.mkdirs(new Path("/testFilePath/newDir")));
    }
}

