/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsDriverException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobListResultSchema;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientTestUtil;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsJdkHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.ListResponseData;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.DirectoryStateHelper;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemListStatus
extends AbstractAbfsIntegrationTest {
    private static final int TEST_FILES_NUMBER = 6000;
    public static final String TEST_CONTINUATION_TOKEN = "continuation";
    private static final int TOTAL_NUMBER_OF_PATHS = 11;
    private static final int NUMBER_OF_UNIQUE_PATHS = 7;

    @Test
    public void testListPath() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.list.max.results", "5000");
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)this.getFileSystem().getUri(), (Configuration)config);
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 6000; ++i) {
            final Path path = new Path("/test" + i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ITestAzureBlobFileSystemListStatus.this.touch(path);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
        fs.registerListener((Listener)new TracingHeaderValidator(this.getConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.LISTSTATUS, true, 0));
        FileStatus[] files = fs.listStatus(new Path("/"));
        ITestAzureBlobFileSystemListStatus.assertEquals((int)6000, (int)files.length);
        fs.registerListener((Listener)new TracingHeaderValidator(this.getConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.GET_ATTR, true, 0));
        fs.close();
    }

    @Test
    public void testListPathTracingContext() throws Exception {
        AzureBlobFileSystem spiedFs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore spiedStore = (AzureBlobFileSystemStore)Mockito.spy((Object)spiedFs.getAbfsStore());
        AbfsClient spiedClient = (AbfsClient)Mockito.spy((Object)spiedFs.getAbfsClient());
        TracingContext spiedTracingContext = (TracingContext)Mockito.spy((Object)new TracingContext(spiedFs.getClientCorrelationId(), spiedFs.getFileSystemId(), FSOperationType.LISTSTATUS, true, TracingHeaderFormat.ALL_ID_FORMAT, null));
        ((AzureBlobFileSystem)Mockito.doReturn((Object)spiedStore).when((Object)spiedFs)).getAbfsStore();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)spiedClient).when((Object)spiedStore)).getClient();
        spiedFs.setWorkingDirectory(new Path("/"));
        AbfsClientTestUtil.setMockAbfsRestOperationForListOperation(spiedClient, (FunctionRaisingIOE<AbfsJdkHttpOperation, AbfsJdkHttpOperation>)((FunctionRaisingIOE)httpOperation -> {
            Stubber stubber = Mockito.doThrow((Throwable[])new Throwable[]{new SocketTimeoutException("connect timed out")});
            ((AbfsJdkHttpOperation)stubber.doNothing().when(httpOperation)).processResponse((byte[])ArgumentMatchers.nullable(byte[].class), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue(), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
            Mockito.when((Object)httpOperation.getStatusCode()).thenReturn((Object)-1).thenReturn((Object)200);
            return httpOperation;
        }));
        ArrayList fileStatuses = new ArrayList();
        spiedStore.listStatus(new Path("/"), "", fileStatuses, true, null, spiedTracingContext);
        ((AbfsClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)1))).getRetryPolicy("CT");
        ((AbfsClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)1))).listPath("/", false, spiedFs.getAbfsStore().getAbfsConfiguration().getListMaxResults(), null, spiedTracingContext, spiedFs.getAbfsStore().getUri());
        ((AbfsClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)1))).listPath("/", false, spiedFs.getAbfsStore().getAbfsConfiguration().getListMaxResults(), TEST_CONTINUATION_TOKEN, spiedTracingContext, spiedFs.getAbfsStore().getUri());
        ((TracingContext)Mockito.verify((Object)spiedTracingContext, (VerificationMode)Mockito.times((int)0))).constructHeader((AbfsHttpOperation)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testListPathParsingFailure() throws Exception {
        this.assumeBlobServiceType();
        AzureBlobFileSystem spiedFs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore spiedStore = (AzureBlobFileSystemStore)Mockito.spy((Object)spiedFs.getAbfsStore());
        AbfsBlobClient spiedClient = (AbfsBlobClient)Mockito.spy((Object)spiedStore.getClientHandler().getBlobClient());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)spiedStore).when((Object)spiedFs)).getAbfsStore();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)spiedClient).when((Object)spiedStore)).getClient();
        ((AbfsBlobClient)Mockito.doThrow((Throwable[])new Throwable[]{new SocketException("Connection reset")}).when((Object)spiedClient)).filterRenamePendingFiles((BlobListResultSchema)ArgumentMatchers.any(), (URI)ArgumentMatchers.any());
        ArrayList fileStatuses = new ArrayList();
        AbfsDriverException ex = (AbfsDriverException)LambdaTestUtils.intercept(AbfsDriverException.class, () -> spiedStore.listStatus(new Path("/"), "", fileStatuses, true, null, this.getTestTracingContext(spiedFs, true)));
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("Expecting Network Error status code", new Object[0])).isEqualTo(-1);
        ((AbstractStringAssert)Assertions.assertThat((String)ex.getErrorMessage()).describedAs("Expecting COPY_ABORTED error code", new Object[0])).contains(new CharSequence[]{"Parsing of XML List Response Failed in BlobClient."});
    }

    @Test
    public void testListFileVsListDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = this.path("/testFile");
        try (FSDataOutputStream ignored = fs.create(path);){
            FileStatus[] testFiles = fs.listStatus(path);
            ITestAzureBlobFileSystemListStatus.assertEquals((int)1, (int)testFiles.length, (String)"length of test files");
            FileStatus status = testFiles[0];
            this.assertIsFileReference(status);
        }
    }

    @Test
    public void testListFileVsListDir2() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolder = this.path("/testFolder");
        fs.mkdirs(testFolder);
        fs.mkdirs(new Path(testFolder + "/testFolder2"));
        fs.mkdirs(new Path(testFolder + "/testFolder2/testFolder3"));
        Path testFile0Path = new Path(testFolder + "/testFolder2/testFolder3/testFile");
        ContractTestUtils.touch((FileSystem)fs, (Path)testFile0Path);
        FileStatus[] testFiles = fs.listStatus(testFile0Path);
        ITestAzureBlobFileSystemListStatus.assertEquals((int)1, (int)testFiles.length, (String)("Wrong listing size of file " + testFile0Path));
        FileStatus file0 = testFiles[0];
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)new Path(this.getTestUrl(), testFolder + "/testFolder2/testFolder3/testFile"), (Object)file0.getPath(), (String)("Wrong path for " + file0));
        this.assertIsFileReference(file0);
    }

    @Test
    public void testListNonExistentDir() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> {
            AzureBlobFileSystem fs = this.getFileSystem();
            fs.listStatus(new Path("/testFile/"));
        });
    }

    @Test
    public void testListFiles() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testDir = this.path("/test");
        fs.mkdirs(testDir);
        FileStatus[] fileStatuses = fs.listStatus(new Path("/"));
        ITestAzureBlobFileSystemListStatus.assertEquals((int)1, (int)fileStatuses.length);
        fs.mkdirs(new Path(testDir + "/sub"));
        fileStatuses = fs.listStatus(testDir);
        ITestAzureBlobFileSystemListStatus.assertEquals((int)1, (int)fileStatuses.length);
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"sub", (Object)fileStatuses[0].getPath().getName());
        this.assertIsDirectoryReference(fileStatuses[0]);
        Path childF = fs.makeQualified(new Path(testDir + "/f"));
        this.touch(childF);
        fileStatuses = fs.listStatus(testDir);
        ITestAzureBlobFileSystemListStatus.assertEquals((int)2, (int)fileStatuses.length);
        FileStatus childStatus = fileStatuses[0];
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)childF, (Object)childStatus.getPath());
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"f", (Object)childStatus.getPath().getName());
        this.assertIsFileReference(childStatus);
        ITestAzureBlobFileSystemListStatus.assertEquals((long)0L, (long)childStatus.getLen());
        FileStatus status1 = fileStatuses[1];
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"sub", (Object)status1.getPath().getName());
        this.assertIsDirectoryReference(status1);
        LocatedFileStatus locatedChildStatus = (LocatedFileStatus)fs.listFiles(childF, false).next();
        this.assertIsFileReference((FileStatus)locatedChildStatus);
        fs.delete(testDir, true);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> (LocatedFileStatus)fs.listFiles(childF, false).next());
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)childF, (Object)locatedChildStatus.getPath(), (String)("Path mismatch of " + locatedChildStatus));
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)locatedChildStatus, (Object)childStatus, (String)"locatedstatus.equals(status)");
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)childStatus, (Object)locatedChildStatus, (String)"status.equals(locatedstatus)");
    }

    private void assertIsDirectoryReference(FileStatus status) {
        ITestAzureBlobFileSystemListStatus.assertTrue((boolean)status.isDirectory(), (String)("Not a directory: " + status));
        ITestAzureBlobFileSystemListStatus.assertFalse((boolean)status.isFile(), (String)("Not a directory: " + status));
        ITestAzureBlobFileSystemListStatus.assertEquals((long)0L, (long)status.getLen());
    }

    private void assertIsFileReference(FileStatus status) {
        ITestAzureBlobFileSystemListStatus.assertFalse((boolean)status.isDirectory(), (String)("Not a file: " + status));
        ITestAzureBlobFileSystemListStatus.assertTrue((boolean)status.isFile(), (String)("Not a file: " + status));
    }

    @Test
    public void testMkdirTrailingPeriodDirName() throws IOException {
        boolean exceptionThrown = false;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path nontrailingPeriodDir = this.path("testTrailingDir/dir");
        Path trailingPeriodDir = new Path("testMkdirTrailingDir/dir.");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)nontrailingPeriodDir);
        try {
            fs.mkdirs(trailingPeriodDir);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        ITestAzureBlobFileSystemListStatus.assertTrue((boolean)exceptionThrown, (String)"Attempt to create file that ended with a dot should throw IllegalArgumentException");
    }

    @Test
    public void testCreateTrailingPeriodFileName() throws IOException {
        boolean exceptionThrown = false;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path trailingPeriodFile = new Path("testTrailingDir/file.");
        Path nontrailingPeriodFile = this.path("testCreateTrailingDir/file");
        ContractTestUtils.createFile((FileSystem)fs, (Path)nontrailingPeriodFile, (boolean)false, (byte[])new byte[0]);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Trailing period file does not exist", (Path)nontrailingPeriodFile);
        try {
            ContractTestUtils.createFile((FileSystem)fs, (Path)trailingPeriodFile, (boolean)false, (byte[])new byte[0]);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        ITestAzureBlobFileSystemListStatus.assertTrue((boolean)exceptionThrown, (String)"Attempt to create file that ended with a dot should throw IllegalArgumentException");
    }

    @Test
    public void testRenameTrailingPeriodFile() throws IOException {
        boolean exceptionThrown = false;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path nonTrailingPeriodFile = this.path("testTrailingDir/file");
        Path trailingPeriodFile = new Path("testRenameTrailingDir/file.");
        ContractTestUtils.createFile((FileSystem)fs, (Path)nonTrailingPeriodFile, (boolean)false, (byte[])new byte[0]);
        try {
            ContractTestUtils.rename((FileSystem)fs, (Path)nonTrailingPeriodFile, (Path)trailingPeriodFile);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        ITestAzureBlobFileSystemListStatus.assertTrue((boolean)exceptionThrown, (String)"Attempt to create file that ended with a dot should throw IllegalArgumentException");
    }

    @Test
    public void testEmptyListingInSubsequentCall() throws IOException {
        this.testEmptyListingInSubsequentCallInternal("", true, "", true, 1, 0);
        this.testEmptyListingInSubsequentCallInternal("", true, "", false, 1, 0);
        this.testEmptyListingInSubsequentCallInternal("", true, TEST_CONTINUATION_TOKEN, true, 1, 0);
        this.testEmptyListingInSubsequentCallInternal("", true, TEST_CONTINUATION_TOKEN, false, 1, 0);
        this.testEmptyListingInSubsequentCallInternal(TEST_CONTINUATION_TOKEN, true, "", true, 2, 0);
        this.testEmptyListingInSubsequentCallInternal(TEST_CONTINUATION_TOKEN, true, "", false, 2, 1);
        this.testEmptyListingInSubsequentCallInternal("continuation1", true, "continuation2", true, 3, 0);
        this.testEmptyListingInSubsequentCallInternal("continuation1", true, "continuation2", false, 3, 1);
        this.testEmptyListingInSubsequentCallInternal("", false, "", true, 1, 1);
        this.testEmptyListingInSubsequentCallInternal("", false, "", false, 1, 1);
        this.testEmptyListingInSubsequentCallInternal("", false, TEST_CONTINUATION_TOKEN, true, 1, 1);
        this.testEmptyListingInSubsequentCallInternal("", false, TEST_CONTINUATION_TOKEN, false, 1, 1);
        this.testEmptyListingInSubsequentCallInternal(TEST_CONTINUATION_TOKEN, false, "", true, 2, 1);
        this.testEmptyListingInSubsequentCallInternal(TEST_CONTINUATION_TOKEN, false, "", false, 2, 2);
        this.testEmptyListingInSubsequentCallInternal("continuation1", false, "continuation2", true, 3, 1);
        this.testEmptyListingInSubsequentCallInternal("continuation1", false, "continuation2", false, 3, 2);
    }

    private void testEmptyListingInSubsequentCallInternal(String firstCT, boolean isfirstEmpty, String secondCT, boolean isSecondEmpty, int expectedInvocations, int expectedSize) throws IOException {
        this.assumeBlobServiceType();
        AzureBlobFileSystem spiedFs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore spiedStore = (AzureBlobFileSystemStore)Mockito.spy((Object)spiedFs.getAbfsStore());
        spiedStore.getAbfsConfiguration().setListMaxResults(1);
        AbfsBlobClient spiedClient = (AbfsBlobClient)Mockito.spy((Object)spiedStore.getClientHandler().getBlobClient());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)spiedStore).when((Object)spiedFs)).getAbfsStore();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)spiedClient).when((Object)spiedStore)).getClient();
        spiedFs.mkdirs(new Path("/testPath"));
        VersionedFileStatus status1 = new VersionedFileStatus("owner", "group", null, false, 0L, false, 0, 0L, 0L, new Path("/testPath/file1"), "version", "encryptionContext");
        VersionedFileStatus status2 = new VersionedFileStatus("owner", "group", null, false, 0L, false, 0, 0L, 0L, new Path("/testPath/file2"), "version", "encryptionContext");
        ArrayList<VersionedFileStatus> mockedList1 = new ArrayList<VersionedFileStatus>();
        mockedList1.add(status1);
        ArrayList<VersionedFileStatus> mockedList2 = new ArrayList<VersionedFileStatus>();
        mockedList2.add(status2);
        ListResponseData listResponseData1 = new ListResponseData();
        listResponseData1.setContinuationToken(firstCT);
        listResponseData1.setFileStatusList((List)(isfirstEmpty ? new ArrayList<VersionedFileStatus>() : mockedList1));
        listResponseData1.setOp((AbfsRestOperation)Mockito.mock(AbfsRestOperation.class));
        ListResponseData listResponseData2 = new ListResponseData();
        listResponseData2.setContinuationToken(secondCT);
        listResponseData2.setFileStatusList((List)(isSecondEmpty ? new ArrayList<VersionedFileStatus>() : mockedList2));
        listResponseData2.setOp((AbfsRestOperation)Mockito.mock(AbfsRestOperation.class));
        ListResponseData listResponseData3 = new ListResponseData();
        listResponseData3.setContinuationToken("");
        listResponseData3.setFileStatusList(new ArrayList());
        listResponseData3.setOp((AbfsRestOperation)Mockito.mock(AbfsRestOperation.class));
        int[] itr = new int[1];
        String[] continuationTokenUsed = new String[3];
        ((AbfsBlobClient)Mockito.doAnswer(invocationOnMock -> {
            if (itr[0] == 0) {
                itr[0] = itr[0] + 1;
                continuationTokenUsed[0] = (String)invocationOnMock.getArgument(3);
                return listResponseData1;
            }
            if (itr[0] == 1) {
                itr[0] = itr[0] + 1;
                continuationTokenUsed[1] = (String)invocationOnMock.getArgument(3);
                return listResponseData2;
            }
            continuationTokenUsed[2] = (String)invocationOnMock.getArgument(3);
            return listResponseData3;
        }).when((Object)spiedClient)).listPath((String)ArgumentMatchers.eq((Object)"/testPath"), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(TracingContext.class), (URI)ArgumentMatchers.any());
        Object[] list = spiedFs.listStatus(new Path("/testPath"));
        ((AbfsBlobClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)expectedInvocations))).listPath((String)ArgumentMatchers.eq((Object)"/testPath"), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(TracingContext.class), (URI)ArgumentMatchers.any());
        ((AbfsBlobClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)1))).postListProcessing((String)ArgumentMatchers.eq((Object)"/testPath"), (List)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(), (URI)ArgumentMatchers.any());
        Assertions.assertThat((Object[])list).hasSize(expectedSize);
        if (expectedSize == 0) {
            ((AbfsBlobClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)1))).getPathStatus((String)ArgumentMatchers.eq((Object)"/testPath"), (TracingContext)ArgumentMatchers.any(), (ContextEncryptionAdapter)ArgumentMatchers.eq(null), ArgumentMatchers.eq((boolean)false));
        } else {
            ((AbfsBlobClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)0))).getPathStatus((String)ArgumentMatchers.eq((Object)"/testPath"), (TracingContext)ArgumentMatchers.any(), (ContextEncryptionAdapter)ArgumentMatchers.eq(null), ArgumentMatchers.eq((boolean)false));
        }
        ((AbstractStringAssert)Assertions.assertThat((String)continuationTokenUsed[0]).describedAs("First continuation token used is not as expected", new Object[0])).isNull();
        if (expectedInvocations > 1) {
            ((AbstractStringAssert)Assertions.assertThat((String)continuationTokenUsed[1]).describedAs("Second continuation token used is not as expected", new Object[0])).isEqualTo((Object)firstCT);
        }
        if (expectedInvocations > 2) {
            ((AbstractStringAssert)Assertions.assertThat((String)continuationTokenUsed[2]).describedAs("Third continuation token used is not as expected", new Object[0])).isEqualTo((Object)secondCT);
        }
    }

    @Test
    public void testListStatusWithImplicitExplicitChildren() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.setWorkingDirectory(new Path("/"));
        Path root = new Path("/");
        Path dir = new Path("a");
        Path fileInsideDir = new Path("a/file");
        this.createAzCopyFolder(dir);
        FileStatus[] fileStatuses = fs.listStatus(root);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List size is not expected", new Object[0])).isEqualTo(1);
        this.assertImplicitDirectoryFileStatus(fileStatuses[0], fs.makeQualified(dir));
        fs.create(fileInsideDir);
        fileStatuses = fs.listStatus(root);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List size is not expected", new Object[0])).isEqualTo(1);
        this.assertExplicitDirectoryFileStatus(fileStatuses[0], fs.makeQualified(dir));
        Path file1 = new Path("b");
        fs.create(file1);
        fileStatuses = fs.listStatus(root);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List size is not expected", new Object[0])).isEqualTo(2);
        this.assertExplicitDirectoryFileStatus(fileStatuses[0], fs.makeQualified(dir));
        this.assertFilePathFileStatus(fileStatuses[1], fs.makeQualified(file1));
        Path dir2 = new Path("c");
        this.createAzCopyFolder(dir2);
        fileStatuses = fs.listStatus(root);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List size is not expected", new Object[0])).isEqualTo(3);
        this.assertExplicitDirectoryFileStatus(fileStatuses[0], fs.makeQualified(dir));
        this.assertFilePathFileStatus(fileStatuses[1], fs.makeQualified(file1));
        this.assertImplicitDirectoryFileStatus(fileStatuses[2], fs.makeQualified(dir2));
    }

    @Test
    public void testListStatusOnImplicitDirectoryPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path implicitPath = new Path("/implicitDir");
        this.createAzCopyFolder(implicitPath);
        FileStatus[] statuses = fs.listStatus(implicitPath);
        ((AbstractIntegerAssert)Assertions.assertThat((int)statuses.length).describedAs("List size is not expected", new Object[0])).isGreaterThanOrEqualTo(1);
        this.assertImplicitDirectoryFileStatus(statuses[0], fs.makeQualified(statuses[0].getPath()));
        FileStatus[] statuses1 = fs.listStatus(new Path(statuses[0].getPath().toString()));
        ((AbstractIntegerAssert)Assertions.assertThat((int)statuses1.length).describedAs("List size is not expected", new Object[0])).isGreaterThanOrEqualTo(1);
        this.assertFilePathFileStatus(statuses1[0], fs.makeQualified(statuses1[0].getPath()));
    }

    @Test
    public void testListStatusOnEmptyDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path emptyDir = new Path("/emptyDir");
        fs.mkdirs(emptyDir);
        FileStatus[] statuses = fs.listStatus(emptyDir);
        ((AbstractIntegerAssert)Assertions.assertThat((int)statuses.length).describedAs("List size is not expected", new Object[0])).isEqualTo(0);
    }

    @Test
    public void testListStatusOnRenamePendingJsonFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path renamePendingJsonPath = new Path("/hbase/A/A--RenamePending.json");
        fs.create(renamePendingJsonPath);
        FileStatus[] statuses = fs.listStatus(renamePendingJsonPath);
        ((AbstractIntegerAssert)Assertions.assertThat((int)statuses.length).describedAs("List size is not expected", new Object[0])).isEqualTo(1);
        this.assertFilePathFileStatus(statuses[0], fs.makeQualified(statuses[0].getPath()));
    }

    @Test
    public void testContinuationTokenAcrossListStatus() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("/testContinuationToken");
        fs.mkdirs(path);
        fs.create(new Path(path + "/file1"));
        fs.create(new Path(path + "/file2"));
        fs.listStatus(path);
        ListResponseData listResponseData = fs.getAbfsStore().getClient().listPath("/testContinuationToken", false, 1, null, this.getTestTracingContext(fs, true), fs.getAbfsStore().getUri());
        ((AbstractStringAssert)Assertions.assertThat((String)listResponseData.getContinuationToken()).describedAs("Continuation Token Should not be null", new Object[0])).isNotNull();
        ((ListAssert)Assertions.assertThat((List)listResponseData.getFileStatusList()).describedAs("Listing Size Not as expected", new Object[0])).hasSize(1);
        ListResponseData listResponseData1 = fs.getAbfsStore().getClient().listPath("/testContinuationToken", false, 1, listResponseData.getContinuationToken(), this.getTestTracingContext(fs, true), fs.getAbfsStore().getUri());
        ((AbstractStringAssert)Assertions.assertThat((String)listResponseData1.getContinuationToken()).describedAs("Continuation Token Should be null", new Object[0])).isNull();
        ((ListAssert)Assertions.assertThat((List)listResponseData1.getFileStatusList()).describedAs("Listing Size Not as expected", new Object[0])).hasSize(1);
    }

    @Test
    public void testInvalidContinuationToken() throws Exception {
        this.assumeHnsDisabled();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("/testInvalidContinuationToken");
        fs.mkdirs(path);
        fs.create(new Path(path + "/file1"));
        fs.create(new Path(path + "/file2"));
        LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.getAbfsStore().getClient().listPath("/testInvalidContinuationToken", false, 1, "invalidToken", this.getTestTracingContext(fs, true), fs.getAbfsStore().getUri()));
    }

    @Test
    public void testEmptyContinuationToken() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("/testInvalidContinuationToken");
        fs.mkdirs(path);
        fs.create(new Path(path + "/file1"));
        fs.create(new Path(path + "/file2"));
        ListResponseData listResponseData = fs.getAbfsStore().getClient().listPath("/testInvalidContinuationToken", false, 1, "", this.getTestTracingContext(fs, true), fs.getAbfsStore().getUri());
        ((AbstractStringAssert)Assertions.assertThat((String)listResponseData.getContinuationToken()).describedAs("Continuation Token Should Not be null", new Object[0])).isNotNull();
        ((ListAssert)Assertions.assertThat((List)listResponseData.getFileStatusList()).describedAs("Listing Size Not as expected", new Object[0])).hasSize(1);
    }

    @Test
    public void testDuplicateEntriesAcrossListBlobIterations() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        store.getAbfsConfiguration().setListMaxResults(1);
        AbfsClient client = (AbfsClient)Mockito.spy((Object)store.getClient());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        this.createAzCopyFolder(new Path("/A"));
        fs.create(new Path("/a/file1"));
        fs.create(new Path("/b"));
        fs.create(new Path("/c/file3"));
        fs.create(new Path("/c.bak/file2"));
        this.createAzCopyFolder(new Path("/d"));
        fs.create(new Path("/e/file4"));
        FileStatus[] fileStatuses = fs.listStatus(new Path("/"));
        ((AbfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)11))).listPath((String)ArgumentMatchers.eq((Object)"/"), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(), (URI)ArgumentMatchers.any());
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatuses.length).describedAs("List size is not expected", new Object[0])).isEqualTo(7);
        this.assertImplicitDirectoryFileStatus(fileStatuses[0], fs.makeQualified(new Path("/A")));
        this.assertExplicitDirectoryFileStatus(fileStatuses[1], fs.makeQualified(new Path("/a")));
        this.assertFilePathFileStatus(fileStatuses[2], fs.makeQualified(new Path("/b")));
        this.assertExplicitDirectoryFileStatus(fileStatuses[3], fs.makeQualified(new Path("/c")));
        this.assertExplicitDirectoryFileStatus(fileStatuses[4], fs.makeQualified(new Path("/c.bak")));
        this.assertImplicitDirectoryFileStatus(fileStatuses[5], fs.makeQualified(new Path("/d")));
        this.assertExplicitDirectoryFileStatus(fileStatuses[6], fs.makeQualified(new Path("/e")));
        HashSet<Path> uniquePaths = new HashSet<Path>();
        for (FileStatus fileStatus : fileStatuses) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)uniquePaths.add(fileStatus.getPath())).describedAs("Duplicate Entries found", new Object[0])).isTrue();
        }
    }

    private void assertFilePathFileStatus(FileStatus fileStatus, Path qualifiedPath) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)fileStatus.getPath()).describedAs("Path Not as expected", new Object[0])).isEqualTo((Object)qualifiedPath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileStatus.isFile()).describedAs("Expecting a File Path", new Object[0])).isEqualTo(true);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileStatus.isDirectory()).describedAs("Expecting a File Path", new Object[0])).isEqualTo(false);
        Assertions.assertThat((long)fileStatus.getModificationTime()).isNotEqualTo(0L);
    }

    private void assertImplicitDirectoryFileStatus(FileStatus fileStatus, Path qualifiedPath) throws Exception {
        this.assertDirectoryFileStatus(fileStatus, qualifiedPath);
        DirectoryStateHelper.isImplicitDirectory(qualifiedPath, this.getFileSystem(), this.getTestTracingContext(this.getFileSystem(), true));
        ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getModificationTime()).describedAs("Last Modified Time Not as Expected", new Object[0])).isEqualTo(0L);
    }

    private void assertExplicitDirectoryFileStatus(FileStatus fileStatus, Path qualifiedPath) throws Exception {
        this.assertDirectoryFileStatus(fileStatus, qualifiedPath);
        DirectoryStateHelper.isExplicitDirectory(qualifiedPath, this.getFileSystem(), this.getTestTracingContext(this.getFileSystem(), true));
        ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getModificationTime()).describedAs("Last Modified Time Not as Expected", new Object[0])).isNotEqualTo(0L);
    }

    private void assertDirectoryFileStatus(FileStatus fileStatus, Path qualifiedPath) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)fileStatus.getPath()).describedAs("Path Not as Expected", new Object[0])).isEqualTo((Object)qualifiedPath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileStatus.isDirectory()).describedAs("Expecting a Directory Path", new Object[0])).isEqualTo(true);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileStatus.isFile()).describedAs("Expecting a Directory Path", new Object[0])).isEqualTo(false);
        ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getLen()).describedAs("Content Length Not as Expected", new Object[0])).isEqualTo(0L);
    }

    public static void mockAbfsRestOperation(AbfsBlobClient abfsBlobClient, String ... newHeader) {
        ((AbfsBlobClient)Mockito.doAnswer(invocation -> {
            List requestHeaders = (List)invocation.getArgument(3);
            requestHeaders.removeIf(header -> "x-ms-meta-hdi_isfolder".equals(header.getName()));
            for (String header2 : newHeader) {
                requestHeaders.add(new AbfsHttpHeader("x-ms-meta-" + header2, "true"));
            }
            return invocation.callRealMethod();
        }).when((Object)abfsBlobClient)).getAbfsRestOperation((AbfsRestOperationType)ArgumentMatchers.eq((Object)AbfsRestOperationType.PutBlob), (String)ArgumentMatchers.eq((Object)"PUT"), (URL)ArgumentMatchers.any(URL.class), ArgumentMatchers.anyList());
    }

    public static AbfsBlobClient mockIngressClientHandler(AzureBlobFileSystem fs) {
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.spy((Object)store.getClientHandler());
        AbfsBlobClient abfsBlobClient = (AbfsBlobClient)Mockito.spy((Object)clientHandler.getClient());
        fs.getAbfsStore().setClient((AbfsClient)abfsBlobClient);
        fs.getAbfsStore().setClientHandler(clientHandler);
        ((AbfsClientHandler)Mockito.doReturn((Object)abfsBlobClient).when((Object)clientHandler)).getIngressClient();
        return abfsBlobClient;
    }

    private void testIsDirectory(boolean expected, String ... configName) throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getFileSystem().getConf())));){
            this.assumeBlobServiceType();
            AbfsBlobClient abfsBlobClient = ITestAzureBlobFileSystemListStatus.mockIngressClientHandler(fs);
            ITestAzureBlobFileSystemListStatus.mockAbfsRestOperation(abfsBlobClient, configName);
            Path path = new Path("/testPath");
            fs.mkdirs(path);
            FileStatus[] fileStatus = fs.listStatus(path.getParent());
            AbfsHttpOperation op = abfsBlobClient.getPathStatus(path.toUri().getPath(), true, this.getTestTracingContext(fs, true), null).getResult();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfsBlobClient.checkIsDir(op)).describedAs("Directory should be marked as " + expected, new Object[0])).isEqualTo(expected);
            ((AbstractIntegerAssert)Assertions.assertThat((int)fileStatus.length).describedAs("Expected directory state: " + expected, new Object[0])).isEqualTo(1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileStatus[0].isDirectory()).describedAs("Expected directory state: " + expected, new Object[0])).isEqualTo(expected);
            fs.delete(path, true);
        }
    }

    @Test
    public void testIsDirectoryWithDifferentCases() throws Exception {
        this.testIsDirectory(true, "HDI_ISFOLDER");
        this.testIsDirectory(true, "Hdi_ISFOLDER");
        this.testIsDirectory(true, "Hdi_isfolder");
        this.testIsDirectory(true, "hdi_isfolder");
        this.testIsDirectory(false, "Hdi_isfolder1");
        this.testIsDirectory(true, "HDI_ISFOLDER", "Hdi_ISFOLDER", "Hdi_isfolder");
        this.testIsDirectory(true, "HDI_ISFOLDER", "Hdi_ISFOLDER1", "Test");
    }
}

