/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.junit.jupiter.api.Test;

public class ITestAzureBlobFileSystemE2EScale
extends AbstractAbfsScaleTest {
    private static final int TEN = 10;
    private static final int ONE_THOUSAND = 1000;
    private static final int BASE_SIZE = 1024;
    private static final int ONE_MB = 0x100000;
    private static final int DEFAULT_WRITE_TIMES = 100;

    @Test
    public void testWriteHeavyBytesToFileAcrossThreads() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFile = this.path(this.methodName.getMethodName());
        final FSDataOutputStream stream = fs.create(testFile);
        ExecutorService es = Executors.newFixedThreadPool(10);
        int testWriteBufferSize = 20480000;
        final byte[] b = new byte[testWriteBufferSize];
        new Random().nextBytes(b);
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        int operationCount = 100;
        for (int i = 0; i < operationCount; ++i) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    stream.write(b);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        tasks.clear();
        stream.close();
        es.shutdownNow();
        FileStatus fileStatus = fs.getFileStatus(testFile);
        ITestAzureBlobFileSystemE2EScale.assertEquals((long)(testWriteBufferSize * operationCount), (long)fileStatus.getLen());
    }

    @Test
    public void testReadWriteHeavyBytesToFileWithStatistics() throws Exception {
        int bytesRead;
        byte[] sourceData;
        int testBufferSize;
        FileSystem.Statistics abfsStatistics;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFile = this.path(this.methodName.getMethodName());
        try (FSDataOutputStream stream = fs.create(testFile);){
            abfsStatistics = fs.getFsStatistics();
            abfsStatistics.reset();
            testBufferSize = 51200000;
            sourceData = new byte[testBufferSize];
            new Random().nextBytes(sourceData);
            stream.write(sourceData);
        }
        byte[] remoteData = new byte[testBufferSize];
        try (FSDataInputStream inputStream = fs.open(testFile, 0x400000);){
            bytesRead = inputStream.read(remoteData);
        }
        String stats = abfsStatistics.toString();
        ITestAzureBlobFileSystemE2EScale.assertEquals((long)remoteData.length, (long)abfsStatistics.getBytesRead(), (String)("Bytes read in " + stats));
        ITestAzureBlobFileSystemE2EScale.assertEquals((long)sourceData.length, (long)abfsStatistics.getBytesWritten(), (String)("bytes written in " + stats));
        ITestAzureBlobFileSystemE2EScale.assertEquals((int)testBufferSize, (int)bytesRead, (String)"bytesRead from read() call");
        ITestAzureBlobFileSystemE2EScale.assertArrayEquals((byte[])sourceData, (byte[])remoteData, (String)"round tripped data");
    }
}

