/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.MockIntercept;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsDriverException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConcurrentWriteOperationDetectedException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientTestUtil;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.apache.hadoop.fs.azurebfs.services.RenameAtomicity;
import org.apache.hadoop.fs.azurebfs.services.TestAbfsClient;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.DirectoryStateHelper;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.ReflectionUtils;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemCreate
extends AbstractAbfsIntegrationTest {
    private static final Path TEST_FILE_PATH = new Path("testfile");
    private static final String TEST_FOLDER_PATH = "testFolder";
    private static final String TEST_CHILD_FILE = "childFile";

    @Test
    public void testEnsureFileCreatedImmediately() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream out = fs.create(TEST_FILE_PATH);){
            ContractTestUtils.assertIsFile((FileSystem)fs, (Path)TEST_FILE_PATH);
        }
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)TEST_FILE_PATH);
    }

    @Test
    public void testCreateNonRecursive() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testFile = new Path(testFolderPath, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.MKDIR, false, 0));
        fs.mkdirs(testFolderPath);
        fs.registerListener(null);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }

    @Test
    public void testCreateNonRecursive1() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testFile = new Path(testFolderPath, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, FsPermission.getDefault(), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.mkdirs(testFolderPath);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }

    @Test
    public void testCreateNonRecursive2() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testFile = new Path(testFolderPath, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, FsPermission.getDefault(), false, 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.mkdirs(testFolderPath);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }

    @Test
    public void testCreateNonRecursiveWhenParentExist() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        fs.setWorkingDirectory(new Path("/"));
        Path createDirectoryPath = new Path("hbase/A");
        fs.mkdirs(createDirectoryPath);
        fs.createNonRecursive(new Path(createDirectoryPath, "B"), FsPermission.getDefault(), false, 1024, (short)1, 1024L, null);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(createDirectoryPath, "B"))).describedAs("File should be created", new Object[0])).isTrue();
        fs.close();
    }

    @Test
    public void testCreateNonRecursiveWhenParentNotExist() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        fs.setWorkingDirectory(new Path("/"));
        Path createDirectoryPath = new Path("A/");
        fs.mkdirs(createDirectoryPath);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.createNonRecursive(new Path("A/B/C"), FsPermission.getDefault(), false, 1024, (short)1, 1024L, null));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("A/B/C"))).describedAs("New File should not be created.", new Object[0])).isFalse();
        fs.close();
    }

    private AzureBlobFileSystem createJsonFile(Path path, Path renameJson) throws IOException {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        AbfsClient client = (AbfsClient)Mockito.spy((Object)store.getClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        fs.setWorkingDirectory(new Path("/"));
        fs.mkdirs(new Path(path, "test3"));
        VersionedFileStatus fileStatus = (VersionedFileStatus)fs.getFileStatus(path);
        new RenameAtomicity(path, new Path("/hbase/test4"), renameJson, this.getTestTracingContext(fs, true), fileStatus.getEtag(), client).preRename();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(renameJson)).describedAs("Rename Pending Json file should exist.", new Object[0])).isTrue();
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateNonRecursiveWhenParentNotExistAndRenamePendingExist() throws Exception {
        try (AzureBlobFileSystem fs = null;){
            Path path = new Path("/hbase/test1/test2");
            Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
            fs = this.createJsonFile(path, renameJson);
            fs.delete(path, true);
            Assertions.assertThat((boolean)fs.exists(renameJson)).isTrue();
            AzureBlobFileSystem finalFs = fs;
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> finalFs.createNonRecursive(new Path(path, "test4"), FsPermission.getDefault(), false, 1024, (short)1, 1024L, null));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)finalFs.exists(new Path(path, "test4"))).describedAs("New File should not be created.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)finalFs.exists(renameJson)).describedAs("Rename Pending Json file should be deleted.", new Object[0])).isFalse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateNonRecursiveWhenParentAndRenamePendingExist() throws Exception {
        try (AzureBlobFileSystem fs = null;){
            Path path = new Path("/hbase/test1/test2");
            Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
            AzureBlobFileSystem finalFs = fs = this.createJsonFile(path, renameJson);
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> finalFs.createNonRecursive(new Path(path, "test4"), FsPermission.getDefault(), false, 1024, (short)1, 1024L, null));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)finalFs.exists(path)).describedAs("Old path should be deleted.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)finalFs.exists(new Path(path, "test4"))).describedAs("New File should not be created.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)finalFs.exists(renameJson)).describedAs("Rename Pending Json file should be deleted.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)finalFs.exists(new Path("/hbase/test4"))).describedAs("Rename should be successful.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateOnRoot() throws Exception {
        Path testFile;
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> ITestAzureBlobFileSystemCreate.lambda$testCreateOnRoot$3(fs, testFile = this.path("/")));
        if (ex.getStatusCode() != 409) {
            throw ex;
        }
        ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.createNonRecursive(testFile, FsPermission.getDefault(), false, 1024, (short)1, 1024L, null));
        if (ex.getStatusCode() != 409) {
            throw ex;
        }
    }

    @Test
    public void testWriteAfterClose() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testPath = new Path(testFolderPath, TEST_CHILD_FILE);
        FSDataOutputStream out = fs.create(testPath);
        out.close();
        LambdaTestUtils.intercept(IOException.class, () -> out.write(97));
        LambdaTestUtils.intercept(IOException.class, () -> out.write(new byte[]{97}));
        out.flush();
        out.close();
    }

    @Test
    public void testTryWithResources() throws Throwable {
        block9: {
            AzureBlobFileSystem fs = this.getFileSystem();
            Path testFolderPath = this.path(TEST_FOLDER_PATH);
            Path testPath = new Path(testFolderPath, TEST_CHILD_FILE);
            try (FSDataOutputStream out = fs.create(testPath);){
                out.write(49);
                out.hsync();
                fs.delete(testPath, false);
                out.write(50);
                out.hsync();
                ITestAzureBlobFileSystemCreate.fail((String)"Expected a failure");
            }
            catch (IOException fnfe) {
                if (fs.getAbfsStore().isAppendBlobKey(fs.makeQualified(testPath).toString())) break block9;
                Throwable[] suppressed = fnfe.getSuppressed();
                ((AbstractIntegerAssert)Assertions.assertThat((int)suppressed.length).describedAs("suppressed count should be 1", new Object[0])).isEqualTo(1);
                Throwable inner = suppressed[0];
                if (!(inner instanceof IOException)) {
                    throw inner;
                }
                GenericTestUtils.assertExceptionContains((String)fnfe.getMessage(), (Throwable)inner);
            }
        }
    }

    @Test
    public void testFilterFSWriteAfterClose() throws Throwable {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path testPath = new Path(TEST_FOLDER_PATH, TEST_CHILD_FILE);
            FSDataOutputStream out = fs.create(testPath);
            LambdaTestUtils.intercept(IOException.class, () -> {
                FilterOutputStream fos = new FilterOutputStream((OutputStream)out);
                try {
                    byte[] bytes = new byte[0x800000];
                    fos.write(bytes);
                    fos.write(bytes);
                    fos.flush();
                    out.hsync();
                    fs.delete(testPath, false);
                    throw (IOException)LambdaTestUtils.intercept(IOException.class, () -> {
                        fos.write(98);
                        out.hsync();
                        return "hsync didn't raise an IOE";
                    });
                }
                catch (Throwable throwable) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
    }

    @Test
    public void testDefaultCreateOverwriteFileTest() throws Throwable {
        this.testCreateFileOverwrite(true);
        this.testCreateFileOverwrite(false);
    }

    public void testCreateFileOverwrite(boolean enableConditionalCreateOverwrite) throws Throwable {
        if (enableConditionalCreateOverwrite) {
            this.assumeHnsEnabled();
            this.assumeDfsServiceType();
            ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.getIngressServiceType()).as("DFS service type is required for this test", new Object[0])).isEqualTo((Object)AbfsServiceType.DFS);
        }
        try (AzureBlobFileSystem currentFs = this.getFileSystem();){
            Configuration config = new Configuration(this.getRawConfiguration());
            config.set("fs.azure.enable.conditional.create.overwrite", Boolean.toString(enableConditionalCreateOverwrite));
            config.set("fs.azure.enable.create.idempotency", "false");
            AzureBlobFileSystemStore store = currentFs.getAbfsStore();
            AbfsClient client = store.getClientHandler().getIngressClient();
            try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);){
                long totalConnectionMadeBeforeTest = (Long)fs.getInstrumentationMap().get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
                int createRequestCount = 0;
                Path nonOverwriteFile = new Path("/NonOverwriteTest_FileName_" + UUID.randomUUID().toString());
                fs.create(nonOverwriteFile, false);
                this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)(createRequestCount += client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs) ? 2 : 1), fs.getInstrumentationMap());
                fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE, false, 0));
                LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.create(nonOverwriteFile, false));
                fs.registerListener(null);
                this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)(createRequestCount += client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs) ? 2 : 1), fs.getInstrumentationMap());
                Path overwriteFilePath = new Path("/OverwriteTest_FileName_" + UUID.randomUUID().toString());
                fs.create(overwriteFilePath, true);
                this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)(createRequestCount += client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs) ? (enableConditionalCreateOverwrite ? 2 : 3) : 1), fs.getInstrumentationMap());
                fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE, true, 0));
                fs.create(overwriteFilePath, true);
                fs.registerListener(null);
                createRequestCount += client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs) ? 1 : 0;
                createRequestCount = enableConditionalCreateOverwrite ? (createRequestCount += 3) : (createRequestCount += client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs) ? 2 : 1);
                this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)createRequestCount, fs.getInstrumentationMap());
            }
        }
    }

    @Test
    public void testNegativeScenariosForCreateOverwriteDisabled() throws Throwable {
        this.assumeHnsEnabled();
        this.assumeDfsServiceType();
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.getIngressServiceType()).as("DFS service type is required for this test", new Object[0])).isEqualTo((Object)AbfsServiceType.DFS);
        try (AzureBlobFileSystem currentFs = this.getFileSystem();){
            Configuration config = new Configuration(this.getRawConfiguration());
            config.set("fs.azure.enable.conditional.create.overwrite", Boolean.toString(true));
            try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);){
                AbfsClient mockClient = ITestAbfsClient.getMockAbfsClient(fs.getAbfsStore().getClient(), fs.getAbfsStore().getAbfsConfiguration());
                AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
                Mockito.when((Object)clientHandler.getIngressClient()).thenReturn((Object)mockClient);
                Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)mockClient);
                AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
                ReflectionUtils.setFinalField(AzureBlobFileSystemStore.class, (Object)abfsStore, (String)"clientHandler", (Object)clientHandler);
                ReflectionUtils.setFinalField(AzureBlobFileSystemStore.class, (Object)abfsStore, (String)"client", (Object)mockClient);
                AbfsRestOperation successOp = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
                AbfsHttpOperation http200Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
                Mockito.when((Object)http200Op.getStatusCode()).thenReturn((Object)200);
                Mockito.when((Object)successOp.getResult()).thenReturn((Object)http200Op);
                AbfsRestOperationException conflictResponseEx = this.getMockAbfsRestOperationException(409);
                AbfsRestOperationException serverErrorResponseEx = this.getMockAbfsRestOperationException(500);
                AbfsRestOperationException fileNotFoundResponseEx = this.getMockAbfsRestOperationException(404);
                AbfsRestOperationException preConditionResponseEx = this.getMockAbfsRestOperationException(412);
                ((AbfsClient)Mockito.doCallRealMethod().when((Object)mockClient)).conditionalCreateOverwriteFile(ArgumentMatchers.anyString(), (FileSystem.Statistics)Mockito.nullable(FileSystem.Statistics.class), (AzureBlobFileSystemStore.Permissions)Mockito.nullable(AzureBlobFileSystemStore.Permissions.class), ArgumentMatchers.anyBoolean(), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.nullable(TracingContext.class));
                ((AbfsClient)Mockito.doThrow((Throwable[])new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).when((Object)mockClient)).createPath((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false), (AzureBlobFileSystemStore.Permissions)ArgumentMatchers.any(AzureBlobFileSystemStore.Permissions.class), ((Boolean)ArgumentMatchers.any(Boolean.TYPE)).booleanValue(), (String)ArgumentMatchers.eq(null), (ContextEncryptionAdapter)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
                ((AbfsClient)Mockito.doThrow((Throwable[])new Throwable[]{fileNotFoundResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).doReturn((Object)successOp).doReturn((Object)successOp).when((Object)mockClient)).getPathStatus((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)false), (TracingContext)ArgumentMatchers.any(TracingContext.class), (ContextEncryptionAdapter)ArgumentMatchers.nullable(ContextEncryptionAdapter.class));
                ((AbfsClient)Mockito.doThrow((Throwable[])new Throwable[]{preConditionResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).when((Object)mockClient)).createPath((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true), (AzureBlobFileSystemStore.Permissions)ArgumentMatchers.any(AzureBlobFileSystemStore.Permissions.class), ((Boolean)ArgumentMatchers.any(Boolean.TYPE)).booleanValue(), (String)ArgumentMatchers.eq(null), (ContextEncryptionAdapter)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
                if (mockClient instanceof AbfsBlobClient) {
                    ((AbfsBlobClient)Mockito.doReturn((Object)false).when((Object)((AbfsBlobClient)mockClient))).isNonEmptyDirectory(ArgumentMatchers.anyString(), (TracingContext)Mockito.nullable(TracingContext.class));
                    ((AbfsBlobClient)Mockito.doNothing().when((Object)((AbfsBlobClient)mockClient))).tryMarkerCreation(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (String)Mockito.nullable(String.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.nullable(TracingContext.class));
                    ((AbfsBlobClient)Mockito.doThrow((Throwable[])new Throwable[]{preConditionResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).when((Object)((AbfsBlobClient)mockClient))).createPathRestOp((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true), ((Boolean)ArgumentMatchers.any(Boolean.TYPE)).booleanValue(), (String)ArgumentMatchers.eq(null), (ContextEncryptionAdapter)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
                    ((AbfsBlobClient)Mockito.doThrow((Throwable[])new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).when((Object)((AbfsBlobClient)mockClient))).createPathRestOp((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false), ((Boolean)ArgumentMatchers.any(Boolean.TYPE)).booleanValue(), (String)ArgumentMatchers.eq(null), (ContextEncryptionAdapter)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
                    ((AbfsBlobClient)Mockito.doThrow((Throwable[])new Throwable[]{fileNotFoundResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).doReturn((Object)successOp).doReturn((Object)successOp).when((Object)((AbfsBlobClient)mockClient))).getPathStatus((String)ArgumentMatchers.any(String.class), (TracingContext)ArgumentMatchers.any(TracingContext.class), (ContextEncryptionAdapter)ArgumentMatchers.nullable(ContextEncryptionAdapter.class), ArgumentMatchers.eq((boolean)false));
                }
                this.validateCreateFileException(ConcurrentWriteOperationDetectedException.class, abfsStore);
                this.validateCreateFileException(AbfsRestOperationException.class, abfsStore);
                this.validateCreateFileException(ConcurrentWriteOperationDetectedException.class, abfsStore);
                this.validateCreateFileException(AbfsRestOperationException.class, abfsStore);
                this.validateCreateFileException(AbfsRestOperationException.class, abfsStore);
            }
        }
    }

    @Test
    public void testCreateMarkerFailExceptionIsSwallowed() throws Throwable {
        this.assumeBlobServiceType();
        try (AzureBlobFileSystem currentFs = this.getFileSystem();){
            Configuration config = new Configuration(this.getRawConfiguration());
            config.set("fs.azure.enable.conditional.create.overwrite", Boolean.toString(true));
            try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);){
                AbfsClient mockClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsClient());
                AzureBlobFileSystemStore spiedStore = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
                spiedStore.setClient(mockClient);
                AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
                Mockito.when((Object)clientHandler.getIngressClient()).thenReturn((Object)mockClient);
                Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)mockClient);
                Path testFolder = new Path("/dir1");
                this.createAzCopyFolder(testFolder);
                AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
                ReflectionUtils.setFinalField(AzureBlobFileSystemStore.class, (Object)abfsStore, (String)"clientHandler", (Object)clientHandler);
                ReflectionUtils.setFinalField(AzureBlobFileSystemStore.class, (Object)abfsStore, (String)"client", (Object)mockClient);
                AbfsRestOperation successOp = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
                AbfsHttpOperation http200Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
                Mockito.when((Object)http200Op.getStatusCode()).thenReturn((Object)200);
                Mockito.when((Object)successOp.getResult()).thenReturn((Object)http200Op);
                final AbfsRestOperationException preConditionResponseEx = this.getMockAbfsRestOperationException(412);
                ((AbfsClient)Mockito.doCallRealMethod().when((Object)mockClient)).conditionalCreateOverwriteFile(ArgumentMatchers.anyString(), (FileSystem.Statistics)Mockito.nullable(FileSystem.Statistics.class), (AzureBlobFileSystemStore.Permissions)Mockito.nullable(AzureBlobFileSystemStore.Permissions.class), ArgumentMatchers.anyBoolean(), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.nullable(TracingContext.class));
                ((AbfsBlobClient)Mockito.doCallRealMethod().when((Object)((AbfsBlobClient)mockClient))).tryMarkerCreation(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (String)Mockito.nullable(String.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.nullable(TracingContext.class));
                ((AbfsBlobClient)Mockito.doReturn(new ArrayList<Path>(Collections.singletonList(testFolder))).when((Object)((AbfsBlobClient)mockClient))).getMarkerPathsTobeCreated((Path)ArgumentMatchers.any(Path.class), (TracingContext)Mockito.nullable(TracingContext.class));
                ((AbfsBlobClient)Mockito.doReturn((Object)false).when((Object)((AbfsBlobClient)mockClient))).isNonEmptyDirectory(ArgumentMatchers.anyString(), (TracingContext)Mockito.nullable(TracingContext.class));
                ((AbfsBlobClient)Mockito.doAnswer((Answer)new Answer<Void>(){
                    private boolean firstCall = true;

                    public Void answer(InvocationOnMock invocation) throws Throwable {
                        if (this.firstCall) {
                            this.firstCall = false;
                            throw preConditionResponseEx;
                        }
                        return null;
                    }
                }).doCallRealMethod().when((Object)((AbfsBlobClient)mockClient))).createPathRestOp(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (String)Mockito.nullable(String.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.nullable(TracingContext.class));
                AbfsClientTestUtil.hookOnRestOpsForTracingContextSingularity(mockClient);
                ((AbfsBlobClient)Mockito.doReturn((Object)successOp).when((Object)((AbfsBlobClient)mockClient))).getPathStatus((String)ArgumentMatchers.any(String.class), (TracingContext)ArgumentMatchers.any(TracingContext.class), (ContextEncryptionAdapter)ArgumentMatchers.nullable(ContextEncryptionAdapter.class), ArgumentMatchers.eq((boolean)false));
                FsPermission permission = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL);
                FsPermission umask = new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE);
                Path testPath = new Path("/dir1/testFile");
                abfsStore.createFile(testPath, null, true, permission, umask, this.getTestTracingContext(this.getFileSystem(), true));
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(testPath)).describedAs("File not created when marker creation failed.", new Object[0])).isTrue();
            }
        }
    }

    private <E extends Throwable> void validateCreateFileException(Class<E> exceptionClass, AzureBlobFileSystemStore abfsStore) throws Exception {
        FsPermission permission = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL);
        FsPermission umask = new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE);
        Path testPath = new Path("/testFile");
        LambdaTestUtils.intercept(exceptionClass, () -> abfsStore.createFile(testPath, null, true, permission, umask, this.getTestTracingContext(this.getFileSystem(), true)));
    }

    private AbfsRestOperationException getMockAbfsRestOperationException(int status) {
        return new AbfsRestOperationException(status, "", "", new Exception());
    }

    @Test
    public void testMultipleFlush() throws Throwable {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path testPath = new Path(TEST_FOLDER_PATH, TEST_CHILD_FILE);
            try (FSDataOutputStream out = fs.create(testPath);){
                out.write(49);
                out.hsync();
                out.write(50);
                out.hsync();
            }
        }
    }

    @Test
    public void testDeleteBeforeFlush() throws Throwable {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path testPath = new Path(TEST_FOLDER_PATH, TEST_CHILD_FILE);
            try (FSDataOutputStream out = fs.create(testPath);){
                out.write(49);
                fs.delete(testPath, false);
                out.hsync();
            }
            catch (IOException fnfe) {
                if (!fs.getAbfsStore().isAppendBlobKey(fs.makeQualified(testPath).toString())) {
                    Throwable[] suppressed = fnfe.getSuppressed();
                    ITestAzureBlobFileSystemCreate.assertEquals((int)1, (int)suppressed.length, (String)"suppressed count");
                    Throwable inner = suppressed[0];
                    if (!(inner instanceof IOException)) {
                        throw inner;
                    }
                    GenericTestUtils.assertExceptionContains((String)fnfe.getMessage(), (Throwable)inner.getCause(), (String)inner.getCause().getMessage());
                }
            }
        }
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.create(new Path("a/b/c"));
            fs.mkdirs(new Path("a/b/d"));
            LambdaTestUtils.intercept(IOException.class, () -> fs.mkdirs(new Path("a/b/c/d/e")));
            Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).isTrue();
            Assertions.assertThat((boolean)fs.exists(new Path("a/b/d"))).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a/b/d"), fs, this.getTestTracingContext(fs, true))).describedAs("Path is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirSameFolder() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.createAzCopyFolder(new Path("a/b/d"));
            fs.mkdirs(new Path("a/b/d"));
        }
    }

    @Test
    public void testCreateDirectoryAndFile() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a/b/c"));
            Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).isTrue();
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(new Path("a/b/c")));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a/b/c"), fs, this.getTestTracingContext(fs, true))).describedAs("Path is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateSameFile() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.create(new Path("a/b/c"));
            fs.create(new Path("a/b/c"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Path does not exist", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreationWithoutConditionalOverwrite() throws Exception {
        try (AzureBlobFileSystem currentFs = this.getFileSystem();){
            Configuration config = new Configuration(this.getRawConfiguration());
            config.set("fs.azure.enable.conditional.create.overwrite", String.valueOf(false));
            try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);){
                fs.mkdirs(new Path("a/b/c"));
                LambdaTestUtils.intercept(IOException.class, () -> fs.create(new Path("a/b/c"), true));
            }
        }
    }

    @Test
    public void testCreationOverwriteFalseWithoutConditionalOverwrite() throws Exception {
        try (AzureBlobFileSystem currentFs = this.getFileSystem();){
            Configuration config = new Configuration(this.getRawConfiguration());
            config.set("fs.azure.enable.conditional.create.overwrite", String.valueOf(false));
            try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);){
                fs.mkdirs(new Path("a/b/c"));
                LambdaTestUtils.intercept(IOException.class, () -> fs.create(new Path("a/b/c"), false));
            }
        }
    }

    @Test
    public void testCreateSameFileWithOverwriteFalse() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.create(new Path("a/b/c"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Path does not exist", new Object[0])).isTrue();
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(new Path("a/b/c"), false));
        }
    }

    @Test
    public void testCreateSubPath() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.create(new Path("a/b/c"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Path does not exist", new Object[0])).isTrue();
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(new Path("a/b")));
        }
    }

    @Test
    public void testParallelCreateOverwriteFalse() throws Exception {
        Configuration configuration = this.getRawConfiguration();
        configuration.set("fs.azure.enable.conditional.create.overwrite", "false");
        configuration.set("fs.azure.enable.create.blob.idempotency", "false");
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            ArrayList futures = new ArrayList();
            byte[] b = new byte[0x800000];
            new Random().nextBytes(b);
            Path filePath = this.path("/testPath");
            futures.add(executorService.submit(() -> {
                try {
                    fs.create(filePath, false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            futures.add(executorService.submit(() -> {
                try {
                    fs.create(filePath, false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            futures.add(executorService.submit(() -> {
                try {
                    fs.create(filePath, false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            this.checkFuturesForExceptions(futures, 2);
        }
    }

    @Test
    public void testParallelCreateOverwriteTrue() throws Exception {
        Configuration configuration = this.getRawConfiguration();
        configuration.set("fs.azure.enable.conditional.create.overwrite", "false");
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            ArrayList futures = new ArrayList();
            byte[] b = new byte[0x800000];
            new Random().nextBytes(b);
            Path filePath = this.path("/testPath");
            futures.add(executorService.submit(() -> {
                try {
                    fs.create(filePath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            futures.add(executorService.submit(() -> {
                try {
                    fs.create(filePath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            futures.add(executorService.submit(() -> {
                try {
                    fs.create(filePath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            this.checkFuturesForExceptions(futures, 0);
        }
    }

    @Test
    public void testCreatePathParentExplicit() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a/b/c"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Path does not exist", new Object[0])).isTrue();
            fs.create(new Path("a/b/c/d"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c/d"))).describedAs("Path does not exist", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a/b/c"), fs, this.getTestTracingContext(fs, true))).describedAs("Path is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateWithAppendBlobEnabled() throws IOException, NoSuchFieldException, IllegalAccessException {
        Configuration conf = this.getRawConfiguration();
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf)));){
            AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
            ((AzureBlobFileSystemStore)Mockito.doReturn((Object)true).when((Object)store)).isAppendBlobKey(ArgumentMatchers.anyString());
            Field privateField = AzureBlobFileSystem.class.getDeclaredField("abfsStore");
            privateField.setAccessible(true);
            privateField.set(fs, store);
            Path testPath = this.path("/testPath");
            AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
            fs.getAbfsStore().getClientHandler().getBlobClient().createPath(this.makeQualified(testPath).toUri().getPath(), true, false, permissions, true, null, null, this.getTestTracingContext(fs, true));
        }
    }

    @Test
    public void testParentExplicitPathImplicit() throws Exception {
        this.assumeBlobServiceType();
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("/explicitParent"));
            String sourcePathName = "/explicitParent/implicitDir";
            Path sourcePath = new Path(sourcePathName);
            this.createAzCopyFolder(sourcePath);
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(sourcePath, true));
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(sourcePath, false));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(sourcePath.getParent(), fs, this.getTestTracingContext(fs, true))).describedAs("Parent directory should be explicit.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(sourcePath, fs, this.getTestTracingContext(fs, true))).describedAs("Path should be implicit.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testParentImplicitPathImplicit() throws Exception {
        this.assumeBlobServiceType();
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            String parentPathName = "/implicitParent";
            Path parentPath = new Path(parentPathName);
            String sourcePathName = "/implicitParent/implicitDir";
            Path sourcePath = new Path(sourcePathName);
            this.createAzCopyFolder(parentPath);
            this.createAzCopyFolder(sourcePath);
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(sourcePath, true));
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(sourcePath, false));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(parentPath, fs, this.getTestTracingContext(fs, true))).describedAs("Parent directory is implicit.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(sourcePath, fs, this.getTestTracingContext(fs, true))).describedAs("Path should also be implicit.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateFileExistsImplicitParent() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            String parentPathName = "/implicitParent";
            Path parentPath = new Path(parentPathName);
            this.createAzCopyFolder(parentPath);
            String fileName = "/implicitParent/testFile";
            Path filePath = new Path(fileName);
            fs.create(filePath);
            String eTag = this.extractFileEtag(fileName);
            fs.create(filePath, true);
            String eTagAfterCreateOverwrite = this.extractFileEtag(fileName);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)eTag.equals(eTagAfterCreateOverwrite)).describedAs("New file eTag after create overwrite should be different from old", new Object[0])).isFalse();
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(filePath, false));
            String eTagAfterCreate = this.extractFileEtag(fileName);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)eTagAfterCreateOverwrite.equals(eTagAfterCreate)).describedAs("File eTag should not change as creation fails", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(parentPath, fs, this.getTestTracingContext(fs, true))).describedAs("Parent path should also change to explicit.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateFileExistsExplicitParent() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            String parentPathName = "/explicitParent";
            Path parentPath = new Path(parentPathName);
            fs.mkdirs(parentPath);
            String fileName = "/explicitParent/testFile";
            Path filePath = new Path(fileName);
            fs.create(filePath);
            String eTag = this.extractFileEtag(fileName);
            fs.create(filePath, true);
            String eTagAfterCreateOverwrite = this.extractFileEtag(fileName);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)eTag.equals(eTagAfterCreateOverwrite)).describedAs("New file eTag after create overwrite should be different from old", new Object[0])).isFalse();
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(filePath, false));
            String eTagAfterCreate = this.extractFileEtag(fileName);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)eTagAfterCreateOverwrite.equals(eTagAfterCreate)).describedAs("File eTag should not change as creation fails", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(parentPath, fs, this.getTestTracingContext(fs, true))).describedAs("Parent path should also change to explicit.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateFileParentFile() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            String parentName = "/testParentFile";
            Path parent = new Path(parentName);
            fs.create(parent);
            String childName = "/testParentFile/testChildFile";
            Path child = new Path(childName);
            IOException e = (IOException)LambdaTestUtils.intercept(IOException.class, () -> fs.create(child, false));
            FileStatus status = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path(parentName)), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path is not a file", new Object[0])).isFalse();
        }
    }

    @Test
    public void testCreateMkdirs() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.create(new Path("a/b/c"));
            LambdaTestUtils.intercept(IOException.class, () -> fs.mkdirs(new Path("a/b/c/d")));
        }
    }

    @Test
    public void testMkdirs() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a/b"));
            fs.mkdirs(new Path("a/b/c/d"));
            fs.mkdirs(new Path("a/b/c/e"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b"))).describedAs("Path a/b does not exist", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c/d"))).describedAs("Path a/b/c/d does not exist", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c/e"))).describedAs("Path a/b/c/e does not exist", new Object[0])).isTrue();
            FileStatus status = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a/b")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path a/b is not an explicit directory", new Object[0])).isTrue();
            FileStatus status1 = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a/b/c/d")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status1.isDirectory()).describedAs("Path a/b/c/d is not an explicit directory", new Object[0])).isTrue();
            FileStatus status2 = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a/b/c/e")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status2.isDirectory()).describedAs("Path a/b/c/e is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirsCreateSubPath() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a/b/c"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Path a/b/c does not exist", new Object[0])).isTrue();
            LambdaTestUtils.intercept(IOException.class, () -> fs.create(new Path("a/b")));
            FileStatus status2 = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a/b/c")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status2.isDirectory()).describedAs("Path a/b/c is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirsByLevel() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a"));
            fs.mkdirs(new Path("a/b/c"));
            fs.mkdirs(new Path("a/b/c/d/e"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a"))).describedAs("Path a does not exist", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Path a/b/c does not exist", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c/d/e"))).describedAs("Path a/b/c/d/e does not exist", new Object[0])).isTrue();
            FileStatus status = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a/")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path a is not an explicit directory", new Object[0])).isTrue();
            FileStatus status1 = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a/b/c")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status1.isDirectory()).describedAs("Path a/b/c is not an explicit directory", new Object[0])).isTrue();
            FileStatus status2 = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a/b/c/d/e")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status2.isDirectory()).describedAs("Path a/b/c/d/e is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirsWithDelete() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a/b"));
            fs.mkdirs(new Path("a/b/c/d"));
            fs.delete(new Path("a/b/c/d"));
            fs.getFileStatus(new Path("a/b/c"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Path a/b/c does not exist", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirsWithRename() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a/b/c/d"));
            fs.create(new Path("e/file"));
            fs.delete(new Path("a/b/c/d"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(new Path("e"), new Path("a/b/c/d"))).describedAs("Failed to rename path e to a/b/c/d", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c/d/file"))).describedAs("Path a/b/c/d/file does not exist", new Object[0])).isTrue();
        }
    }

    @Test
    public void testFileCreateMkdirsRoot() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.setWorkingDirectory(new Path("/"));
            Path p1 = new Path("dir1");
            fs.create(p1);
            LambdaTestUtils.intercept(IOException.class, () -> fs.mkdirs(new Path("dir1/dir2")));
        }
    }

    @Test
    public void testFileCreateMkdirsNonRoot() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path p1 = new Path("dir1");
            fs.create(p1);
            LambdaTestUtils.intercept(IOException.class, () -> fs.mkdirs(new Path("dir1/dir2")));
        }
    }

    @Test
    public void testCreateSameDirectory() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a/b/c"));
            fs.mkdirs(new Path("a/b/c"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Path a/b/c does not exist", new Object[0])).isTrue();
            FileStatus status = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a/b/c")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path a/b/c is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateSamePathDirectory() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.create(new Path("a"));
            LambdaTestUtils.intercept(IOException.class, () -> fs.mkdirs(new Path("a")));
        }
    }

    @Test
    public void testMkdirOnRootAsParent() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path path = new Path("a");
            fs.setWorkingDirectory(new Path("/"));
            fs.mkdirs(path);
            FileStatus status = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("a")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path a is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirOnRoot() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path path = new Path("/");
            fs.setWorkingDirectory(new Path("/"));
            fs.mkdirs(path);
            FileStatus status = fs.getAbfsStore().getFileStatus(fs.makeQualified(new Path("/")), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateUnicode() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path path = new Path("/file1");
            fs.create(path);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(path)).describedAs("Path with unicode does not exist", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirUnicode() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path path = new Path("/dir1");
            fs.mkdirs(path);
            FileStatus status = fs.getAbfsStore().getFileStatus(fs.makeQualified(path), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirParallelRequests() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path path = new Path("/dir1");
            ExecutorService es = Executors.newFixedThreadPool(3);
            ArrayList<CompletableFuture<Void>> tasks = new ArrayList<CompletableFuture<Void>>();
            for (int i = 0; i < 3; ++i) {
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    try {
                        fs.mkdirs(path);
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                }, es);
                tasks.add(future);
            }
            CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).join();
            FileStatus status = fs.getAbfsStore().getFileStatus(fs.makeQualified(path), new TracingContext(this.getTestTracingContext(fs, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateSameDirectoryOverwriteFalse() throws Exception {
        Configuration configuration = this.getRawConfiguration();
        configuration.setBoolean("fs.azure.enable.mkdir.overwrite", false);
        try (AzureBlobFileSystem fs1 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            fs1.mkdirs(new Path("a/b/c"));
            fs1.mkdirs(new Path("a/b/c"));
            FileStatus status = fs1.getAbfsStore().getFileStatus(fs1.makeQualified(new Path("a/b/c")), new TracingContext(this.getTestTracingContext(fs1, true)));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).describedAs("Path is not an explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateDirectoryAndFileRecreation() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            fs.mkdirs(new Path("a/b/c"));
            fs.create(new Path("a/b/c/d"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c"))).describedAs("Directory a/b/c does not exist", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("a/b/c/d"))).describedAs("File a/b/c/d does not exist", new Object[0])).isTrue();
            LambdaTestUtils.intercept(IOException.class, () -> fs.mkdirs(new Path("a/b/c/d")));
        }
    }

    @Test
    public void testCreateNonRecursiveForAtomicDirectoryFile() throws Exception {
        try (AzureBlobFileSystem fileSystem = this.getFileSystem();){
            fileSystem.setWorkingDirectory(new Path("/"));
            fileSystem.mkdirs(new Path("/hbase/dir"));
            fileSystem.createFile(new Path("/hbase/dir/file")).overwrite(false).replication((short)1).bufferSize(1024).blockSize(1024L).build();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileSystem.exists(new Path("/hbase/dir/file"))).describedAs("File /hbase/dir/file does not exist", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateOnNonExistingPathWithImplicitParentDir() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path implicitPath = new Path("dir1");
            Path path = new Path("dir1/dir2");
            this.createAzCopyFolder(implicitPath);
            fs.create(path);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(path)).describedAs("File dir1/dir2 does not exist", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirOnNonExistingPathWithImplicitParentDir() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path implicitPath = new Path("dir1");
            Path path = new Path("dir1/dir2");
            this.createAzCopyFolder(implicitPath);
            fs.mkdirs(path);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(implicitPath, fs, this.getTestTracingContext(fs, true))).describedAs("Path created by azcopy did not become explicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(path, fs, this.getTestTracingContext(fs, true))).describedAs("Directory created by mkdir does not exist as explicit", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirOnExistingExplicitDirWithImplicitParentDir() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path implicitPath = new Path("dir1");
            Path path = new Path("dir1/dir2");
            this.createAzCopyFolder(implicitPath);
            fs.mkdirs(path);
            fs.mkdirs(path);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(implicitPath, fs, this.getTestTracingContext(fs, true))).describedAs("Path created by azcopy did not become explicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(path, fs, this.getTestTracingContext(fs, true))).describedAs("Directory created by mkdir does not exist as explicit", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirOnExistingImplicitDirWithExplicitParentDir() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path explicitPath = new Path("dir1");
            Path path = new Path("dir1/dir2");
            fs.mkdirs(explicitPath);
            this.createAzCopyFolder(path);
            fs.mkdirs(path);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(explicitPath, fs, this.getTestTracingContext(fs, true))).describedAs("Explicit parent directory does not exist as explicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(path, fs, this.getTestTracingContext(fs, true))).describedAs("Mkdir created explicit directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirOnExistingImplicitDirWithImplicitParentDir() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path implicitPath = new Path("dir3");
            Path path = new Path("dir3/dir4");
            this.createAzCopyFolder(implicitPath);
            this.createAzCopyFolder(path);
            fs.mkdirs(path);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(implicitPath, fs, this.getTestTracingContext(fs, true))).describedAs("Marker is present for path created by azcopy", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(path, fs, this.getTestTracingContext(fs, true))).describedAs("Marker is present for existing directory", new Object[0])).isTrue();
        }
    }

    @Test
    public void testMkdirOnExistingFileWithImplicitParentDir() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path implicitPath = new Path("dir1");
            Path path = new Path("dir1/dir2");
            this.createAzCopyFolder(implicitPath);
            fs.create(path);
            LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.mkdirs(path));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(path, fs, this.getTestTracingContext(fs, true))).describedAs("File still exists at path", new Object[0])).isFalse();
        }
    }

    @Test
    public void testImplicitExplicitFolder() throws Exception {
        Configuration configuration = (Configuration)Mockito.spy((Object)this.getRawConfiguration());
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            Path implicitPath = new Path("a/b/c");
            this.createAzCopyFolder(implicitPath);
            Path path = this.makeQualified(new Path("a/b"));
            AbfsBlobClient blobClient = (AbfsBlobClient)fs.getAbfsStore().getClient(AbfsServiceType.BLOB);
            blobClient.createPathRestOp(path.toUri().getPath(), false, true, false, null, null, this.getTestTracingContext(fs, true));
            fs.mkdirs(new Path("a/b/c/d"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(new Path("a"), fs, this.getTestTracingContext(fs, true))).describedAs("Directory 'a' should be implicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a/b"), fs, this.getTestTracingContext(fs, true))).describedAs("Directory 'a/b' should be explicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a/b/c"), fs, this.getTestTracingContext(fs, true))).describedAs("Directory 'a/b/c' should be explicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a/b/c/d"), fs, this.getTestTracingContext(fs, true))).describedAs("Directory 'a/b/c/d' should be explicit", new Object[0])).isTrue();
        }
    }

    @Test
    public void testImplicitExplicitFolder1() throws Exception {
        Configuration configuration = (Configuration)Mockito.spy((Object)this.getRawConfiguration());
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            Path implicitPath = new Path("a/b/c");
            this.createAzCopyFolder(implicitPath);
            Path path = this.makeQualified(new Path("a"));
            AbfsBlobClient blobClient = (AbfsBlobClient)fs.getAbfsStore().getClient(AbfsServiceType.BLOB);
            blobClient.createPathRestOp(path.toUri().getPath(), false, true, false, null, null, this.getTestTracingContext(fs, true));
            Path newPath = this.makeQualified(new Path("a/b/c"));
            blobClient.createPathRestOp(newPath.toUri().getPath(), false, true, false, null, null, this.getTestTracingContext(fs, true));
            fs.mkdirs(new Path("a/b/c/d"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(new Path("a/b"), fs, this.getTestTracingContext(fs, true))).describedAs("Directory 'a/b' should be implicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a"), fs, this.getTestTracingContext(fs, true))).describedAs("Directory 'a' should be explicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a/b/c"), fs, this.getTestTracingContext(fs, true))).describedAs("Directory 'a/b/c' should be explicit", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(new Path("a/b/c/d"), fs, this.getTestTracingContext(fs, true))).describedAs("Directory 'a/b/c/d' should be explicit", new Object[0])).isTrue();
        }
    }

    private String extractFileEtag(String fileName) throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient client = fs.getAbfsClient();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        AbfsRestOperation op = client.getPathStatus(fileName, true, testTracingContext, null);
        return AzureBlobFileSystemStore.extractEtagHeader((AbfsHttpOperation)op.getResult());
    }

    @Test
    public void testCreatePathRetryIdempotency() throws Exception {
        Configuration configuration = new Configuration(this.getRawConfiguration());
        configuration.set("fs.azure.enable.client.transaction.id", "true");
        try (AzureBlobFileSystem fs = this.getFileSystem(configuration);){
            this.assumeRecoveryThroughClientTransactionID(true);
            AbfsDfsClient abfsClient = this.mockIngressClientHandler(fs);
            Path nonOverwriteFile = new Path("/NonOverwriteTest_FileName_" + UUID.randomUUID());
            ArrayList<AbfsHttpHeader> headers = new ArrayList<AbfsHttpHeader>();
            this.mockRetriedRequest(abfsClient, headers);
            AbfsRestOperation getPathRestOp = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
            AbfsHttpOperation op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
            ((AbfsHttpOperation)Mockito.doAnswer(answer -> {
                String requiredHeader = null;
                for (AbfsHttpHeader httpHeader : headers) {
                    if (!"x-ms-client-transaction-id".equalsIgnoreCase(httpHeader.getName())) continue;
                    requiredHeader = httpHeader.getValue();
                    break;
                }
                return requiredHeader;
            }).when((Object)op)).getResponseHeader("x-ms-client-transaction-id");
            ((AbfsRestOperation)Mockito.doReturn((Object)true).when((Object)getPathRestOp)).hasResult();
            ((AbfsRestOperation)Mockito.doReturn((Object)op).when((Object)getPathRestOp)).getResult();
            ((AbfsDfsClient)Mockito.doReturn((Object)getPathRestOp).when((Object)abfsClient)).getPathStatus((String)Mockito.nullable(String.class), ((Boolean)Mockito.nullable(Boolean.class)).booleanValue(), (TracingContext)Mockito.nullable(TracingContext.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class));
            fs.create(nonOverwriteFile, false);
        }
    }

    @Test
    public void testGetClientTransactionIdAfterCreate() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeRecoveryThroughClientTransactionID(true);
            String[] clientTransactionId = new String[1];
            AbfsDfsClient abfsDfsClient = this.mockIngressClientHandler(fs);
            AbfsClientTestUtil.mockAddClientTransactionIdToHeader(abfsDfsClient, clientTransactionId);
            Path nonOverwriteFile = new Path("/NonOverwriteTest_FileName_" + UUID.randomUUID());
            fs.create(nonOverwriteFile, false);
            AbfsHttpOperation getPathStatusOp = abfsDfsClient.getPathStatus(nonOverwriteFile.toUri().getPath(), false, this.getTestTracingContext(fs, true), null).getResult();
            ((AbstractStringAssert)Assertions.assertThat((String)getPathStatusOp.getResponseHeader("x-ms-client-transaction-id")).describedAs("Client transaction ID should be set during create", new Object[0])).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)getPathStatusOp.getResponseHeader("x-ms-client-transaction-id")).describedAs("Client transaction ID should be equal to the one set in the header", new Object[0])).isEqualTo((Object)clientTransactionId[0]);
        }
    }

    @Test
    public void testClientTransactionIdAfterTwoCreateCalls() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeRecoveryThroughClientTransactionID(true);
            String[] clientTransactionId = new String[1];
            AbfsDfsClient abfsDfsClient = this.mockIngressClientHandler(fs);
            AbfsClientTestUtil.mockAddClientTransactionIdToHeader(abfsDfsClient, clientTransactionId);
            Path testPath = this.path("testfile");
            AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
            fs.create(testPath, false);
            fs.create(testPath, true);
            AbfsHttpOperation getPathStatusOp = abfsDfsClient.getPathStatus(testPath.toUri().getPath(), false, this.getTestTracingContext(fs, true), null).getResult();
            ((AbstractStringAssert)Assertions.assertThat((String)getPathStatusOp.getResponseHeader("x-ms-client-transaction-id")).describedAs("Client transaction ID should be set during create", new Object[0])).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)getPathStatusOp.getResponseHeader("x-ms-client-transaction-id")).describedAs("Client transaction ID should be equal to the one set in the header", new Object[0])).isEqualTo((Object)clientTransactionId[0]);
        }
    }

    @Test
    public void testFailureInGetPathStatusDuringCreateRecovery() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeRecoveryThroughClientTransactionID(true);
            String[] clientTransactionId = new String[1];
            AbfsDfsClient abfsDfsClient = this.mockIngressClientHandler(fs);
            AbfsClientTestUtil.mockAddClientTransactionIdToHeader(abfsDfsClient, clientTransactionId);
            this.mockRetriedRequest(abfsDfsClient, new ArrayList<AbfsHttpHeader>());
            boolean[] flag = new boolean[1];
            ((AbfsDfsClient)Mockito.doAnswer(getPathStatus -> {
                if (!flag[0]) {
                    flag[0] = true;
                    throw new AbfsRestOperationException(408, "", "", new Exception());
                }
                return getPathStatus.callRealMethod();
            }).when((Object)abfsDfsClient)).getPathStatus((String)Mockito.nullable(String.class), ((Boolean)Mockito.nullable(Boolean.class)).booleanValue(), (TracingContext)Mockito.nullable(TracingContext.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class));
            Path nonOverwriteFile = new Path("/NonOverwriteTest_FileName_" + UUID.randomUUID());
            String errorMessage = ((AbfsDriverException)LambdaTestUtils.intercept(AbfsDriverException.class, () -> fs.create(nonOverwriteFile, false))).getErrorMessage();
            ((AbstractStringAssert)Assertions.assertThat((String)errorMessage).describedAs("getPathStatus should fail while recovering", new Object[0])).contains(new CharSequence[]{"Error while recovering from create failure."});
        }
    }

    @Test
    public void testCreateIdempotencyForNonHnsBlob() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        this.assumeHnsDisabled();
        this.assumeBlobServiceType();
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration())));){
            AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
            AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.spy((Object)store.getClientHandler());
            AbfsBlobClient blobClient = (AbfsBlobClient)Mockito.spy((Object)clientHandler.getBlobClient());
            fs.getAbfsStore().setClient((AbfsClient)blobClient);
            fs.getAbfsStore().setClientHandler(clientHandler);
            ((AzureBlobFileSystemStore)Mockito.doReturn((Object)clientHandler).when((Object)store)).getClientHandler();
            ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getBlobClient();
            ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getIngressClient();
            AtomicInteger createCount = new AtomicInteger(0);
            ((AbfsBlobClient)Mockito.doAnswer(answer -> {
                AbfsClientTestUtil.setMockAbfsRestOperationForCreateOperation((AbfsClient)blobClient, (FunctionRaisingIOE<AbfsHttpOperation, AbfsHttpOperation>)((FunctionRaisingIOE)httpOperation -> {
                    ((AbfsHttpOperation)Mockito.doAnswer(invocation -> {
                        invocation.callRealMethod();
                        int currentCount = createCount.incrementAndGet();
                        if (currentCount == 2) {
                            Mockito.when((Object)httpOperation.getStatusCode()).thenReturn((Object)500);
                            Mockito.when((Object)httpOperation.getStorageErrorMessage()).thenReturn((Object)"CONNECTION_RESET");
                            throw new IOException("Connection Reset");
                        }
                        return null;
                    }).when(httpOperation)).processResponse((byte[])Mockito.nullable(byte[].class), Mockito.anyInt(), Mockito.anyInt());
                    return httpOperation;
                }));
                return answer.callRealMethod();
            }).when((Object)blobClient)).createPath(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean(), (AzureBlobFileSystemStore.Permissions)Mockito.any(AzureBlobFileSystemStore.Permissions.class), Mockito.anyBoolean(), (String)Mockito.nullable(String.class), (ContextEncryptionAdapter)Mockito.any(ContextEncryptionAdapter.class), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            Path path = new Path("/test/file");
            fs.create(path, false);
            ((AbfsBlobClient)Mockito.verify((Object)blobClient, (VerificationMode)Mockito.times((int)1))).createPath(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean(), (AzureBlobFileSystemStore.Permissions)Mockito.any(AzureBlobFileSystemStore.Permissions.class), Mockito.anyBoolean(), (String)Mockito.nullable(String.class), (ContextEncryptionAdapter)Mockito.any(ContextEncryptionAdapter.class), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            ((AbfsBlobClient)Mockito.verify((Object)blobClient, (VerificationMode)Mockito.times((int)2))).createPathRestOp(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean(), (String)Mockito.nullable(String.class), (ContextEncryptionAdapter)Mockito.any(ContextEncryptionAdapter.class), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            ContractTestUtils.assertIsFile((FileSystem)fs, (Path)path);
        }
    }

    private AbfsDfsClient mockIngressClientHandler(AzureBlobFileSystem fs) {
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.spy((Object)store.getClientHandler());
        AbfsDfsClient abfsDfsClient = (AbfsDfsClient)Mockito.spy((Object)clientHandler.getClient());
        fs.getAbfsStore().setClient((AbfsClient)abfsDfsClient);
        fs.getAbfsStore().setClientHandler(clientHandler);
        ((AbfsClientHandler)Mockito.doReturn((Object)abfsDfsClient).when((Object)clientHandler)).getIngressClient();
        return abfsDfsClient;
    }

    private void mockRetriedRequest(AbfsDfsClient abfsDfsClient, final List<AbfsHttpHeader> headers) throws Exception {
        TestAbfsClient.mockAbfsOperationCreation((AbfsClient)abfsDfsClient, new MockIntercept<AbfsRestOperation>(){
            private int count = 0;

            @Override
            public void answer(AbfsRestOperation mockedObj, InvocationOnMock answer) throws AbfsRestOperationException {
                if (this.count == 0) {
                    this.count = 1;
                    AbfsHttpOperation op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
                    ((AbfsHttpOperation)Mockito.doReturn((Object)"PUT").when((Object)op)).getMethod();
                    ((AbfsHttpOperation)Mockito.doReturn((Object)"").when((Object)op)).getStorageErrorMessage();
                    ((AbfsRestOperation)Mockito.doReturn((Object)true).when((Object)mockedObj)).hasResult();
                    ((AbfsRestOperation)Mockito.doReturn((Object)op).when((Object)mockedObj)).getResult();
                    ((AbfsHttpOperation)Mockito.doReturn((Object)409).when((Object)op)).getStatusCode();
                    headers.addAll(mockedObj.getRequestHeaders());
                    throw new AbfsRestOperationException(409, AzureServiceErrorCode.PATH_CONFLICT.getErrorCode(), "", null, op);
                }
            }
        }, 0);
    }

    private static /* synthetic */ FSDataOutputStream lambda$testCreateOnRoot$3(AzureBlobFileSystem fs, Path testFile) throws Exception {
        return fs.create(testFile, true);
    }
}

