/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.jupiter.api.Test;

public class ITestAzureBlobFileSystemCopy
extends AbstractAbfsIntegrationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFromLocalFileSystem() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path localFilePath = new Path(System.getProperty("test.build.data", "azure_test"));
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        localFs.delete(localFilePath, true);
        try {
            this.writeString((FileSystem)localFs, localFilePath, "Testing");
            Path dstPath = this.path("copiedFromLocal");
            ITestAzureBlobFileSystemCopy.assertTrue((boolean)FileUtil.copy((FileSystem)localFs, (Path)localFilePath, (FileSystem)fs, (Path)dstPath, (boolean)false, (Configuration)fs.getConf()));
            ContractTestUtils.assertIsFile((FileSystem)fs, (Path)dstPath);
            ITestAzureBlobFileSystemCopy.assertEquals((Object)"Testing", (Object)this.readString((FileSystem)fs, dstPath));
            fs.delete(dstPath, true);
        }
        finally {
            localFs.delete(localFilePath, true);
        }
    }

    private String readString(FileSystem fs, Path testFile) throws IOException {
        return this.readString(fs.open(testFile));
    }

    private String readString(FSDataInputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream));){
            int bufferSize = 1024;
            char[] buffer = new char[1024];
            int count = reader.read(buffer, 0, 1024);
            if (count > 1024) {
                throw new IOException("Exceeded buffer size");
            }
            String string = new String(buffer, 0, count);
            return string;
        }
    }

    private void writeString(FileSystem fs, Path path, String value) throws IOException {
        this.writeString(fs.create(path, true), value);
    }

    private void writeString(FSDataOutputStream outputStream, String value) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream));){
            writer.write(value);
        }
    }
}

