/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.nio.file.AccessDeniedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.ConfigurationKeys;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.SASTokenProviderException;
import org.apache.hadoop.fs.azurebfs.extensions.MockDelegationSASTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.FixedSASTokenProvider;
import org.apache.hadoop.fs.azurebfs.utils.AccountSASGenerator;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.ServiceSASGenerator;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ITestAzureBlobFileSystemChooseSAS
extends AbstractAbfsIntegrationTest {
    private String accountSAS = null;
    private String containerSAS = null;
    private String accountAgnosticSAS = null;
    private static final String TEST_PATH = "testPath";

    public ITestAzureBlobFileSystemChooseSAS() throws Exception {
        Assumptions.assumeThat((Comparable)this.getAuthType()).isEqualTo((Object)AuthType.SharedKey);
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.createFilesystemWithTestFileForSASTests(new Path(TEST_PATH));
        this.generateAccountSAS();
        this.generateAccountAgnosticSAS();
        this.generateContainerSAS();
    }

    private void generateAccountSAS() throws AzureBlobFileSystemException {
        String accountKey = this.getConfiguration().getStorageAccountKey();
        AccountSASGenerator configAccountSASGenerator = new AccountSASGenerator(Base64.decode((String)accountKey));
        configAccountSASGenerator.setPermissions("r");
        this.accountSAS = configAccountSASGenerator.getAccountSAS(this.getAccountName());
    }

    private void generateAccountAgnosticSAS() throws AzureBlobFileSystemException {
        String accountKey = this.getConfiguration().getStorageAccountKey();
        AccountSASGenerator configAccountSASGenerator = new AccountSASGenerator(Base64.decode((String)accountKey));
        configAccountSASGenerator.setPermissions("w");
        this.accountAgnosticSAS = configAccountSASGenerator.getAccountSAS(this.getAccountName());
    }

    private void generateContainerSAS() throws AzureBlobFileSystemException {
        byte[] accountKey = Base64.decode((String)this.getConfiguration().getStorageAccountKey());
        ServiceSASGenerator configServiceSASGenerator = new ServiceSASGenerator(accountKey);
        configServiceSASGenerator.setPermissions("r");
        this.containerSAS = configServiceSASGenerator.getContainerSASWithFullControl(this.getAccountName(), this.getFileSystemName());
    }

    @Test
    public void testBothProviderFixedTokenConfigured() throws Exception {
        this.assumeDfsServiceType();
        this.assumeHnsEnabled();
        AbfsConfiguration testAbfsConfig = new AbfsConfiguration(this.getRawConfiguration(), this.getAccountName());
        this.removeAnyPresetConfiguration(testAbfsConfig);
        testAbfsConfig.set("fs.azure.sas.token.provider.type", MockDelegationSASTokenProvider.class.getName());
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.app.id");
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.app.secret");
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.app.service.principal.tenant.id");
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.app.service.principal.object.id");
        testAbfsConfig.set("fs.azure.sas.fixed.token", this.accountSAS);
        try (AzureBlobFileSystem newTestFs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)testAbfsConfig.getRawConfiguration());){
            ((ObjectAssert)Assertions.assertThat((Object)testAbfsConfig.getSASTokenProvider()).describedAs("Custom SASTokenProvider Class must be used", new Object[0])).isInstanceOf(MockDelegationSASTokenProvider.class);
            Path testPath = this.path(this.getMethodName());
            newTestFs.create(testPath).close();
            newTestFs.open(testPath).close();
        }
    }

    private String getFixedSASToken(AbfsConfiguration config) throws Exception {
        return config.getSASTokenProvider().getSASToken(this.getAccountName(), this.getFileSystemName(), this.getMethodName(), "");
    }

    @Test
    public void testFixedSASTokenProviderPreference() throws Exception {
        AbfsConfiguration testAbfsConfig = new AbfsConfiguration(this.getRawConfiguration(), this.getAccountName(), this.getFileSystemName(), this.getAbfsServiceType());
        this.removeAnyPresetConfiguration(testAbfsConfig);
        testAbfsConfig.set(ConfigurationKeys.containerProperty((String)"fs.azure.sas.fixed.token", (String)this.getFileSystemName(), (String)this.getAccountName()), this.containerSAS);
        testAbfsConfig.set(ConfigurationKeys.accountProperty((String)"fs.azure.sas.fixed.token", (String)this.getAccountName()), this.accountSAS);
        testAbfsConfig.set("fs.azure.sas.fixed.token", this.accountAgnosticSAS);
        ((AbstractStringAssert)Assertions.assertThat((String)this.getFixedSASToken(testAbfsConfig)).describedAs("Container-specific fixed SAS should've been used.", new Object[0])).isEqualTo((Object)this.containerSAS);
        testAbfsConfig.unset(ConfigurationKeys.containerProperty((String)"fs.azure.sas.fixed.token", (String)this.getFileSystemName(), (String)this.getAccountName()));
        ((AbstractStringAssert)Assertions.assertThat((String)this.getFixedSASToken(testAbfsConfig)).describedAs("Account-specific fixed SAS should've been used.", new Object[0])).isEqualTo((Object)this.accountSAS);
        testAbfsConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.sas.fixed.token", (String)this.getAccountName()));
        ((AbstractStringAssert)Assertions.assertThat((String)this.getFixedSASToken(testAbfsConfig)).describedAs("Account-agnostic fixed SAS should've been used.", new Object[0])).isEqualTo((Object)this.accountAgnosticSAS);
    }

    @Test
    public void testOnlyFixedTokenConfigured() throws Exception {
        AbfsConfiguration testAbfsConfig = new AbfsConfiguration(this.getRawConfiguration(), this.getAccountName());
        this.removeAnyPresetConfiguration(testAbfsConfig);
        testAbfsConfig.set(ConfigurationKeys.accountProperty((String)"fs.azure.sas.fixed.token", (String)this.getAccountName()), this.accountSAS);
        this.testOnlyFixedTokenConfiguredInternal(testAbfsConfig);
        this.removeAnyPresetConfiguration(testAbfsConfig);
        testAbfsConfig.set("fs.azure.sas.fixed.token", this.accountSAS);
        this.testOnlyFixedTokenConfiguredInternal(testAbfsConfig);
    }

    private void testOnlyFixedTokenConfiguredInternal(AbfsConfiguration testAbfsConfig) throws Exception {
        try (AzureBlobFileSystem newTestFs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)testAbfsConfig.getRawConfiguration());){
            ((ObjectAssert)Assertions.assertThat((Object)testAbfsConfig.getSASTokenProvider()).describedAs("FixedSASTokenProvider Class must be used", new Object[0])).isInstanceOf(FixedSASTokenProvider.class);
            Path testPath = this.path(this.getMethodName());
            LambdaTestUtils.intercept(AccessDeniedException.class, () -> newTestFs.create(testPath));
            newTestFs.getFileStatus(new Path(TEST_PATH));
        }
    }

    @Test
    public void testBothProviderFixedTokenUnset() throws Exception {
        AbfsConfiguration testAbfsConfig = new AbfsConfiguration(this.getRawConfiguration(), this.getAccountName());
        this.removeAnyPresetConfiguration(testAbfsConfig);
        LambdaTestUtils.intercept(SASTokenProviderException.class, () -> FileSystem.newInstance((Configuration)testAbfsConfig.getRawConfiguration()));
    }

    private void removeAnyPresetConfiguration(AbfsConfiguration testAbfsConfig) {
        testAbfsConfig.unset("fs.azure.sas.token.provider.type");
        testAbfsConfig.unset("fs.azure.sas.fixed.token");
        testAbfsConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.sas.token.provider.type", (String)this.getAccountName()));
        testAbfsConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.sas.fixed.token", (String)this.getAccountName()));
        testAbfsConfig.unset(ConfigurationKeys.containerProperty((String)"fs.azure.sas.fixed.token", (String)this.getFileSystemName(), (String)this.getAccountName()));
    }
}

