/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsInvalidChecksumException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobAppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITestAzureBlobFileSystemChecksum
extends AbstractAbfsIntegrationTest {
    private static final int MB_2 = 0x200000;
    private static final int MB_3 = 0x300000;
    private static final int MB_4 = 0x400000;
    private static final int MB_8 = 0x800000;
    private static final int MB_15 = 0xF00000;
    private static final int MB_16 = 0x1000000;
    private static final String INVALID_MD5_TEXT = "Text for Invalid MD5 Computation";

    @Test
    public void testWriteReadWithChecksum() throws Exception {
        this.testWriteReadWithChecksumInternal(true);
        this.testWriteReadWithChecksumInternal(false);
    }

    @Test
    public void testAppendWithChecksumAtDifferentOffsets() throws Exception {
        AzureBlobFileSystem fs = this.getConfiguredFileSystem(0x400000, 0x400000, true);
        if (!this.getIsNamespaceEnabled(fs)) {
            ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        }
        AbfsClient client = fs.getAbfsStore().getClientHandler().getIngressClient();
        Path path = this.path("testPath" + this.getMethodName());
        AbfsOutputStream os = (AbfsOutputStream)fs.create(path).getWrappedStream();
        byte[] data = ITestAzureBlobFileSystemChecksum.generateRandomBytes(0x400000);
        int pos = 0;
        pos += this.appendWithOffsetHelper(os, client, path, data, fs, pos, 0, client.computeMD5Hash(data, 0, data.length));
        pos += this.appendWithOffsetHelper(os, client, path, data, fs, pos, 0x100000, client.computeMD5Hash(data, 0x100000, data.length - 0x100000));
        pos += this.appendWithOffsetHelper(os, client, path, data, fs, pos, 0x200000, client.computeMD5Hash(data, 0x200000, data.length - 0x200000));
        this.appendWithOffsetHelper(os, client, path, data, fs, pos, 0x3FFFFF, client.computeMD5Hash(data, 0x3FFFFF, data.length - 0x3FFFFF));
        fs.close();
    }

    @Test
    public void testReadWithChecksumAtDifferentOffsets() throws Exception {
        AzureBlobFileSystem fs = this.getConfiguredFileSystem(0x400000, 0x400000, true);
        AbfsClient client = fs.getAbfsStore().getClient();
        Path path = this.path("testPath" + this.getMethodName());
        byte[] data = ITestAzureBlobFileSystemChecksum.generateRandomBytes(0x1000000);
        this.createFileWithData(path, data, fs);
        this.readWithOffsetAndPositionHelper(client, path, data, fs, 0, 0);
        this.readWithOffsetAndPositionHelper(client, path, data, fs, 0x400000, 0);
        this.readWithOffsetAndPositionHelper(client, path, data, fs, 0x400000, 0x100000);
        this.readWithOffsetAndPositionHelper(client, path, data, fs, 0x800000, 0x200000);
        this.readWithOffsetAndPositionHelper(client, path, data, fs, 0xF00000, 0x3FFFFF);
        fs.close();
    }

    @Test
    public void testWriteReadWithChecksumAndOptions() throws Exception {
        this.testWriteReadWithChecksumAndOptionsInternal(true);
        this.testWriteReadWithChecksumAndOptionsInternal(false);
    }

    @Test
    public void testAbfsInvalidChecksumExceptionInAppend() throws Exception {
        AzureBlobFileSystem fs = this.getConfiguredFileSystem(0x400000, 0x400000, true);
        AbfsClient spiedClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsStore().getClientHandler().getIngressClient());
        Path path = this.path("testPath" + this.getMethodName());
        AbfsOutputStream os = (AbfsOutputStream)Mockito.spy((Object)((AbfsOutputStream)fs.create(path).getWrappedStream()));
        byte[] data = ITestAzureBlobFileSystemChecksum.generateRandomBytes(0x400000);
        String invalidMD5Hash = spiedClient.computeMD5Hash(INVALID_MD5_TEXT.getBytes(), 0, INVALID_MD5_TEXT.length());
        ((AbfsClient)Mockito.doReturn((Object)invalidMD5Hash).when((Object)spiedClient)).computeMD5Hash((byte[])ArgumentMatchers.any(), ((Integer)ArgumentMatchers.any(Integer.class)).intValue(), ((Integer)ArgumentMatchers.any(Integer.class)).intValue());
        ((AbfsOutputStream)Mockito.doReturn((Object)invalidMD5Hash).when((Object)os)).getMd5();
        AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsInvalidChecksumException.class, () -> this.appendWithOffsetHelper(os, spiedClient, path, data, fs, 0, 0, invalidMD5Hash));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)ex.getErrorCode()).describedAs("Exception Message should contain MD5Mismatch", new Object[0])).isEqualTo((Object)AzureServiceErrorCode.MD5_MISMATCH);
        fs.close();
    }

    @Test
    public void testAbfsInvalidChecksumExceptionInRead() throws Exception {
        AzureBlobFileSystem fs = this.getConfiguredFileSystem(0x400000, 0x400000, true);
        AbfsClient spiedClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsStore().getClient());
        Path path = this.path("testPath" + this.getMethodName());
        byte[] data = ITestAzureBlobFileSystemChecksum.generateRandomBytes(0x300000);
        this.createFileWithData(path, data, fs);
        String invalidMD5Hash = spiedClient.computeMD5Hash(INVALID_MD5_TEXT.getBytes(), 0, INVALID_MD5_TEXT.length());
        ((AbfsClient)Mockito.doReturn((Object)invalidMD5Hash).when((Object)spiedClient)).computeMD5Hash((byte[])ArgumentMatchers.any(), ((Integer)ArgumentMatchers.any(Integer.class)).intValue(), ((Integer)ArgumentMatchers.any(Integer.class)).intValue());
        LambdaTestUtils.intercept(AbfsInvalidChecksumException.class, () -> this.readWithOffsetAndPositionHelper(spiedClient, path, data, fs, 0, 0));
    }

    private void testWriteReadWithChecksumInternal(boolean readAheadEnabled) throws Exception {
        AzureBlobFileSystem fs = this.getConfiguredFileSystem(0x400000, 0x400000, readAheadEnabled);
        int dataSize = 16778216;
        Path testPath = this.path("testPath" + this.getMethodName());
        byte[] bytesUploaded = ITestAzureBlobFileSystemChecksum.generateRandomBytes(16778216);
        this.createFileWithData(testPath, bytesUploaded, fs);
        try (FSDataInputStream in = fs.open(testPath);){
            byte[] bytesRead = new byte[bytesUploaded.length];
            in.read(bytesRead, 0, 16778216);
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])bytesRead).describedAs("Bytes read with checksum enabled are not as expected", new Object[0])).containsExactly(bytesUploaded);
        }
    }

    private String generateBlockId(AbfsOutputStream os, long position) {
        String streamId = os.getStreamID();
        String streamIdHash = Integer.toString(streamId.hashCode());
        String blockId = String.format("%d_%s", position, streamIdHash);
        byte[] blockIdByteArray = new byte[60];
        System.arraycopy(blockId.getBytes(), 0, blockIdByteArray, 0, Math.min(60, blockId.length()));
        return new String(Base64.encodeBase64((byte[])blockIdByteArray), StandardCharsets.UTF_8);
    }

    private int appendWithOffsetHelper(AbfsOutputStream os, AbfsClient client, Path path, byte[] data, AzureBlobFileSystem fs, int pos, int offset, String md5) throws Exception {
        String blockId = this.generateBlockId(os, pos);
        String eTag = os.getIngressHandler().getETag();
        AppendRequestParameters reqParams = new AppendRequestParameters((long)pos, offset, data.length - offset, AppendRequestParameters.Mode.APPEND_MODE, this.isAppendBlobEnabled(), null, true, new BlobAppendRequestParameters(blockId, eTag), md5);
        client.append(path.toUri().getPath(), data, reqParams, null, null, this.getTestTracingContext(fs, false));
        return reqParams.getLength();
    }

    private void readWithOffsetAndPositionHelper(AbfsClient client, Path path, byte[] data, AzureBlobFileSystem fs, int position, int offset) throws Exception {
        int bufferLength = fs.getAbfsStore().getAbfsConfiguration().getReadBufferSize();
        byte[] readBuffer = new byte[bufferLength];
        int readLength = bufferLength - offset;
        client.read(path.toUri().getPath(), (long)position, readBuffer, offset, readLength, "*", null, null, this.getTestTracingContext(fs, false));
        byte[] actual = Arrays.copyOfRange(readBuffer, offset, offset + readLength);
        byte[] expected = Arrays.copyOfRange(data, position, readLength + position);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actual).describedAs("Data read should be same as Data Written", new Object[0])).containsExactly(expected);
    }

    private void testWriteReadWithChecksumAndOptionsInternal(boolean readAheadEnabled) throws Exception {
        AzureBlobFileSystem fs = this.getConfiguredFileSystem(0x800000, 0x100000, readAheadEnabled);
        int dataSize = 16778216;
        Path testPath = this.path("testPath" + this.getMethodName());
        byte[] bytesUploaded = ITestAzureBlobFileSystemChecksum.generateRandomBytes(16778216);
        this.createFileWithData(testPath, bytesUploaded, fs);
        Configuration cpm1 = new Configuration();
        cpm1.setBoolean("fs.azure.buffered.pread.disable", true);
        try (FSDataInputStream in = (FSDataInputStream)fs.openFileWithOptions(testPath, new OpenFileParameters().withOptions(cpm1).withMandatoryKeys(new HashSet())).get();){
            byte[] bytesRead = new byte[16778216];
            in.read(1L, bytesRead, 1, 0x400000);
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Arrays.copyOfRange(bytesRead, 1, 0x400000)).describedAs("Bytes read with checksum enabled are not as expected", new Object[0])).containsExactly(Arrays.copyOfRange(bytesUploaded, 1, 0x400000));
        }
    }

    private void createFileWithData(Path path, byte[] data, AzureBlobFileSystem fs) throws Exception {
        try (FSDataOutputStream out = fs.create(path);){
            out.write(data);
            out.hflush();
        }
    }

    private AzureBlobFileSystem getConfiguredFileSystem(int writeBuffer, int readBuffer, boolean readAheadEnabled) throws Exception {
        AzureBlobFileSystem fs = this.createFileSystem();
        AbfsConfiguration abfsConf = fs.getAbfsStore().getAbfsConfiguration();
        abfsConf.setIsChecksumValidationEnabled(true);
        abfsConf.setWriteBufferSize(writeBuffer);
        abfsConf.setReadBufferSize(readBuffer);
        abfsConf.setReadAheadEnabled(readAheadEnabled);
        return fs;
    }

    public static byte[] generateRandomBytes(int numBytes) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[numBytes];
        secureRandom.nextBytes(randomBytes);
        return randomBytes;
    }
}

