/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

public class ITestAzureBlobFileSystemBackCompat
extends AbstractAbfsIntegrationTest {
    @Test
    public void testBlobBackCompat() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.getIsNamespaceEnabled(this.getFileSystem())).as("This test does not support namespace enabled account", new Object[0])).isFalse();
        String storageConnectionString = this.getBlobConnectionString();
        CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)storageConnectionString);
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        CloudBlobContainer container = blobClient.getContainerReference(this.getFileSystemName());
        container.createIfNotExists();
        Path testPath = this.getUniquePath("test");
        CloudBlockBlob blockBlob = container.getBlockBlobReference(testPath + "/10/10/10");
        blockBlob.uploadText("");
        blockBlob = container.getBlockBlobReference(testPath + "/10/123/3/2/1/3");
        blockBlob.uploadText("");
        FileStatus[] fileStatuses = fs.listStatus(new Path(String.format("/%s/10/", testPath)));
        ITestAzureBlobFileSystemBackCompat.assertEquals((int)2, (int)fileStatuses.length);
        ITestAzureBlobFileSystemBackCompat.assertEquals((Object)"10", (Object)fileStatuses[0].getPath().getName());
        ITestAzureBlobFileSystemBackCompat.assertTrue((boolean)fileStatuses[0].isDirectory());
        ITestAzureBlobFileSystemBackCompat.assertEquals((long)0L, (long)fileStatuses[0].getLen());
        ITestAzureBlobFileSystemBackCompat.assertEquals((Object)"123", (Object)fileStatuses[1].getPath().getName());
        ITestAzureBlobFileSystemBackCompat.assertTrue((boolean)fileStatuses[1].isDirectory());
        ITestAzureBlobFileSystemBackCompat.assertEquals((long)0L, (long)fileStatuses[1].getLen());
    }

    private String getBlobConnectionString() {
        String connectionString = this.isIPAddress() ? "DefaultEndpointsProtocol=http;BlobEndpoint=http://" + this.getHostName() + ":8880/" + this.getAccountName().split("\\.")[0] + ";AccountName=" + this.getAccountName().split("\\.")[0] + ";AccountKey=" + this.getAccountKey() : (this.getConfiguration().isHttpsAlwaysUsed() ? "DefaultEndpointsProtocol=https;BlobEndpoint=https://" + this.getAccountName().replaceFirst("\\.dfs\\.", ".blob.") + ";AccountName=" + this.getAccountName().split("\\.")[0] + ";AccountKey=" + this.getAccountKey() : "DefaultEndpointsProtocol=http;BlobEndpoint=http://" + this.getAccountName().replaceFirst("\\.dfs\\.", ".blob.") + ";AccountName=" + this.getAccountName().split("\\.")[0] + ";AccountKey=" + this.getAccountKey());
        return connectionString;
    }
}

