/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.utils.DirectoryStateHelper;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ITestAzureBlobFileSystemAttributes
extends AbstractAbfsIntegrationTest {
    private static final EnumSet<XAttrSetFlag> CREATE_FLAG = EnumSet.of(XAttrSetFlag.CREATE);
    private static final EnumSet<XAttrSetFlag> REPLACE_FLAG = EnumSet.of(XAttrSetFlag.REPLACE);

    @Test
    public void testSetGetXAttr() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(this.getMethodName());
        fs.create(testPath);
        this.testGetSetXAttrHelper(fs, testPath);
    }

    @Test
    public void testSetGetXAttrCreateReplace() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String decodedAttributeValue = "one";
        byte[] attributeValue = fs.getAbfsStore().encodeAttribute(decodedAttributeValue);
        String attributeName = "user.someAttribute";
        Path testFile = this.path(this.getMethodName());
        this.touch(testFile);
        fs.setXAttr(testFile, attributeName, attributeValue, CREATE_FLAG);
        ITestAzureBlobFileSystemAttributes.assertAttributeEqual(fs, fs.getXAttr(testFile, attributeName), attributeValue, decodedAttributeValue);
        LambdaTestUtils.intercept(IOException.class, () -> fs.setXAttr(testFile, attributeName, attributeValue, CREATE_FLAG));
    }

    @Test
    public void testSetGetXAttrReplace() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String decodedAttribute1 = "one";
        String decodedAttribute2 = "two";
        byte[] attributeValue1 = fs.getAbfsStore().encodeAttribute(decodedAttribute1);
        byte[] attributeValue2 = fs.getAbfsStore().encodeAttribute(decodedAttribute2);
        String attributeName = "user.someAttribute";
        Path testFile = this.path(this.getMethodName());
        LambdaTestUtils.intercept(IOException.class, () -> {
            this.touch(testFile);
            fs.setXAttr(testFile, attributeName, attributeValue1, REPLACE_FLAG);
        });
        fs.setXAttr(testFile, attributeName, attributeValue1, CREATE_FLAG);
        fs.setXAttr(testFile, attributeName, attributeValue2, REPLACE_FLAG);
        ITestAzureBlobFileSystemAttributes.assertAttributeEqual(fs, fs.getXAttr(testFile, attributeName), attributeValue2, decodedAttribute2);
    }

    @Test
    public void testGetSetXAttrOnRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String attributeName = "user.attribute1";
        byte[] attributeValue = fs.getAbfsStore().encodeAttribute("hi");
        Path testPath = new Path("/");
        AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.getXAttr(testPath, attributeName));
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("GetXAttr() on root should fail with Bad Request", new Object[0])).isEqualTo(400);
        ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.setXAttr(testPath, attributeName, attributeValue, CREATE_FLAG));
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("SetXAttr() on root should fail with Bad Request", new Object[0])).isEqualTo(400);
    }

    @Test
    public void testGetSetXAttrOnExplicitDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(this.getMethodName());
        fs.mkdirs(testPath);
        this.testGetSetXAttrHelper(fs, testPath);
        DirectoryStateHelper.isExplicitDirectory(testPath, fs, this.getTestTracingContext(fs, true));
    }

    @Test
    public void testGetSetXAttrOnNonExistingPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(this.getMethodName());
        LambdaTestUtils.intercept(FileNotFoundException.class, (String)String.valueOf(404), (String)"get/set XAttr() should fail for non-existing files", () -> this.testGetSetXAttrHelper(fs, testPath));
    }

    @Test
    public void testSetXAttrMultipleOperations() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = this.path(this.getMethodName());
        fs.create(path);
        String attributeName = "user.attribute1";
        String decodedAttributeValue = "hi";
        byte[] attributeValue = fs.getAbfsStore().encodeAttribute(decodedAttributeValue);
        this.assertAttributeNull(fs.getXAttr(path, attributeName));
        fs.setXAttr(path, attributeName, attributeValue);
        fs.setXAttr(path, attributeName, attributeValue);
        byte[] rv = fs.getXAttr(path, attributeName);
        ITestAzureBlobFileSystemAttributes.assertAttributeEqual(fs, rv, attributeValue, decodedAttributeValue);
    }

    @Test
    public void testGetSetXAttrOnImplicitDir() throws Exception {
        this.assumeBlobServiceType();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(this.getMethodName());
        this.createAzCopyFolder(testPath);
        this.testGetSetXAttrHelper(fs, testPath);
        DirectoryStateHelper.isExplicitDirectory(testPath, fs, this.getTestTracingContext(fs, true));
        DirectoryStateHelper.isExplicitDirectory(testPath.getParent(), fs, this.getTestTracingContext(fs, true));
    }

    private void testGetSetXAttrHelper(AzureBlobFileSystem fs, Path testPath) throws Exception {
        String attributeName1 = "user.attribute1";
        String attributeName2 = "user.attribute2";
        String decodedAttributeValue1 = "hi";
        String decodedAttributeValue2 = "hello";
        byte[] attributeValue1 = fs.getAbfsStore().encodeAttribute(decodedAttributeValue1);
        byte[] attributeValue2 = fs.getAbfsStore().encodeAttribute(decodedAttributeValue2);
        this.assertAttributeNull(fs.getXAttr(testPath, attributeName1));
        this.assertAttributeNull(fs.getXAttr(testPath, attributeName2));
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.SET_ATTR, true, 0));
        fs.setXAttr(testPath, attributeName1, attributeValue1);
        fs.setListenerOperation(FSOperationType.GET_ATTR);
        byte[] rv = fs.getXAttr(testPath, attributeName1);
        ITestAzureBlobFileSystemAttributes.assertAttributeEqual(fs, rv, attributeValue1, decodedAttributeValue1);
        fs.registerListener(null);
        fs.setXAttr(testPath, attributeName2, attributeValue2);
        rv = fs.getXAttr(testPath, attributeName1);
        ITestAzureBlobFileSystemAttributes.assertAttributeEqual(fs, rv, attributeValue1, decodedAttributeValue1);
        rv = fs.getXAttr(testPath, attributeName2);
        ITestAzureBlobFileSystemAttributes.assertAttributeEqual(fs, rv, attributeValue2, decodedAttributeValue2);
    }

    private void assertAttributeNull(byte[] rv) {
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])rv).describedAs("Cannot get attribute before setting it", new Object[0])).isNull();
    }

    public static void assertAttributeEqual(AzureBlobFileSystem fs, byte[] rv, byte[] attributeValue, String decodedAttributeValue) throws Exception {
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])rv).describedAs("Retrieved Attribute Does not Matches in Encoded Form", new Object[0])).containsExactly(attributeValue);
        ((AbstractStringAssert)Assertions.assertThat((String)fs.getAbfsStore().decodeAttribute(rv)).describedAs("Retrieved Attribute Does not Matches in Decoded Form", new Object[0])).isEqualTo((Object)decodedAttributeValue);
    }
}

