/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsCountersImpl;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ITestAbfsStatistics
extends AbstractAbfsIntegrationTest {
    private static final int NUMBER_OF_OPS = 10;

    @BeforeEach
    public void setUp() throws Exception {
        super.setup();
        this.getFileSystem().getConf().set("fs.iostatistics.logging.level", "info");
    }

    @Test
    public void testInitialStatsValues() throws IOException {
        this.describe("Testing the initial values of Abfs counters", new Object[0]);
        AbfsCountersImpl abfsCounters = new AbfsCountersImpl(this.getFileSystem().getUri());
        IOStatistics ioStatistics = abfsCounters.getIOStatistics();
        for (Map.Entry entry : ioStatistics.counters().entrySet()) {
            this.checkInitialValue((String)entry.getKey(), (Long)entry.getValue(), 0L);
        }
        for (Map.Entry entry : ioStatistics.gauges().entrySet()) {
            this.checkInitialValue((String)entry.getKey(), (Long)entry.getValue(), 0L);
        }
        for (Map.Entry entry : ioStatistics.maximums().entrySet()) {
            this.checkInitialValue((String)entry.getKey(), (Long)entry.getValue(), -1L);
        }
    }

    @Test
    public void testCreateStatistics() throws IOException {
        this.describe("Testing counter values got by creating directories and files in Abfs", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path createFilePath = this.path(this.getMethodName());
        Path createDirectoryPath = this.path(this.getMethodName() + "Dir");
        fs.mkdirs(createDirectoryPath);
        fs.createNonRecursive(createFilePath, FsPermission.getDefault(), false, 1024, (short)1, 1024L, null).close();
        Map metricMap = fs.getInstrumentationMap();
        this.assertAbfsStatistics(AbfsStatistic.CALL_CREATE_NON_RECURSIVE, 1L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.FILES_CREATED, 1L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.DIRECTORIES_CREATED, 1L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_MKDIRS, 1L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_GET_FILE_STATUS, 2L, metricMap);
        fs.initialize(fs.getUri(), fs.getConf());
        for (int i = 0; i < 10; ++i) {
            fs.mkdirs(this.path(this.getMethodName() + "Dir" + i));
            fs.createNonRecursive(this.path(this.getMethodName() + i), FsPermission.getDefault(), false, 1024, (short)1, 1024L, null).close();
        }
        metricMap = fs.getInstrumentationMap();
        this.assertAbfsStatistics(AbfsStatistic.CALL_CREATE_NON_RECURSIVE, 10L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.FILES_CREATED, 10L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.DIRECTORIES_CREATED, 10L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_MKDIRS, 10L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_GET_FILE_STATUS, 11L, metricMap);
    }

    @Test
    public void testDeleteStatistics() throws IOException {
        this.describe("Testing counter values got by deleting directory and files in Abfs", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path createDirectoryPath = this.path("/");
        Path createFilePath = this.path(this.getMethodName());
        fs.mkdirs(createDirectoryPath);
        fs.create(this.path(createDirectoryPath + this.getMethodName())).close();
        fs.delete(createDirectoryPath, true);
        Map metricMap = fs.getInstrumentationMap();
        this.assertAbfsStatistics(AbfsStatistic.CALL_DELETE, 2L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.FILES_DELETED, 1L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_LIST_STATUS, 1L, metricMap);
        fs.mkdirs(createDirectoryPath);
        fs.create(createFilePath).close();
        fs.delete(createDirectoryPath, true);
        metricMap = fs.getInstrumentationMap();
        this.assertAbfsStatistics(AbfsStatistic.DIRECTORIES_DELETED, 1L, metricMap);
    }

    @Test
    public void testOpenAppendRenameExists() throws IOException {
        int i;
        this.describe("Testing counter values on calling open, append and rename and exists methods on Abfs", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path createFilePath = this.path(this.getMethodName());
        Path destCreateFilePath = this.path(this.getMethodName() + "New");
        fs.create(createFilePath).close();
        fs.open(createFilePath).close();
        fs.append(createFilePath).close();
        ITestAbfsStatistics.assertTrue((boolean)fs.rename(createFilePath, destCreateFilePath));
        Map metricMap = fs.getInstrumentationMap();
        this.assertAbfsStatistics(AbfsStatistic.CALL_OPEN, 1L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_APPEND, 1L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_RENAME, 1L, metricMap);
        ITestAbfsStatistics.assertTrue((boolean)fs.exists(destCreateFilePath), (String)String.format("File with name %s should exist", destCreateFilePath));
        ITestAbfsStatistics.assertFalse((boolean)fs.exists(createFilePath), (String)String.format("File with name %s should not exist", createFilePath));
        metricMap = fs.getInstrumentationMap();
        this.assertAbfsStatistics(AbfsStatistic.CALL_EXIST, 2L, metricMap);
        fs.initialize(fs.getUri(), fs.getConf());
        fs.create(destCreateFilePath).close();
        for (i = 0; i < 10; ++i) {
            fs.open(destCreateFilePath);
            fs.append(destCreateFilePath).close();
        }
        metricMap = fs.getInstrumentationMap();
        this.assertAbfsStatistics(AbfsStatistic.CALL_OPEN, 10L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_APPEND, 10L, metricMap);
        for (i = 0; i < 10; ++i) {
            ITestAbfsStatistics.assertTrue((boolean)fs.rename(destCreateFilePath, createFilePath));
            ITestAbfsStatistics.assertTrue((boolean)fs.rename(createFilePath, destCreateFilePath));
            ITestAbfsStatistics.assertTrue((boolean)fs.exists(destCreateFilePath), (String)String.format("File with name %s should exist", destCreateFilePath));
            ITestAbfsStatistics.assertFalse((boolean)fs.exists(createFilePath), (String)String.format("File with name %s should not exist", createFilePath));
        }
        metricMap = fs.getInstrumentationMap();
        this.assertAbfsStatistics(AbfsStatistic.CALL_RENAME, 20L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.CALL_EXIST, 20L, metricMap);
    }

    private void checkInitialValue(String statName, long statValue, long expectedInitialValue) {
        ITestAbfsStatistics.assertEquals((long)expectedInitialValue, (long)statValue, (String)("Mismatch in " + statName));
    }
}

