/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.constants.ConfigurationKeys;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.oauth2.RetryTestTokenProvider;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;

public class ITestAbfsRestOperationException
extends AbstractAbfsIntegrationTest {
    private static final String RETRY_TEST_TOKEN_PROVIDER = "org.apache.hadoop.fs.azurebfs.oauth2.RetryTestTokenProvider";

    @Test
    public void testAbfsRestOperationExceptionFormat() throws IOException {
        Object[] errorFields;
        String errorMessage;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path nonExistedFilePath1 = new Path("nonExistedPath1");
        Path nonExistedFilePath2 = new Path("nonExistedPath2");
        try {
            fs.getFileStatus(nonExistedFilePath1);
        }
        catch (Exception ex) {
            errorMessage = ex.getLocalizedMessage();
            errorFields = errorMessage.split(",");
            ((ObjectArrayAssert)Assertions.assertThat((Object[])errorFields).describedAs("Number of Fields in exception message are not as expected", new Object[0])).hasSize(5);
            if (this.getAbfsServiceType() == AbfsServiceType.BLOB) {
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[0]).trim()).describedAs("Error Message Field in exception message is wrong", new Object[0])).contains(new CharSequence[]{"Operation failed: \"The specified blob does not exist.\""});
            } else {
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[0]).trim()).describedAs("Error Message Field in exception message is wrong", new Object[0])).isEqualTo((Object)"Operation failed: \"The specified path does not exist.\"");
            }
            ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[1]).trim()).describedAs("Status Code Field in exception message should be \"404\"", new Object[0])).isEqualTo((Object)"404");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[2]).trim()).describedAs("Http Rest Method Field in exception message should be \"HEAD\"", new Object[0])).isEqualTo((Object)"HEAD");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[3]).trim()).describedAs("Url Field in exception message should start with \"http\"", new Object[0])).startsWith((CharSequence)"http");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[4]).trim()).describedAs("ActivityId Field in exception message should start with \"rId:\"", new Object[0])).startsWith((CharSequence)"rId:");
        }
        try {
            fs.listFiles(nonExistedFilePath2, false);
        }
        catch (Exception ex) {
            errorMessage = ex.getLocalizedMessage();
            errorFields = errorMessage.split(",");
            if (this.getAbfsServiceType() == AbfsServiceType.DFS) {
                ((ObjectArrayAssert)Assertions.assertThat((Object[])errorFields).describedAs("Number of Fields in exception message are not as expected", new Object[0])).hasSize(7);
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[0]).trim()).describedAs("Error Message Field in exception message is wrong", new Object[0])).isEqualTo((Object)"Operation failed: \"The specified path does not exist.\"");
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[1]).trim()).describedAs("Status Code Field in exception message should be \"404\"", new Object[0])).isEqualTo((Object)"404");
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[2]).trim()).describedAs("Http Rest Method Field in exception message should be \"GET\"", new Object[0])).isEqualTo((Object)"GET");
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[3]).trim()).describedAs("Url Field in exception message should start with \"http\"", new Object[0])).startsWith((CharSequence)"http");
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[4]).trim()).describedAs("ActivityId Field in exception message should start with \"rId:\"", new Object[0])).startsWith((CharSequence)"rId:");
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[5]).trim()).describedAs("StorageErrorCode Field in exception message should be \"PathNotFound\"", new Object[0])).isEqualTo((Object)"PathNotFound");
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[6]).trim()).describedAs("StorageErrorMessage Field in exception message should contain \"RequestId\"", new Object[0])).contains(new CharSequence[]{"RequestId"});
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[6]).trim()).describedAs("StorageErrorMessage Field in exception message should contain \"Time\"", new Object[0])).contains(new CharSequence[]{"Time"});
            }
            ((ObjectArrayAssert)Assertions.assertThat((Object[])errorFields).describedAs("Number of Fields in exception message are not as expected", new Object[0])).hasSize(5);
            if (this.getAbfsStore(fs).getAbfsConfiguration().enableAbfsListIterator()) {
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[0]).trim()).describedAs("Error Message Field in exception message is wrong", new Object[0])).contains(new CharSequence[]{"Operation failed: \"The specified container does not exist.\""});
            } else {
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[0]).trim()).describedAs("Error Message Field in exception message is wrong", new Object[0])).contains(new CharSequence[]{"Operation failed: \"The specified blob does not exist.\""});
            }
            ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[1]).trim()).describedAs("Status Code Field in exception message should be \"404\"", new Object[0])).isEqualTo((Object)"404");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[2]).trim()).describedAs("Http Rest Method Field in exception message should be \"HEAD\"", new Object[0])).isEqualTo((Object)"HEAD");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[3]).trim()).describedAs("Url Field in exception message should start with \"http\"", new Object[0])).startsWith((CharSequence)"http");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)errorFields[4]).trim()).describedAs("ActivityId Field in exception message should start with \"rId:\"", new Object[0])).startsWith((CharSequence)"rId:");
        }
    }

    @Test
    public void testCustomTokenFetchRetryCount() throws Exception {
        this.testWithDifferentCustomTokenFetchRetry(0);
        this.testWithDifferentCustomTokenFetchRetry(3);
        this.testWithDifferentCustomTokenFetchRetry(5);
    }

    public void testWithDifferentCustomTokenFetchRetry(int numOfRetries) throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Configuration config = this.getCustomAuthConfiguration(numOfRetries);
        try (AzureBlobFileSystem fs1 = (AzureBlobFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)config);){
            RetryTestTokenProvider retryTestTokenProvider = RetryTestTokenProvider.getCurrentRetryTestProviderInstance(this.getAccessTokenProvider(fs1));
            retryTestTokenProvider.resetStatusToFirstTokenFetch();
            LambdaTestUtils.intercept(Exception.class, () -> fs1.getFileStatus(new Path("/")));
            ((AbstractIntegerAssert)Assertions.assertThat((int)retryTestTokenProvider.getRetryCount()).describedAs("Number of token fetch retries done does not match with fs.azure.custom.token.fetch.retry.count configured", new Object[0])).isEqualTo(numOfRetries);
        }
    }

    @Test
    public void testAuthFailException() throws Exception {
        Configuration config = this.getCustomAuthConfiguration(0);
        AzureBlobFileSystem fs = this.getFileSystem(config);
        AbfsRestOperationException e = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.getFileStatus(new Path("/")));
        String errorDesc = "Should throw RestOp exception on AAD failure";
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getStatusCode()).describedAs("Incorrect status code: " + errorDesc, new Object[0])).isEqualTo(-1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)e.getErrorCode()).describedAs("Incorrect error code: " + errorDesc, new Object[0])).isEqualTo((Object)AzureServiceErrorCode.UNKNOWN);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getErrorMessage()).describedAs("Incorrect error message: " + errorDesc, new Object[0])).contains(new CharSequence[]{"Auth failure: "});
    }

    private Configuration getCustomAuthConfiguration(int numOfRetries) {
        Configuration config = new Configuration(this.getRawConfiguration());
        String accountName = config.get("fs.azure.abfs.account.name");
        config.set(ConfigurationKeys.accountProperty((String)"fs.azure.account.auth.type", (String)accountName), "Custom");
        config.set(ConfigurationKeys.accountProperty((String)"fs.azure.account.oauth.provider.type", (String)accountName), RETRY_TEST_TOKEN_PROVIDER);
        config.setInt("fs.azure.custom.token.fetch.retry.count", numOfRetries);
        config.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        config.setBoolean("fs.azure.account.hns.enabled", config.getBoolean("fs.azure.test.namespace.enabled", true));
        return config;
    }
}

