/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAbfsNetworkStatistics
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsNetworkStatistics.class);
    private static final int WRITE_OPERATION_LOOP_COUNT = 10;

    private int countDirectory(String path) {
        int index = path.indexOf(this.getFileSystemName());
        if (index == -1) {
            return 0;
        }
        return (int)path.substring(index + this.getFileSystemName().length()).chars().filter(ch -> ch == "/".charAt(0)).count();
    }

    @Test
    public void testAbfsHttpSendStatistics() throws IOException {
        this.describe("Test to check correct values of statistics after Abfs http send request is done.", new Object[0]);
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.create.blob.idempotency", false);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)fileSystem;){
            Path sendRequestPath = this.path(this.getMethodName());
            String path = sendRequestPath.toString();
            int directory = this.countDirectory(path);
            String testNetworkStatsString = "http_send";
            Map metricMap = this.getInstrumentationMap(fs);
            long expectedConnectionsMade = metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
            long expectedRequestsSent = metricMap.get(AbfsStatistic.SEND_REQUESTS.getStatName());
            long expectedBytesSent = 0L;
            AbfsClient client = fs.getAbfsStore().getClientHandler().getIngressClient();
            try (AbfsOutputStream out = this.createAbfsOutputStreamWithFlushEnabled(fs, sendRequestPath);){
                if (client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs)) {
                    expectedRequestsSent += (long)directory;
                    expectedConnectionsMade += (long)(directory * 2);
                } else {
                    ++expectedRequestsSent;
                    ++expectedConnectionsMade;
                }
                out.write(testNetworkStatsString.getBytes());
                out.hflush();
                if (fs.getAbfsStore().isAppendBlobKey(fs.makeQualified(sendRequestPath).toString()) || fs.getAbfsStore().getAbfsConfiguration().isSmallWriteOptimizationEnabled()) {
                    ++expectedConnectionsMade;
                    ++expectedRequestsSent;
                } else {
                    expectedConnectionsMade += 2L;
                    expectedRequestsSent += 2L;
                }
                expectedBytesSent += (long)testNetworkStatsString.getBytes().length;
                metricMap = this.getInstrumentationMap(fs);
                this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, expectedConnectionsMade, metricMap);
                this.assertAbfsStatistics(AbfsStatistic.SEND_REQUESTS, expectedRequestsSent, metricMap);
                this.assertAbfsStatistics(AbfsStatistic.BYTES_SENT, expectedBytesSent, metricMap);
            }
            if (client instanceof AbfsDfsClient) {
                ++expectedConnectionsMade;
                ++expectedRequestsSent;
            }
            out = this.createAbfsOutputStreamWithFlushEnabled(fs, sendRequestPath);
            try {
                if (fs.getAbfsStore().getAbfsConfiguration().isConditionalCreateOverwriteEnabled()) {
                    if (client instanceof AbfsBlobClient && !this.getIsNamespaceEnabled(fs)) {
                        expectedRequestsSent += 2L;
                        expectedConnectionsMade += 5L;
                    } else {
                        expectedConnectionsMade += 3L;
                        expectedRequestsSent += 2L;
                    }
                } else {
                    ++expectedConnectionsMade;
                    ++expectedRequestsSent;
                }
                for (int i = 0; i < 10; ++i) {
                    out.write(testNetworkStatsString.getBytes());
                    out.hflush();
                    if (fs.getAbfsStore().isAppendBlobKey(fs.makeQualified(sendRequestPath).toString()) || this.getConfiguration().isSmallWriteOptimizationEnabled()) {
                        ++expectedConnectionsMade;
                        ++expectedRequestsSent;
                    } else {
                        expectedConnectionsMade += 2L;
                        expectedRequestsSent += 2L;
                    }
                    expectedBytesSent += (long)testNetworkStatsString.getBytes().length;
                }
                metricMap = fs.getInstrumentationMap();
                this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, expectedConnectionsMade, metricMap);
                this.assertAbfsStatistics(AbfsStatistic.SEND_REQUESTS, expectedRequestsSent, metricMap);
                this.assertAbfsStatistics(AbfsStatistic.BYTES_SENT, expectedBytesSent, metricMap);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbfsHttpResponseStatistics() throws IOException {
        long expectedBytesReceived;
        long expectedGetResponses;
        long expectedConnectionsMade;
        Map metricMap;
        this.describe("Test to check correct values of statistics after Http Response is processed.", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path getResponsePath = this.path(this.getMethodName());
        String testResponseString = "some response";
        FSDataOutputStream out = null;
        FSDataInputStream in = null;
        try {
            out = fs.create(getResponsePath);
            out.write(testResponseString.getBytes());
            out.hflush();
            metricMap = fs.getInstrumentationMap();
            long bytesWrittenToFile = testResponseString.getBytes().length;
            expectedConnectionsMade = (Long)metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
            expectedGetResponses = (Long)metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
            expectedBytesReceived = (Long)metricMap.get(AbfsStatistic.BYTES_RECEIVED.getStatName());
            in = fs.open(getResponsePath);
            ++expectedConnectionsMade;
            ++expectedGetResponses;
            int result = in.read();
            expectedBytesReceived += bytesWrittenToFile;
            metricMap = fs.getInstrumentationMap();
            this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, ++expectedConnectionsMade, metricMap);
            this.assertAbfsStatistics(AbfsStatistic.GET_RESPONSES, ++expectedGetResponses, metricMap);
            this.assertAbfsStatistics(AbfsStatistic.BYTES_RECEIVED, expectedBytesReceived, metricMap);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
        try {
            StringBuilder largeBuffer = new StringBuilder();
            out = fs.create(getResponsePath);
            for (int i = 0; i < 10; ++i) {
                out.write(testResponseString.getBytes());
                out.hflush();
                largeBuffer.append(testResponseString);
            }
            metricMap = fs.getInstrumentationMap();
            expectedConnectionsMade = (Long)metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
            expectedGetResponses = (Long)metricMap.get(AbfsStatistic.GET_RESPONSES.getStatName());
            in = fs.open(getResponsePath);
            ++expectedConnectionsMade;
            ++expectedGetResponses;
            in.read(0L, largeBuffer.toString().getBytes(), 0, largeBuffer.toString().getBytes().length);
            expectedBytesReceived += (long)(10 * testResponseString.getBytes().length);
            metricMap = fs.getInstrumentationMap();
            this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, ++expectedConnectionsMade, metricMap);
            this.assertAbfsStatistics(AbfsStatistic.GET_RESPONSES, ++expectedGetResponses, metricMap);
            this.assertAbfsStatistics(AbfsStatistic.BYTES_RECEIVED, expectedBytesReceived, metricMap);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbfsHttpResponseFailure() throws IOException {
        this.describe("Test to check the values of bytes received counter when a response is failed", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path responseFailurePath = this.path(this.getMethodName());
        FSDataOutputStream out = null;
        try {
            out = fs.create(responseFailurePath);
            out = fs.create(responseFailurePath, false);
        }
        catch (FileAlreadyExistsException faee) {
            try {
                Map metricMap = fs.getInstrumentationMap();
                this.assertAbfsStatistics(AbfsStatistic.BYTES_RECEIVED, 0L, metricMap);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out});
    }
}

