/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

public final class ITestAbfsMsiTokenProvider
extends AbstractAbfsIntegrationTest {
    @Test
    public void test() throws IOException {
        AbfsConfiguration conf = this.getConfiguration();
        ((AbstractStringAssert)Assumptions.assumeThat((String)conf.get("fs.azure.account.oauth2.msi.endpoint")).isNotNull()).isNotEmpty();
        ((AbstractStringAssert)Assumptions.assumeThat((String)conf.get("fs.azure.account.oauth2.msi.tenant")).isNotNull()).isNotEmpty();
        ((AbstractStringAssert)Assumptions.assumeThat((String)conf.get("fs.azure.account.oauth2.client.id")).isNotNull()).isNotEmpty();
        ((AbstractStringAssert)Assumptions.assumeThat((String)conf.get("fs.azure.account.oauth2.msi.authority")).isNotNull()).isNotEmpty();
        String tenantGuid = conf.getPasswordString("fs.azure.account.oauth2.msi.tenant");
        String clientId = conf.getPasswordString("fs.azure.account.oauth2.client.id");
        String authEndpoint = this.getTrimmedPasswordString(conf, "fs.azure.account.oauth2.msi.endpoint", "http://169.254.169.254/metadata/identity/oauth2/token");
        String authority = this.getTrimmedPasswordString(conf, "fs.azure.account.oauth2.msi.authority", "https://login.microsoftonline.com/");
        MsiTokenProvider tokenProvider = new MsiTokenProvider(authEndpoint, tenantGuid, clientId, authority);
        AzureADToken token = null;
        token = tokenProvider.getToken();
        Assertions.assertThat((String)token.getAccessToken()).isNotEmpty();
        Assertions.assertThat((boolean)token.getExpiry().after(new Date())).isEqualTo(true);
    }

    private String getTrimmedPasswordString(AbfsConfiguration conf, String key, String defaultValue) throws IOException {
        String value = conf.getPasswordString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = defaultValue;
        }
        return value.trim();
    }
}

