/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformer;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.Test;

public class ITestAbfsIdentityTransformer
extends AbstractAbfsScaleTest {
    private final UserGroupInformation userGroupInfo = UserGroupInformation.getCurrentUser();
    private final String localUser = this.userGroupInfo.getShortUserName();
    private final String localGroup = this.userGroupInfo.getPrimaryGroupName();
    private static final String DAEMON = "daemon";
    private static final String ASTERISK = "*";
    private static final String SHORT_NAME = "abc";
    private static final String DOMAIN = "domain.com";
    private static final String FULLY_QUALIFIED_NAME = "abc@domain.com";
    private static final String SERVICE_PRINCIPAL_ID = UUID.randomUUID().toString();

    @Test
    public void testDaemonServiceSettingIdentity() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)DAEMON, (Object)identityTransformer.transformUserOrGroupForSetRequest(DAEMON), (String)"Identity should not change for default config");
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "a,b,c,d");
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)DAEMON, (Object)identityTransformer.transformUserOrGroupForSetRequest(DAEMON), (String)"Identity should not change when substitution list doesn't contain daemon");
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "daemon,a,b,c,d");
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformUserOrGroupForSetRequest(DAEMON), (String)"Identity should be replaced to servicePrincipalId");
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", ASTERISK);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformUserOrGroupForSetRequest(DAEMON), (String)"Identity should be replaced to servicePrincipalId");
    }

    @Test
    public void testFullyQualifiedNameSettingIdentity() throws IOException {
        Configuration config = this.getRawConfiguration();
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)SHORT_NAME, (Object)identityTransformer.transformUserOrGroupForSetRequest(SHORT_NAME), (String)"short name should not be converted to full name by default");
        this.resetIdentityConfig(config);
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)FULLY_QUALIFIED_NAME, (Object)identityTransformer.transformUserOrGroupForSetRequest(SHORT_NAME), (String)"short name should be converted to full name");
    }

    @Test
    public void testNoOpForSettingOidAsIdentity() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        config.set("fs.azure.identity.transformer.service.principal.id", UUID.randomUUID().toString());
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "a,b,c,d");
        IdentityTransformer identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        String principalId = UUID.randomUUID().toString();
        ITestAbfsIdentityTransformer.assertEquals((Object)principalId, (Object)identityTransformer.transformUserOrGroupForSetRequest(principalId), (String)"Identity should not be changed when owner is already a principal id ");
    }

    @Test
    public void testNoOpWhenSettingSuperUserAsdentity() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)"$superuser", (Object)identityTransformer.transformUserOrGroupForSetRequest("$superuser"), (String)"Identity should not be changed because it is not in substitution list");
    }

    @Test
    public void testIdentityReplacementForSuperUserGetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)this.localUser, (Object)identityTransformer.transformIdentityForGetRequest("$superuser", true, this.localUser), (String)"$superuser should be replaced with local user by default");
        config.setBoolean("fs.azure.identity.transformer.skip.superuser.replacement", true);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)"$superuser", (Object)identityTransformer.transformIdentityForGetRequest("$superuser", true, this.localUser), (String)"$superuser should not be replaced");
    }

    @Test
    public void testIdentityReplacementForDaemonServiceGetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser), (String)"By default servicePrincipalId should not be converted for GetFileStatus(), listFileStatus(), getAcl()");
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "a,b,c,d");
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser), (String)"servicePrincipalId should not be replaced if local daemon user is not in substitution list");
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", this.localUser + ",a,b,c,d");
        config.set("fs.azure.identity.transformer.service.principal.id", UUID.randomUUID().toString());
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser), (String)"servicePrincipalId should not be replaced if it is not equal to the SPN set in config");
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", this.localUser + ",a,b,c,d");
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)this.localUser, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser), (String)"servicePrincipalId should be transformed to local use");
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", ASTERISK);
        config.set("fs.azure.identity.transformer.service.principal.id", UUID.randomUUID().toString());
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser), (String)"servicePrincipalId should not be replaced if it is not equal to the SPN set in config");
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", ASTERISK);
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)this.localUser, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser), (String)"servicePrincipalId should be transformed to local user");
    }

    @Test
    public void testIdentityReplacementForKinitUserGetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)FULLY_QUALIFIED_NAME, (Object)identityTransformer.transformIdentityForGetRequest(FULLY_QUALIFIED_NAME, true, this.localUser), (String)"full name should not be transformed if shortname is not enabled");
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((Object)SHORT_NAME, (Object)identityTransformer.transformIdentityForGetRequest(FULLY_QUALIFIED_NAME, true, this.localUser), (String)"should convert the full owner name to shortname ");
        ITestAbfsIdentityTransformer.assertEquals((Object)FULLY_QUALIFIED_NAME, (Object)identityTransformer.transformIdentityForGetRequest(FULLY_QUALIFIED_NAME, false, this.localGroup), (String)"group name should not be converted to shortname ");
    }

    @Test
    public void transformAclEntriesForSetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        ArrayList aclEntriesToBeTransformed = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, DAEMON, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FULLY_QUALIFIED_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "$superuser", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, DAEMON, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)});
        ArrayList aclEntries = Lists.newArrayList((Iterable)aclEntriesToBeTransformed);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        identityTransformer.transformAclEntriesForSetRequest((List)aclEntries);
        this.checkAclEntriesList(aclEntriesToBeTransformed, aclEntries);
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "daemon,a,b,c,d");
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        identityTransformer.transformAclEntriesForSetRequest((List)aclEntries);
        ArrayList expectedAclEntries = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FULLY_QUALIFIED_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "$superuser", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FULLY_QUALIFIED_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)});
        this.checkAclEntriesList(aclEntries, expectedAclEntries);
    }

    @Test
    public void transformAclEntriesForGetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        ArrayList aclEntriesToBeTransformed = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FULLY_QUALIFIED_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "$superuser", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)});
        ArrayList aclEntries = Lists.newArrayList((Iterable)aclEntriesToBeTransformed);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        identityTransformer.transformAclEntriesForGetRequest((List)aclEntries, this.localUser, this.localGroup);
        this.checkAclEntriesList(aclEntriesToBeTransformed, aclEntries);
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", this.localUser + ",a,b,c,d");
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        aclEntries = Lists.newArrayList((Iterable)aclEntriesToBeTransformed);
        identityTransformer.transformAclEntriesForGetRequest((List)aclEntries, this.localUser, this.localGroup);
        ArrayList expectedAclEntries = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, this.localUser, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, this.localUser, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)});
        this.checkAclEntriesList(aclEntries, expectedAclEntries);
    }

    private void resetIdentityConfig(Configuration config) {
        config.unset("fs.azure.identity.transformer.enable.short.name");
        config.unset("fs.azure.identity.transformer.domain.name");
        config.unset("fs.azure.identity.transformer.service.principal.id");
        config.unset("fs.azure.identity.transformer.service.principal.substitution.list");
        config.unset("fs.azure.identity.transformer.skip.superuser.replacement");
    }

    private IdentityTransformer getTransformerWithDefaultIdentityConfig(Configuration config) throws IOException {
        this.resetIdentityConfig(config);
        return new IdentityTransformer(config);
    }

    private IdentityTransformer getTransformerWithCustomizedIdentityConfig(Configuration config) throws IOException {
        return new IdentityTransformer(config);
    }

    private void checkAclEntriesList(List<AclEntry> aclEntries, List<AclEntry> expected) {
        ITestAbfsIdentityTransformer.assertTrue((aclEntries.size() == expected.size() ? 1 : 0) != 0, (String)"list size not equals");
        for (int i = 0; i < aclEntries.size(); ++i) {
            ITestAbfsIdentityTransformer.assertEquals((Object)expected.get(i).getName(), (Object)aclEntries.get(i).getName(), (String)"Identity doesn't match");
        }
    }
}

