/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.io.IOUtils;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAbfsDurationTrackers
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsDurationTrackers.class);
    private static final AbfsStatistic[] HTTP_DURATION_TRACKER_LIST = new AbfsStatistic[]{AbfsStatistic.HTTP_HEAD_REQUEST, AbfsStatistic.HTTP_GET_REQUEST, AbfsStatistic.HTTP_DELETE_REQUEST, AbfsStatistic.HTTP_PUT_REQUEST};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbfsHttpCallsDurations() throws IOException {
        this.describe("test to verify if the DurationTrackers for abfs http calls work as expected.", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path(this.getMethodName());
        AbfsOutputStream out = null;
        AbfsInputStream in = null;
        try {
            out = this.createAbfsOutputStreamWithFlushEnabled(fs, testFilePath);
            out.write(97);
            out.hflush();
            in = fs.getAbfsStore().openFileForRead(testFilePath, fs.getFsStatistics(), this.getTestTracingContext(fs, false));
            int res = in.read();
            LOG.info("Result of Read: {}", (Object)res);
            fs.delete(testFilePath, false);
            IOStatistics ioStatistics = IOStatisticAssertions.extractStatistics((Object)fs);
            LOG.info(IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)ioStatistics));
            this.assertDurationTracker(ioStatistics);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out, in});
    }

    private void assertDurationTracker(IOStatistics ioStatistics) {
        for (AbfsStatistic abfsStatistic : HTTP_DURATION_TRACKER_LIST) {
            ((AbstractDoubleAssert)Assertions.assertThat((double)IOStatisticAssertions.lookupMeanStatistic((IOStatistics)ioStatistics, (String)(abfsStatistic.getStatName() + ".mean")).mean()).describedAs("The DurationTracker Named " + abfsStatistic.getStatName() + " Doesn't match the expected value.", new Object[0])).isGreaterThan(0.0);
        }
    }
}

