/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public final class ITestAbfsClient
extends AbstractAbfsIntegrationTest {
    private static final int LIST_MAX_RESULTS = 500;
    private static final int LIST_MAX_RESULTS_SERVER = 5000;

    @Disabled(value="HADOOP-16845: Invalid continuation tokens are ignored by the ADLS Gen2 service, so we are disabling this test until the service is fixed.")
    @Test
    public void testContinuationTokenHavingEqualSign() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient abfsClient = fs.getAbfsClient();
        try {
            AbfsRestOperation op = abfsClient.listPath("/", true, 500, "===========", this.getTestTracingContext(fs, true), null).getOp();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)false);
        }
        catch (AbfsRestOperationException ex) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"InvalidQueryParameterValue", (Object)ex.getErrorCode().getErrorCode());
        }
    }

    @Disabled(value="Enable this to verify the log warning message format for HostNotFoundException")
    @Test
    public void testUnknownHost() throws Exception {
        AbfsConfiguration conf = this.getConfiguration();
        String accountName = this.getAccountName();
        String fakeAccountName = "fake" + UUID.randomUUID() + accountName.substring(accountName.indexOf("."));
        String fsDefaultFS = conf.get("fs.defaultFS");
        conf.set("fs.defaultFS", fsDefaultFS.replace(accountName, fakeAccountName));
        conf.set("fs.azure.account.key." + fakeAccountName, this.getAccountKey());
        LambdaTestUtils.intercept(AbfsRestOperationException.class, (String)("UnknownHostException: " + fakeAccountName), () -> FileSystem.get((Configuration)conf.getRawConfiguration()));
    }

    @Test
    public void testListPathWithValidListMaxResultsValues() throws IOException, ExecutionException, InterruptedException {
        int fileCount = 10;
        Path directory = this.getUniquePath("testWithValidListMaxResultsValues");
        this.createDirectoryWithNFiles(directory, 10);
        int[] testData = new int[]{110, 11, 10, 9, 1};
        for (int i = 0; i < testData.length; ++i) {
            int listMaxResults = testData[i];
            this.setListMaxResults(listMaxResults);
            int expectedListResultsSize = listMaxResults > 10 ? 10 : listMaxResults;
            AbfsRestOperation op = this.getFileSystem().getAbfsClient().listPath(directory.toString(), false, this.getListMaxResults(), null, this.getTestTracingContext(this.getFileSystem(), true), null).getOp();
            List list = op.getResult().getListResultSchema().paths();
            String continuationToken = op.getResult().getResponseHeader("x-ms-continuation");
            if (continuationToken == null) {
                ((ListAssert)Assertions.assertThat((List)list).describedAs("AbfsClient.listPath() should return %d items when listMaxResults is %d, directory contains %d items and listing is complete", new Object[]{expectedListResultsSize, listMaxResults, 10})).hasSize(expectedListResultsSize);
                continue;
            }
            ((ListAssert)Assertions.assertThat((List)list).describedAs("AbfsClient.listPath() should return %d items or less when listMaxResults is %d,  directory contains %d items and listing is incomplete", new Object[]{expectedListResultsSize, listMaxResults, 10})).hasSizeLessThanOrEqualTo(expectedListResultsSize);
        }
    }

    @Test
    public void testListPathWithValueGreaterThanServerMaximum() throws IOException, ExecutionException, InterruptedException {
        this.setListMaxResults(5100);
        Path directory = this.getUniquePath("testWithValueGreaterThanServerMaximum");
        this.createDirectoryWithNFiles(directory, 5200);
        AbfsRestOperation op = this.getFileSystem().getAbfsClient().listPath(directory.toString(), false, this.getListMaxResults(), null, this.getTestTracingContext(this.getFileSystem(), true), null).getOp();
        List list = op.getResult().getListResultSchema().paths();
        String continuationToken = op.getResult().getResponseHeader("x-ms-continuation");
        if (continuationToken == null) {
            ((ListAssert)Assertions.assertThat((List)list).describedAs("AbfsClient.listPath() should return %d items when listMaxResults is %d directory contains %d items and listing is complete", new Object[]{5000, 5000, 5000})).hasSize(5000);
        } else {
            ((ListAssert)Assertions.assertThat((List)list).describedAs("AbfsClient.listPath() should return %d items or less when listMaxResults is %d, directory contains %d items and listing is complete", new Object[]{5000, 5000, 5000})).hasSizeLessThanOrEqualTo(5000);
        }
    }

    @Test
    public void testListPathWithInvalidListMaxResultsValues() throws Exception {
        for (int i = -1; i < 1; ++i) {
            this.setListMaxResults(i);
            LambdaTestUtils.intercept(AbfsRestOperationException.class, (String)"Operation failed: \"One of the query parameters specified in the request URI is outside the permissible range.", () -> this.listPath("directory"));
        }
    }

    private List<? extends ListResultEntrySchema> listPath(String directory) throws IOException {
        return this.getFileSystem().getAbfsClient().listPath(directory, false, this.getListMaxResults(), null, this.getTestTracingContext(this.getFileSystem(), true), null).getOp().getResult().getListResultSchema().paths();
    }

    private int getListMaxResults() throws IOException {
        return this.getFileSystem().getAbfsStore().getAbfsConfiguration().getListMaxResults();
    }

    private void setListMaxResults(int listMaxResults) throws IOException {
        this.getFileSystem().getAbfsStore().getAbfsConfiguration().setListMaxResults(listMaxResults);
    }

    private void createDirectoryWithNFiles(Path directory, int n) throws ExecutionException, InterruptedException {
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        for (int i = 0; i < n; ++i) {
            Path path = new Path("/" + directory + "/test" + i);
            tasks.add(es.submit(() -> {
                this.touch(fileName);
                return null;
            }));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
    }
}

