/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.test.TestName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=900000L, unit=TimeUnit.MILLISECONDS)
public class AbstractAbfsTestWithTimeout
extends Assertions {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAbfsTestWithTimeout.class);
    @RegisterExtension
    public TestName methodName = new TestName();

    @BeforeAll
    public static void nameTestThread() {
        Thread.currentThread().setName("JUnit");
    }

    @BeforeEach
    public void nameThread() {
        Thread.currentThread().setName("JUnit-" + this.methodName.getMethodName());
    }

    protected int getTestTimeoutMillis() {
        return 900000;
    }

    protected void describe(String text, Object ... args) {
        LOG.info("\n\n{}: {}\n", (Object)this.methodName.getMethodName(), (Object)String.format(text, args));
    }

    protected boolean validateContent(AzureBlobFileSystem fs, Path path, byte[] originalByteArray) throws IOException {
        int lenOfOriginalByteArray = originalByteArray.length;
        try (FSDataInputStream in = fs.open(path);){
            byte valueOfContentAtPos = (byte)in.read();
            for (int pos = 0; valueOfContentAtPos != -1 && pos < lenOfOriginalByteArray; ++pos) {
                if (originalByteArray[pos] != valueOfContentAtPos) {
                    AbstractAbfsTestWithTimeout.assertEquals((byte)originalByteArray[pos], (byte)valueOfContentAtPos, (String)String.format("Mismatch in content validation at position %d", pos));
                    boolean bl = false;
                    return bl;
                }
                valueOfContentAtPos = (byte)in.read();
            }
            if (valueOfContentAtPos != -1) {
                AbstractAbfsTestWithTimeout.assertEquals((int)-1, (int)valueOfContentAtPos, (String)"Expected end of file");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }
}

