/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.AzureMetricsTestUtil;
import org.apache.hadoop.fs.azure.metrics.BandwidthGaugeUpdater;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBandwidthGaugeUpdater {
    @Test
    public void testSingleThreaded() throws Exception {
        AzureFileSystemInstrumentation instrumentation = new AzureFileSystemInstrumentation(new Configuration());
        BandwidthGaugeUpdater updater = new BandwidthGaugeUpdater(instrumentation, 1000, true);
        updater.triggerUpdate(true);
        Assertions.assertEquals((long)0L, (long)AzureMetricsTestUtil.getCurrentBytesWritten(instrumentation));
        updater.blockUploaded(new Date(), new Date(), 150L);
        updater.triggerUpdate(true);
        Assertions.assertEquals((long)150L, (long)AzureMetricsTestUtil.getCurrentBytesWritten(instrumentation));
        updater.blockUploaded(new Date(new Date().getTime() - 10000L), new Date(), 200L);
        updater.triggerUpdate(true);
        long currentBytes = AzureMetricsTestUtil.getCurrentBytesWritten(instrumentation);
        Assertions.assertTrue((currentBytes > 18L && currentBytes < 22L ? 1 : 0) != 0, (String)("We expect around (200/10 = 20) bytes written as the gauge value.Got " + currentBytes));
        updater.close();
    }

    @Test
    public void testMultiThreaded() throws Exception {
        AzureFileSystemInstrumentation instrumentation = new AzureFileSystemInstrumentation(new Configuration());
        final BandwidthGaugeUpdater updater = new BandwidthGaugeUpdater(instrumentation, 1000, true);
        Thread[] threads = new Thread[10];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    updater.blockDownloaded(new Date(), new Date(), 10L);
                    updater.blockDownloaded(new Date(0L), new Date(0L), 10L);
                }
            });
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        updater.triggerUpdate(false);
        Assertions.assertEquals((long)(10 * threads.length), (long)AzureMetricsTestUtil.getCurrentBytesRead(instrumentation));
        updater.close();
    }
}

