/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.integration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.integration.AzureTestConstants;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AzureTestUtils
extends Assertions {
    private static final Logger LOG = LoggerFactory.getLogger(AzureTestUtils.class);
    public static final String UNSET_PROPERTY = "unset";

    public static NativeAzureFileSystem createTestFileSystem(Configuration conf) throws IOException {
        String fsname = conf.getTrimmed("test.fs.azure.name", "");
        boolean liveTest = !StringUtils.isEmpty((CharSequence)fsname);
        URI testURI = null;
        if (liveTest) {
            testURI = URI.create(fsname);
            liveTest = testURI.getScheme().equals("wasb");
        }
        if (!liveTest) {
            throw new TestAbortedException("No test filesystem in test.fs.azure.name");
        }
        NativeAzureFileSystem fs1 = new NativeAzureFileSystem();
        fs1.initialize(testURI, conf);
        return fs1;
    }

    public static FileContext createTestFileContext(Configuration conf) throws IOException {
        String fsname = conf.getTrimmed("test.fs.azure.name", "");
        boolean liveTest = !StringUtils.isEmpty((CharSequence)fsname);
        URI testURI = null;
        if (liveTest) {
            testURI = URI.create(fsname);
            liveTest = testURI.getScheme().equals("wasb");
        }
        if (!liveTest) {
            throw new TestAbortedException("No test filesystem in test.fs.azure.name");
        }
        FileContext fc = FileContext.getFileContext((URI)testURI, (Configuration)conf);
        return fc;
    }

    public static long getTestPropertyLong(Configuration conf, String key, long defVal) {
        return Long.valueOf(AzureTestUtils.getTestProperty(conf, key, Long.toString(defVal)));
    }

    public static long getTestPropertyBytes(Configuration conf, String key, String defVal) {
        return StringUtils.TraditionalBinaryPrefix.string2long((String)AzureTestUtils.getTestProperty(conf, key, defVal));
    }

    public static int getTestPropertyInt(Configuration conf, String key, int defVal) {
        return (int)AzureTestUtils.getTestPropertyLong(conf, key, defVal);
    }

    public static boolean getTestPropertyBool(Configuration conf, String key, boolean defVal) {
        return Boolean.valueOf(AzureTestUtils.getTestProperty(conf, key, Boolean.toString(defVal)));
    }

    public static String getTestProperty(Configuration conf, String key, String defVal) {
        String confVal = conf != null ? conf.getTrimmed(key, defVal) : defVal;
        String propval = System.getProperty(key);
        return StringUtils.isNotEmpty((CharSequence)propval) && !UNSET_PROPERTY.equals(propval) ? propval : confVal;
    }

    public static Exception verifyExceptionClass(Class clazz, Exception ex) throws Exception {
        if (!ex.getClass().equals(clazz)) {
            throw ex;
        }
        return ex;
    }

    public static void disableFilesystemCaching(Configuration conf) {
        conf.setBoolean("fs.wasb.impl.disable.cache", true);
    }

    public static Path createTestPath(Path defVal) {
        String testUniqueForkId = System.getProperty("test.unique.fork.id");
        return testUniqueForkId == null ? defVal : new Path("/" + testUniqueForkId, "test");
    }

    public static Path blobPathForTests(FileSystem fs, String filename) {
        String testUniqueForkId = System.getProperty("test.unique.fork.id");
        return fs.makeQualified(new Path(AzureTestConstants.PAGE_BLOB_DIR, (String)(testUniqueForkId == null ? filename : testUniqueForkId + "/" + filename)));
    }

    public static Path pathForTests(FileSystem fs, String filename) {
        String testUniqueForkId = System.getProperty("test.unique.fork.id");
        return fs.makeQualified(new Path(testUniqueForkId == null ? "/test/" + filename : testUniqueForkId + "/" + filename));
    }

    public static String getForkID() {
        return System.getProperty("test.unique.fork.id", "fork-1");
    }

    public static boolean isParallelExecution() {
        return Boolean.getBoolean("test.parallel.execution");
    }

    public static void assertInstanceOf2(Class<?> expectedClass, Object obj) {
        Assertions.assertTrue((boolean)expectedClass.isAssignableFrom(obj.getClass()), (String)String.format("Expected instance of class %s, but is %s.", expectedClass, obj.getClass()));
    }

    public static <T extends Class<?>> String buildClassListString(List<T> classes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < classes.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(((Class)classes.get(i)).getName());
        }
        return sb.toString();
    }

    private AzureTestUtils() {
    }

    public static void assertOptionEquals(Configuration conf, String key, String expected) {
        AzureTestUtils.assertEquals((Object)expected, (Object)conf.get(key), (String)("Value of " + key));
    }

    public static void assume(String message, boolean condition) {
        if (!condition) {
            LOG.warn(message);
        }
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)condition).as(message, new Object[0])).isTrue();
    }

    public static long getLongGaugeValue(NativeAzureFileSystem fs, String gaugeName) {
        return MetricsAsserts.getLongGauge((String)gaugeName, (MetricsRecordBuilder)MetricsAsserts.getMetrics((MetricsSource)fs.getInstrumentation()));
    }

    public static long getLongCounterValue(NativeAzureFileSystem fs, String counterName) {
        return MetricsAsserts.getLongCounter((String)counterName, (MetricsRecordBuilder)MetricsAsserts.getMetrics((MetricsSource)fs.getInstrumentation()));
    }

    public static void deleteQuietly(FileSystem fs, Path path, boolean recursive) throws IOException {
        if (fs != null && path != null) {
            try {
                fs.delete(path, recursive);
            }
            catch (IOException e) {
                LOG.warn("When deleting {}", (Object)path, (Object)e);
            }
        }
    }

    public static AzureBlobStorageTestAccount cleanup(AzureBlobStorageTestAccount testAccount) throws Exception {
        if (testAccount != null) {
            testAccount.cleanup();
            testAccount = null;
        }
        return null;
    }

    public static AzureBlobStorageTestAccount cleanupTestAccount(AzureBlobStorageTestAccount testAccount) {
        if (testAccount != null) {
            try {
                testAccount.cleanup();
            }
            catch (Exception e) {
                LOG.error("While cleaning up test account: ", (Throwable)e);
            }
        }
        return null;
    }

    public static void assumeScaleTestsEnabled(Configuration conf) {
        boolean enabled = AzureTestUtils.getTestPropertyBool(conf, "fs.azure.scale.test.enabled", false);
        AzureTestUtils.assume("Scale test disabled: to enable set property fs.azure.scale.test.enabled", enabled);
    }

    public static String verifyWasbAccountNameInConfig(Configuration conf) {
        String accountName = conf.get("fs.azure.account.name");
        if (accountName == null) {
            accountName = conf.get("fs.azure.wasb.account.name");
        }
        ((AbstractStringAssert)((AbstractStringAssert)Assumptions.assumeThat((String)accountName).as("Account for WASB is missing or it is not in correct format", new Object[0])).isNotNull()).doesNotEndWith((CharSequence)"\\.blob(\\.preprod)?\\.core\\.windows\\.net");
        return accountName;
    }

    public static void writeStringToFile(FileSystem fs, Path path, String value) throws IOException {
        FSDataOutputStream outputStream = fs.create(path, true);
        AzureTestUtils.writeStringToStream(outputStream, value);
    }

    public static void writeStringToStream(FSDataOutputStream outputStream, String value) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream));
        writer.write(value);
        writer.close();
    }

    public static String readStringFromFile(FileSystem fs, Path testFile) throws IOException {
        FSDataInputStream inputStream = fs.open(testFile);
        String ret = AzureTestUtils.readStringFromStream(inputStream);
        inputStream.close();
        return ret;
    }

    public static String readStringFromStream(FSDataInputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
        int BUFFER_SIZE = 1024;
        char[] buffer = new char[1024];
        int count = reader.read(buffer, 0, 1024);
        if (count > 1024) {
            throw new IOException("Exceeded buffer size");
        }
        inputStream.close();
        return new String(buffer, 0, count);
    }

    public static void assumeNamespaceDisabled(Configuration conf) {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)conf.getBoolean("fs.azure.test.namespace.enabled", false)).as("Hierarchical namespace is enabled for test account.", new Object[0])).isFalse();
    }
}

