/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestWithTimeout;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.apache.hadoop.fs.azure.WasbFsck;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestWasbFsck
extends AbstractWasbTestWithTimeout {
    private AzureBlobStorageTestAccount testAccount;
    private FileSystem fs;
    private InMemoryBlockBlobStore backingStore;

    @BeforeEach
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createMock();
        this.fs = this.testAccount.getFileSystem();
        this.backingStore = this.testAccount.getMockStorage().getBackingStore();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testAccount.cleanup();
        this.fs = null;
        this.backingStore = null;
    }

    private int getNumTempBlobs() {
        int count = 0;
        for (String key : this.backingStore.getKeys()) {
            if (!key.contains("_$azuretmpfolder$")) continue;
            ++count;
        }
        return count;
    }

    @Test
    @Disabled
    public void testRecover() throws Exception {
        Path danglingFile = new Path("/crashedInTheMiddle");
        FSDataOutputStream stream = this.fs.create(danglingFile);
        stream.write(new byte[]{1, 2, 3});
        stream.flush();
        FileStatus fileStatus = this.fs.getFileStatus(danglingFile);
        TestWasbFsck.assertNotNull((Object)fileStatus);
        TestWasbFsck.assertEquals((long)0L, (long)fileStatus.getLen());
        TestWasbFsck.assertEquals((int)1, (int)this.getNumTempBlobs());
        this.runFsck("-move");
        fileStatus = this.fs.getFileStatus(new Path("/lost+found", danglingFile.getName()));
        TestWasbFsck.assertNotNull((Object)fileStatus);
        TestWasbFsck.assertEquals((long)3L, (long)fileStatus.getLen());
        TestWasbFsck.assertEquals((int)0, (int)this.getNumTempBlobs());
        TestWasbFsck.assertFalse((boolean)this.fs.exists(danglingFile));
    }

    private void runFsck(String command) throws Exception {
        Configuration conf = this.fs.getConf();
        conf.setInt("fs.azure.fsck.temp.expiry.seconds", 0);
        WasbFsck fsck = new WasbFsck(conf);
        fsck.setMockFileSystemForTesting(this.fs);
        fsck.run(new String[]{"wasb://mockContainer@mockAccount-c01112a3-2a23-433e-af2a-e808ea385136.blob.core.windows.net/", command});
    }

    @Test
    public void testDelete() throws Exception {
        Path danglingFile = new Path("/crashedInTheMiddle");
        FSDataOutputStream stream = this.fs.create(danglingFile);
        stream.write(new byte[]{1, 2, 3});
        stream.flush();
        FileStatus fileStatus = this.fs.getFileStatus(danglingFile);
        TestWasbFsck.assertNotNull((Object)fileStatus);
        TestWasbFsck.assertEquals((long)0L, (long)fileStatus.getLen());
        TestWasbFsck.assertEquals((int)1, (int)this.getNumTempBlobs());
        this.runFsck("-delete");
        TestWasbFsck.assertEquals((int)0, (int)this.getNumTempBlobs());
        TestWasbFsck.assertFalse((boolean)this.fs.exists(danglingFile));
    }
}

