/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.blob.BlockEntry;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.BlockBlobAppendStream;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.SyncableDataOutputStream;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNativeAzureFileSystemBlockCompaction
extends AbstractWasbTestBase {
    private static final String TEST_FILE = "/user/active/test.dat";
    private static final Path TEST_PATH = new Path("/user/active/test.dat");
    private static final String TEST_FILE_NORMAL = "/user/normal/test.dat";
    private static final Path TEST_PATH_NORMAL = new Path("/user/normal/test.dat");
    private AzureBlobStorageTestAccount testAccount = null;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.testAccount = this.createTestAccount();
        this.fs = this.testAccount.getFileSystem();
        Configuration conf = this.fs.getConf();
        conf.setBoolean("fs.azure.enable.append.support", true);
        conf.set("fs.azure.block.blob.with.compaction.dir", "/user/active");
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
    }

    private static byte[] getTestData(int size) {
        byte[] testData = new byte[size];
        System.arraycopy(RandomStringUtils.randomAlphabetic((int)size).getBytes(), 0, testData, 0, size);
        return testData;
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    private BlockBlobAppendStream getBlockBlobAppendStream(FSDataOutputStream appendStream) {
        SyncableDataOutputStream dataOutputStream = null;
        if (appendStream.getWrappedStream() instanceof NativeAzureFileSystem.NativeAzureFsOutputStream) {
            NativeAzureFileSystem.NativeAzureFsOutputStream fsOutputStream = (NativeAzureFileSystem.NativeAzureFsOutputStream)appendStream.getWrappedStream();
            dataOutputStream = (SyncableDataOutputStream)fsOutputStream.getOutStream();
        }
        if (appendStream.getWrappedStream() instanceof SyncableDataOutputStream) {
            dataOutputStream = (SyncableDataOutputStream)appendStream.getWrappedStream();
        }
        TestNativeAzureFileSystemBlockCompaction.assertNotNull((Object)dataOutputStream, (String)("Did not recognize " + dataOutputStream));
        return (BlockBlobAppendStream)dataOutputStream.getOutStream();
    }

    private void verifyBlockList(BlockBlobAppendStream blockBlobStream, int[] testData) throws Throwable {
        List blockList = blockBlobStream.getBlockList();
        TestNativeAzureFileSystemBlockCompaction.assertEquals((int)testData.length, (int)blockList.size(), (String)"Block list length");
        int i = 0;
        for (BlockEntry block : blockList) {
            TestNativeAzureFileSystemBlockCompaction.assertTrue((block.getSize() == (long)testData[i++] ? 1 : 0) != 0);
        }
    }

    private void appendBlockList(FSDataOutputStream fsStream, ByteArrayOutputStream memStream, int[] testData) throws Throwable {
        for (int d : testData) {
            byte[] data = TestNativeAzureFileSystemBlockCompaction.getTestData(d);
            memStream.write(data);
            fsStream.write(data);
        }
        fsStream.hflush();
    }

    @Test
    public void testCompactionDisabled() throws Throwable {
        try (FSDataOutputStream appendStream = this.fs.create(TEST_PATH_NORMAL);){
            SyncableDataOutputStream dataOutputStream = null;
            OutputStream wrappedStream = appendStream.getWrappedStream();
            if (wrappedStream instanceof NativeAzureFileSystem.NativeAzureFsOutputStream) {
                NativeAzureFileSystem.NativeAzureFsOutputStream fsOutputStream = (NativeAzureFileSystem.NativeAzureFsOutputStream)wrappedStream;
                dataOutputStream = (SyncableDataOutputStream)fsOutputStream.getOutStream();
            } else if (wrappedStream instanceof SyncableDataOutputStream) {
                dataOutputStream = (SyncableDataOutputStream)wrappedStream;
            } else {
                TestNativeAzureFileSystemBlockCompaction.fail((String)("Unable to determine type of " + wrappedStream + " class of " + wrappedStream.getClass()));
            }
            TestNativeAzureFileSystemBlockCompaction.assertFalse((boolean)(dataOutputStream.getOutStream() instanceof BlockBlobAppendStream), (String)("Data output stream is a BlockBlobAppendStream: " + dataOutputStream));
        }
    }

    @Test
    public void testCompaction() throws Throwable {
        BlockBlobAppendStream blockBlobStream;
        int n2 = 2;
        int n4 = 4;
        int n10 = 10;
        int n12 = 12;
        int n14 = 14;
        int n16 = 16;
        int maxBlockSize = 16;
        int compactionBlockCount = 4;
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        try (FSDataOutputStream appendStream = this.fs.create(TEST_PATH);){
            blockBlobStream = this.getBlockBlobAppendStream(appendStream);
            blockBlobStream.setMaxBlockSize(16);
            blockBlobStream.setCompactionBlockCount(4);
            this.appendBlockList(appendStream, memStream, new int[]{2});
            this.verifyBlockList(blockBlobStream, new int[]{2});
            appendStream.hflush();
            this.verifyBlockList(blockBlobStream, new int[]{2});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{2, 4});
            appendStream.hsync();
            this.verifyBlockList(blockBlobStream, new int[]{2, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{2, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{2, 4, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 4, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{2, 4, 4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 10});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 10, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4, 4, 4, 4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16});
            this.appendBlockList(appendStream, memStream, new int[]{4, 4, 4, 4, 4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16, 16, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16, 16, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16, 16, 4, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16, 16, 4, 4, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            appendStream.close();
            ContractTestUtils.verifyFileContents((FileSystem)this.fs, (Path)TEST_PATH, (byte[])memStream.toByteArray());
        }
        appendStream = this.fs.append(TEST_PATH);
        try {
            blockBlobStream = this.getBlockBlobAppendStream(appendStream);
            blockBlobStream.setMaxBlockSize(16);
            blockBlobStream.setCompactionBlockCount(4);
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16, 16, 16, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16, 16, 16, 4, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16, 16, 16, 4, 4, 4, 4});
            this.appendBlockList(appendStream, memStream, new int[]{4});
            this.verifyBlockList(blockBlobStream, new int[]{14, 12, 14, 16, 16, 16, 16, 4});
            appendStream.close();
            ContractTestUtils.verifyFileContents((FileSystem)this.fs, (Path)TEST_PATH, (byte[])memStream.toByteArray());
        }
        finally {
            if (appendStream != null) {
                appendStream.close();
            }
        }
    }
}

