/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.CachedAuthorizerEntry;
import org.apache.hadoop.fs.azure.CachingAuthorizer;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.WasbAuthorizationException;
import org.apache.hadoop.fs.azure.WasbAuthorizerInterface;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class MockWasbAuthorizerImpl
implements WasbAuthorizerInterface {
    private Map<AuthorizationComponent, Boolean> authRules;
    private CachingAuthorizer<CachedAuthorizerEntry, Boolean> cache;
    private String qualifiedPrefixUrl;

    public MockWasbAuthorizerImpl(NativeAzureFileSystem fs) {
        this.qualifiedPrefixUrl = new Path("/").makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString().replaceAll("/$", "");
        this.cache = new CachingAuthorizer(TimeUnit.MINUTES.convert(5L, TimeUnit.MINUTES), "AUTHORIZATION");
    }

    public void init(Configuration conf) {
        this.cache.init(conf);
        this.authRules = new HashMap<AuthorizationComponent, Boolean>();
    }

    public void addAuthRuleForOwner(String wasbAbsolutePath, String accessType, boolean access) {
        this.addAuthRule(wasbAbsolutePath, accessType, "owner", access);
    }

    public void addAuthRule(String wasbAbsolutePath, String accessType, String user, boolean access) {
        AuthorizationComponent component = ((String)(wasbAbsolutePath = this.qualifiedPrefixUrl + (String)wasbAbsolutePath)).endsWith("*") ? new AuthorizationComponent("^" + ((String)wasbAbsolutePath).replace("*", ".*"), accessType, user) : new AuthorizationComponent((String)wasbAbsolutePath, accessType, user);
        this.authRules.put(component, access);
    }

    public boolean authorize(String wasbAbsolutePath, String accessType, String owner) throws WasbAuthorizationException {
        if (wasbAbsolutePath.endsWith("-RenamePending.json")) {
            return true;
        }
        CachedAuthorizerEntry cacheKey = new CachedAuthorizerEntry(wasbAbsolutePath, accessType, owner);
        Boolean cacheresult = (Boolean)this.cache.get((Object)cacheKey);
        if (cacheresult != null) {
            return cacheresult;
        }
        boolean authorizeresult = this.authorizeInternal(wasbAbsolutePath, accessType, owner);
        this.cache.put((Object)cacheKey, (Object)authorizeresult);
        return authorizeresult;
    }

    private boolean authorizeInternal(String wasbAbsolutePath, String accessType, String owner) throws WasbAuthorizationException {
        String currentUserShortName = "";
        try {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            currentUserShortName = ugi.getShortUserName();
        }
        catch (Exception ugi) {
            // empty catch block
        }
        if (StringUtils.equalsIgnoreCase((String)wasbAbsolutePath, (String)(this.qualifiedPrefixUrl + "/"))) {
            owner = currentUserShortName;
        }
        AuthorizationComponent component = new AuthorizationComponent(wasbAbsolutePath, accessType, currentUserShortName);
        return this.processRules(this.authRules, component, owner);
    }

    private boolean processRules(Map<AuthorizationComponent, Boolean> authRules, AuthorizationComponent component, String owner) {
        if (authRules.containsKey(component)) {
            return authRules.get(component);
        }
        for (Map.Entry<AuthorizationComponent, Boolean> entry : authRules.entrySet()) {
            boolean foundMatchingPatternOwnerRule;
            AuthorizationComponent key = entry.getKey();
            String keyPath = key.getWasbAbsolutePath();
            String keyAccess = key.getAccessType();
            String keyUser = key.getUser();
            boolean foundMatchingOwnerRule = keyPath.equals(component.getWasbAbsolutePath()) && keyAccess.equals(component.getAccessType()) && keyUser.equalsIgnoreCase("owner") && owner.equals(component.getUser());
            boolean foundMatchingPatternRule = keyPath.endsWith("*") && Pattern.matches(keyPath, component.getWasbAbsolutePath()) && keyAccess.equals(component.getAccessType()) && keyUser.equalsIgnoreCase(component.getUser());
            boolean bl = foundMatchingPatternOwnerRule = keyPath.endsWith("*") && Pattern.matches(keyPath, component.getWasbAbsolutePath()) && keyAccess.equals(component.getAccessType()) && keyUser.equalsIgnoreCase("owner") && owner.equals(component.getUser());
            if (!foundMatchingOwnerRule && !foundMatchingPatternRule && !foundMatchingPatternOwnerRule) continue;
            return entry.getValue();
        }
        return false;
    }

    public void deleteAllAuthRules() {
        this.authRules.clear();
        this.cache.clear();
    }

    private static class AuthorizationComponent {
        private final String wasbAbsolutePath;
        private final String accessType;
        private final String user;

        AuthorizationComponent(String wasbAbsolutePath, String accessType, String user) {
            this.wasbAbsolutePath = wasbAbsolutePath;
            this.accessType = accessType;
            this.user = user;
        }

        public int hashCode() {
            return this.wasbAbsolutePath.hashCode() ^ this.accessType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AuthorizationComponent)) {
                return false;
            }
            return ((AuthorizationComponent)obj).getWasbAbsolutePath().equals(this.wasbAbsolutePath) && ((AuthorizationComponent)obj).getAccessType().equals(this.accessType) && ((AuthorizationComponent)obj).getUser().equals(this.user);
        }

        public String getWasbAbsolutePath() {
            return this.wasbAbsolutePath;
        }

        public String getAccessType() {
            return this.accessType;
        }

        public String getUser() {
            return this.user;
        }
    }
}

