/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class InMemoryBlockBlobStore {
    private final HashMap<String, Entry> blobs = new HashMap();
    private HashMap<String, String> containerMetadata;

    public synchronized Iterable<String> getKeys() {
        return new ArrayList<String>(this.blobs.keySet());
    }

    public synchronized Iterable<ListBlobEntry> listBlobs(String prefix, boolean includeMetadata) {
        ArrayList<ListBlobEntry> list = new ArrayList<ListBlobEntry>();
        for (Map.Entry<String, Entry> entry : this.blobs.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            list.add(new ListBlobEntry(entry.getKey(), includeMetadata ? new HashMap<String, String>(entry.getValue().metadata) : null, entry.getValue().content.length, entry.getValue().isPageBlob));
        }
        return list;
    }

    public synchronized byte[] getContent(String key) {
        return this.blobs.get((Object)key).content;
    }

    public synchronized void setContent(String key, byte[] value, HashMap<String, String> metadata, boolean isPageBlob, long length) {
        this.blobs.put(key, new Entry(value, (HashMap)metadata.clone(), isPageBlob, length));
    }

    public synchronized void setMetadata(String key, HashMap<String, String> metadata) {
        this.blobs.get((Object)key).metadata = (HashMap)metadata.clone();
    }

    public OutputStream uploadBlockBlob(final String key, final HashMap<String, String> metadata) {
        this.setContent(key, new byte[0], metadata, false, 0L);
        return new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                super.flush();
                byte[] tempBytes = this.toByteArray();
                InMemoryBlockBlobStore.this.setContent(key, tempBytes, metadata, false, tempBytes.length);
            }

            @Override
            public void close() throws IOException {
                super.close();
                byte[] tempBytes = this.toByteArray();
                InMemoryBlockBlobStore.this.setContent(key, tempBytes, metadata, false, tempBytes.length);
            }
        };
    }

    public OutputStream uploadPageBlob(final String key, final HashMap<String, String> metadata, final long length) {
        this.setContent(key, new byte[0], metadata, true, length);
        return new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                super.flush();
                InMemoryBlockBlobStore.this.setContent(key, this.toByteArray(), metadata, true, length);
            }
        };
    }

    public synchronized void copy(String sourceKey, String destKey) {
        this.blobs.put(destKey, this.blobs.get(sourceKey));
    }

    public synchronized void delete(String key) {
        this.blobs.remove(key);
    }

    public synchronized boolean exists(String key) {
        return this.blobs.containsKey(key);
    }

    public synchronized HashMap<String, String> getMetadata(String key) {
        Entry entry = Objects.requireNonNull(this.blobs.get(key), "entry for " + key);
        return (HashMap)Objects.requireNonNull(entry.metadata, "metadata for " + key).clone();
    }

    public synchronized HashMap<String, String> getContainerMetadata() {
        return this.containerMetadata;
    }

    public synchronized void setContainerMetadata(HashMap<String, String> metadata) {
        this.containerMetadata = metadata;
    }

    public static class ListBlobEntry {
        private final String key;
        private final HashMap<String, String> metadata;
        private final int contentLength;
        private final boolean isPageBlob;

        ListBlobEntry(String key, HashMap<String, String> metadata, int contentLength, boolean isPageBlob) {
            this.key = key;
            this.metadata = metadata;
            this.contentLength = contentLength;
            this.isPageBlob = isPageBlob;
        }

        public String getKey() {
            return this.key;
        }

        public HashMap<String, String> getMetadata() {
            return this.metadata;
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public boolean isPageBlob() {
            return this.isPageBlob;
        }
    }

    private static class Entry {
        private byte[] content;
        private HashMap<String, String> metadata;
        private boolean isPageBlob;
        private long length;

        public Entry(byte[] content, HashMap<String, String> metadata, boolean isPageBlob, long length) {
            this.content = content;
            this.metadata = metadata;
            this.isPageBlob = isPageBlob;
            this.length = length;
        }
    }
}

