/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestWithTimeout;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.KeyProvider;
import org.apache.hadoop.fs.azure.KeyProviderException;
import org.apache.hadoop.fs.azure.MockStorageInterface;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.SimpleKeyProvider;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.apache.hadoop.fs.azure.Wasb;
import org.apache.hadoop.fs.azure.Wasbs;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ITestWasbUriAndConfiguration
extends AbstractWasbTestWithTimeout {
    private static final int FILE_SIZE = 4096;
    private static final String PATH_DELIMITER = "/";
    protected String accountName;
    protected String accountKey;
    protected static Configuration conf = null;
    private boolean runningInSASMode = false;
    private AzureBlobStorageTestAccount testAccount;

    @AfterEach
    public void tearDown() throws Exception {
        this.testAccount = AzureTestUtils.cleanupTestAccount(this.testAccount);
    }

    @BeforeEach
    public void setMode() {
        this.runningInSASMode = AzureBlobStorageTestAccount.createTestConfiguration().getBoolean("fs.azure.secure.mode", false);
    }

    private boolean validateIOStreams(Path filePath) throws IOException {
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        return this.validateIOStreams((FileSystem)fs, filePath);
    }

    private boolean validateIOStreams(FileSystem fs, Path filePath) throws IOException {
        FSDataOutputStream outputStream = fs.create(filePath);
        outputStream.write(new byte[4096]);
        outputStream.close();
        return 4096 == this.readInputStream(fs, filePath);
    }

    private int readInputStream(Path filePath) throws IOException {
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        return this.readInputStream((FileSystem)fs, filePath);
    }

    private int readInputStream(FileSystem fs, Path filePath) throws IOException {
        FSDataInputStream inputStream = fs.open(filePath);
        int count = 0;
        while (inputStream.read() >= 0) {
            ++count;
        }
        inputStream.close();
        return count;
    }

    @Test
    public void testConnectUsingKey() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create();
        ITestWasbUriAndConfiguration.assumeNotNull(this.testAccount);
        ITestWasbUriAndConfiguration.assertTrue((boolean)this.validateIOStreams(new Path("/wasb_scheme")));
    }

    @Test
    public void testConnectUsingSAS() throws Exception {
        Assumptions.assumeThat((boolean)this.runningInSASMode).isFalse();
        this.testAccount = AzureBlobStorageTestAccount.create("", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.UseSas, AzureBlobStorageTestAccount.CreateOptions.CreateContainer));
        ITestWasbUriAndConfiguration.assumeNotNull(this.testAccount);
        ITestWasbUriAndConfiguration.assertFalse((boolean)this.testAccount.getFileSystem().exists(new Path("/IDontExist")));
    }

    @Test
    public void testConnectUsingSASReadonly() throws Exception {
        Assumptions.assumeThat((boolean)this.runningInSASMode).isFalse();
        this.testAccount = AzureBlobStorageTestAccount.create("", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.UseSas, AzureBlobStorageTestAccount.CreateOptions.CreateContainer, AzureBlobStorageTestAccount.CreateOptions.Readonly));
        ITestWasbUriAndConfiguration.assumeNotNull(this.testAccount);
        String blobKey = "blobForReadonly";
        CloudBlobContainer container = this.testAccount.getRealContainer();
        CloudBlockBlob blob = container.getBlockBlobReference("blobForReadonly");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[]{1, 2, 3});
        blob.upload((InputStream)inputStream, 3L);
        inputStream.close();
        Path filePath = new Path("/blobForReadonly");
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        ITestWasbUriAndConfiguration.assertTrue((boolean)fs.exists(filePath));
        byte[] obtained = new byte[3];
        FSDataInputStream obtainedInputStream = fs.open(filePath);
        obtainedInputStream.readFully(obtained);
        obtainedInputStream.close();
        ITestWasbUriAndConfiguration.assertEquals((int)3, (int)obtained[2]);
    }

    @Test
    public void testConnectUsingSecureSAS() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.azure.secure.mode", true);
        this.testAccount = AzureBlobStorageTestAccount.create("", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.UseSas), conf);
        ITestWasbUriAndConfiguration.assumeNotNull(this.testAccount);
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        AzureException ex = (AzureException)LambdaTestUtils.intercept(AzureException.class, (String)"An error occurred while enumerating the result, check the original exception for details.", () -> ContractTestUtils.writeTextFile((FileSystem)fs, (Path)new Path("/testConnectUsingSecureSAS"), (String)"testConnectUsingSecureSAS", (boolean)true));
        StorageException cause = this.getCause(StorageException.class, this.getCause(NoSuchElementException.class, ex));
        GenericTestUtils.assertExceptionContains((String)"The specified container does not exist", (Throwable)cause);
    }

    private <E extends Throwable> E getCause(Class<E> clazz, Throwable t) {
        Throwable e = t.getCause();
        if (e == null) {
            throw new AssertionError("No cause", t);
        }
        if (!clazz.isAssignableFrom(e.getClass())) {
            throw new AssertionError("Wrong inner class", e);
        }
        return (E)e;
    }

    @Test
    public void testConnectUsingAnonymous() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createAnonymous("testWasb.txt", 4096);
        ITestWasbUriAndConfiguration.assumeNotNull(this.testAccount);
        ITestWasbUriAndConfiguration.assertEquals((int)4096, (int)this.readInputStream(new Path("/testWasb.txt")));
    }

    @Test
    public void testConnectToEmulator() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createForEmulator();
        ITestWasbUriAndConfiguration.assumeNotNull(this.testAccount);
        ITestWasbUriAndConfiguration.assertTrue((boolean)this.validateIOStreams(new Path("/testFile")));
    }

    @Test
    public void testConnectToFullyQualifiedAccountMock() throws Exception {
        Configuration conf = new Configuration();
        AzureBlobStorageTestAccount.setMockAccountKey(conf, "mockAccount.mock.authority.net");
        AzureNativeFileSystemStore store = new AzureNativeFileSystemStore();
        MockStorageInterface mockStorage = new MockStorageInterface();
        store.setAzureStorageInteractionLayer((StorageInterface)mockStorage);
        NativeAzureFileSystem fs = new NativeAzureFileSystem((NativeFileSystemStore)store);
        fs.initialize(new URI("wasb://mockContainer@mockAccount.mock.authority.net"), conf);
        fs.createNewFile(new Path("/x"));
        ITestWasbUriAndConfiguration.assertTrue((boolean)mockStorage.getBackingStore().exists("http://mockAccount.mock.authority.net/mockContainer/x"));
        fs.close();
    }

    public void testConnectToRoot() throws Exception {
        String blobPrefix = String.format("wasbtests-%s-%tQ-blob", System.getProperty("user.name"), new Date());
        String inblobName = blobPrefix + "_In.txt";
        String outblobName = blobPrefix + "_Out.txt";
        this.testAccount = AzureBlobStorageTestAccount.createRoot(inblobName, 4096);
        ITestWasbUriAndConfiguration.assumeNotNull(this.testAccount);
        ITestWasbUriAndConfiguration.assertEquals((int)4096, (int)this.readInputStream(new Path(PATH_DELIMITER + inblobName)));
        try {
            NativeAzureFileSystem fs = this.testAccount.getFileSystem();
            Path outputPath = new Path(PATH_DELIMITER + outblobName);
            FSDataOutputStream outputStream = fs.create(outputPath);
            ITestWasbUriAndConfiguration.fail((String)"Expected an AzureException when writing to root folder.");
            outputStream.write(new byte[4096]);
            outputStream.close();
        }
        catch (AzureException e) {
            ITestWasbUriAndConfiguration.assertTrue((boolean)true);
        }
        catch (Exception e) {
            String errMsg = String.format("Expected AzureException but got %s instead.", e);
            ITestWasbUriAndConfiguration.assertTrue((boolean)false, (String)errMsg);
        }
    }

    public void testConnectWithThrottling() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createThrottled();
        ITestWasbUriAndConfiguration.assertTrue((boolean)this.validateIOStreams(new Path("/wasb_scheme")));
    }

    private static void writeSingleByte(FileSystem fs, Path testFile, int toWrite) throws Exception {
        FSDataOutputStream outputStream = fs.create(testFile);
        outputStream.write(toWrite);
        outputStream.close();
    }

    private static void assertSingleByteValue(FileSystem fs, Path testFile, int expectedValue) throws Exception {
        FSDataInputStream inputStream = fs.open(testFile);
        int byteRead = inputStream.read();
        ITestWasbUriAndConfiguration.assertTrue((byteRead >= 0 ? 1 : 0) != 0, (String)("File unexpectedly empty: " + testFile));
        ITestWasbUriAndConfiguration.assertTrue((inputStream.read() < 0 ? 1 : 0) != 0, (String)("File has more than a single byte: " + testFile));
        inputStream.close();
        ITestWasbUriAndConfiguration.assertEquals((int)expectedValue, (int)byteRead, (String)("Unxpected content in: " + testFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleContainers() throws Exception {
        AzureBlobStorageTestAccount firstAccount = AzureBlobStorageTestAccount.create("first");
        AzureBlobStorageTestAccount secondAccount = AzureBlobStorageTestAccount.create("second");
        ITestWasbUriAndConfiguration.assumeNotNull(firstAccount);
        ITestWasbUriAndConfiguration.assumeNotNull(secondAccount);
        try {
            NativeAzureFileSystem firstFs = firstAccount.getFileSystem();
            NativeAzureFileSystem secondFs = secondAccount.getFileSystem();
            Path testFile = new Path("/testWasb");
            ITestWasbUriAndConfiguration.assertTrue((boolean)this.validateIOStreams((FileSystem)firstFs, testFile));
            ITestWasbUriAndConfiguration.assertTrue((boolean)this.validateIOStreams((FileSystem)secondFs, testFile));
            ITestWasbUriAndConfiguration.writeSingleByte((FileSystem)firstFs, testFile, 5);
            ITestWasbUriAndConfiguration.writeSingleByte((FileSystem)secondFs, testFile, 7);
            ITestWasbUriAndConfiguration.assertSingleByteValue((FileSystem)firstFs, testFile, 5);
            ITestWasbUriAndConfiguration.assertSingleByteValue((FileSystem)secondFs, testFile, 7);
        }
        finally {
            firstAccount.cleanup();
            secondAccount.cleanup();
        }
    }

    @Test
    public void testDefaultKeyProvider() throws Exception {
        Configuration conf = new Configuration();
        String account = "testacct";
        String key = "testkey";
        conf.set("fs.azure.account.key." + account, key);
        String result = AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
        ITestWasbUriAndConfiguration.assertEquals((Object)key, (Object)result);
    }

    @Test
    public void testCredsFromCredentialProvider(@TempDir java.nio.file.Path tempDir) throws Exception {
        Assumptions.assumeThat((boolean)this.runningInSASMode).isFalse();
        String account = "testacct";
        String key = "testkey";
        Configuration conf = new Configuration();
        File file = new File(tempDir.toFile(), "myfile.txt");
        URI jks = ProviderUtils.nestURIForLocalJavaKeyStoreProvider((URI)file.toURI());
        conf.set("hadoop.security.credential.provider.path", jks.toString());
        this.provisionAccountKey(conf, account, key);
        conf.set("fs.azure.account.key." + account, key + "cleartext");
        String result = AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
        ITestWasbUriAndConfiguration.assertEquals((Object)key, (Object)result, (String)"AccountKey incorrect.");
    }

    void provisionAccountKey(Configuration conf, String account, String key) throws Exception {
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        provider.createCredentialEntry("fs.azure.account.key." + account, key.toCharArray());
        provider.flush();
    }

    @Test
    public void testValidKeyProvider() throws Exception {
        Configuration conf = new Configuration();
        String account = "testacct";
        String key = "testkey";
        conf.set("fs.azure.account.key." + account, key);
        conf.setClass("fs.azure.account.keyprovider." + account, SimpleKeyProvider.class, KeyProvider.class);
        String result = AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
        ITestWasbUriAndConfiguration.assertEquals((Object)key, (Object)result);
    }

    @Test
    public void testInvalidKeyProviderNonexistantClass() throws Exception {
        Configuration conf = new Configuration();
        String account = "testacct";
        conf.set("fs.azure.account.keyprovider." + account, "org.apache.Nonexistant.Class");
        try {
            AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
            ITestWasbUriAndConfiguration.fail((String)"Nonexistant key provider class should have thrown a KeyProviderException");
        }
        catch (KeyProviderException keyProviderException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidKeyProviderWrongClass() throws Exception {
        Configuration conf = new Configuration();
        String account = "testacct";
        conf.set("fs.azure.account.keyprovider." + account, "java.lang.String");
        try {
            AzureNativeFileSystemStore.getAccountKeyFromConfiguration((String)account, (Configuration)conf);
            ITestWasbUriAndConfiguration.fail((String)"Key provider class that doesn't implement KeyProvider should have thrown a KeyProviderException");
        }
        catch (KeyProviderException keyProviderException) {
            // empty catch block
        }
    }

    @Test
    public void testNoUriAuthority() throws Exception {
        String[] wasbAliases;
        for (String defaultScheme : wasbAliases = new String[]{"wasb", "wasbs"}) {
            for (String wantedScheme : wasbAliases) {
                this.testAccount = AzureBlobStorageTestAccount.createMock();
                Configuration conf = this.testAccount.getFileSystem().getConf();
                String authority = this.testAccount.getFileSystem().getUri().getAuthority();
                URI defaultUri = new URI(defaultScheme, authority, null, null, null);
                conf.set("fs.defaultFS", defaultUri.toString());
                conf.addResource("azure-test.xml");
                URI wantedUri = new URI(wantedScheme + ":///random/path");
                NativeAzureFileSystem obtained = (NativeAzureFileSystem)FileSystem.get((URI)wantedUri, (Configuration)conf);
                ITestWasbUriAndConfiguration.assertNotNull((Object)obtained);
                ITestWasbUriAndConfiguration.assertEquals((Object)new URI(wantedScheme, authority, null, null, null), (Object)obtained.getUri());
                Path qualified = obtained.makeQualified(new Path(wantedUri));
                ITestWasbUriAndConfiguration.assertEquals((Object)new URI(wantedScheme, authority, wantedUri.getPath(), null, null), (Object)qualified.toUri());
                this.testAccount.cleanup();
                FileSystem.closeAll();
            }
        }
        this.testAccount = AzureBlobStorageTestAccount.createMock();
        Configuration conf = this.testAccount.getFileSystem().getConf();
        conf.set("fs.defaultFS", "file:///");
        try {
            FileSystem.get((URI)new URI("wasb:///random/path"), (Configuration)conf);
            ITestWasbUriAndConfiguration.fail((String)"Should've thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWasbAsDefaultFileSystemHasNoPort() throws Exception {
        try {
            this.testAccount = AzureBlobStorageTestAccount.createMock();
            Configuration conf = this.testAccount.getFileSystem().getConf();
            String authority = this.testAccount.getFileSystem().getUri().getAuthority();
            URI defaultUri = new URI("wasb", authority, null, null, null);
            conf.set("fs.defaultFS", defaultUri.toString());
            conf.addResource("azure-test.xml");
            FileSystem fs = FileSystem.get((Configuration)conf);
            ITestWasbUriAndConfiguration.assertTrue((boolean)(fs instanceof NativeAzureFileSystem));
            ITestWasbUriAndConfiguration.assertEquals((int)-1, (int)fs.getUri().getPort());
            AbstractFileSystem afs = FileContext.getFileContext((Configuration)conf).getDefaultFileSystem();
            ITestWasbUriAndConfiguration.assertTrue((boolean)(afs instanceof Wasb));
            ITestWasbUriAndConfiguration.assertEquals((int)-1, (int)afs.getUri().getPort());
        }
        finally {
            this.testAccount.cleanup();
            FileSystem.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbstractFileSystemImplementationForWasbsScheme() throws Exception {
        try {
            this.testAccount = AzureBlobStorageTestAccount.createMock();
            Configuration conf = this.testAccount.getFileSystem().getConf();
            String authority = this.testAccount.getFileSystem().getUri().getAuthority();
            URI defaultUri = new URI("wasbs", authority, null, null, null);
            conf.set("fs.defaultFS", defaultUri.toString());
            conf.set("fs.AbstractFileSystem.wasbs.impl", "org.apache.hadoop.fs.azure.Wasbs");
            conf.addResource("azure-test.xml");
            FileSystem fs = FileSystem.get((Configuration)conf);
            ITestWasbUriAndConfiguration.assertTrue((boolean)(fs instanceof NativeAzureFileSystem));
            ITestWasbUriAndConfiguration.assertEquals((Object)"wasbs", (Object)fs.getScheme());
            AbstractFileSystem afs = FileContext.getFileContext((Configuration)conf).getDefaultFileSystem();
            ITestWasbUriAndConfiguration.assertTrue((boolean)(afs instanceof Wasbs));
            ITestWasbUriAndConfiguration.assertEquals((int)-1, (int)afs.getUri().getPort());
            ITestWasbUriAndConfiguration.assertEquals((Object)"wasbs", (Object)afs.getUri().getScheme());
        }
        finally {
            this.testAccount.cleanup();
            FileSystem.closeAll();
        }
    }

    @Test
    public void testCredentialProviderPathExclusions() throws Exception {
        String providerPath = "user:///,jceks://wasb/user/hrt_qa/sqoopdbpasswd.jceks,jceks://hdfs@nn1.example.com/my/path/test.jceks";
        Configuration config = new Configuration();
        config.set("hadoop.security.credential.provider.path", providerPath);
        String newPath = "user:///,jceks://hdfs@nn1.example.com/my/path/test.jceks";
        this.excludeAndTestExpectations(config, newPath);
    }

    @Test
    public void testExcludeAllProviderTypesFromConfig() throws Exception {
        String providerPath = "jceks://wasb/tmp/test.jceks,jceks://wasb@/my/path/test.jceks";
        Configuration config = new Configuration();
        config.set("hadoop.security.credential.provider.path", providerPath);
        String newPath = null;
        this.excludeAndTestExpectations(config, newPath);
    }

    void excludeAndTestExpectations(Configuration config, String newPath) throws Exception {
        Configuration conf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)config, NativeAzureFileSystem.class);
        String effectivePath = conf.get("hadoop.security.credential.provider.path", null);
        ITestWasbUriAndConfiguration.assertEquals((Object)newPath, (Object)effectivePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserAgentConfig() throws Exception {
        AbstractFileSystem afs;
        FileSystem fs;
        URI defaultUri;
        String authority;
        Configuration conf;
        try {
            this.testAccount = AzureBlobStorageTestAccount.createMock();
            conf = this.testAccount.getFileSystem().getConf();
            authority = this.testAccount.getFileSystem().getUri().getAuthority();
            defaultUri = new URI("wasbs", authority, null, null, null);
            conf.set("fs.defaultFS", defaultUri.toString());
            conf.set("fs.AbstractFileSystem.wasbs.impl", "org.apache.hadoop.fs.azure.Wasbs");
            conf.set("fs.azure.user.agent.prefix", "TestClient");
            fs = FileSystem.get((Configuration)conf);
            afs = FileContext.getFileContext((Configuration)conf).getDefaultFileSystem();
            ITestWasbUriAndConfiguration.assertTrue((boolean)(afs instanceof Wasbs));
            ITestWasbUriAndConfiguration.assertEquals((int)-1, (int)afs.getUri().getPort());
            ITestWasbUriAndConfiguration.assertEquals((Object)"wasbs", (Object)afs.getUri().getScheme());
        }
        finally {
            this.testAccount.cleanup();
            FileSystem.closeAll();
        }
        try {
            this.testAccount = AzureBlobStorageTestAccount.createMock();
            conf = this.testAccount.getFileSystem().getConf();
            authority = this.testAccount.getFileSystem().getUri().getAuthority();
            defaultUri = new URI("wasbs", authority, null, null, null);
            conf.set("fs.defaultFS", defaultUri.toString());
            conf.set("fs.AbstractFileSystem.wasbs.impl", "org.apache.hadoop.fs.azure.Wasbs");
            conf.unset("fs.azure.user.agent.prefix");
            fs = FileSystem.get((Configuration)conf);
            afs = FileContext.getFileContext((Configuration)conf).getDefaultFileSystem();
            ITestWasbUriAndConfiguration.assertTrue((boolean)(afs instanceof Wasbs));
            ITestWasbUriAndConfiguration.assertEquals((int)-1, (int)afs.getUri().getPort());
            ITestWasbUriAndConfiguration.assertEquals((Object)"wasbs", (Object)afs.getUri().getScheme());
        }
        finally {
            this.testAccount.cleanup();
            FileSystem.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCanonicalServiceName() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.createMock();
        Configuration conf = testAccount.getFileSystem().getConf();
        String authority = testAccount.getFileSystem().getUri().getAuthority();
        URI defaultUri = new URI("wasbs", authority, null, null, null);
        conf.set("fs.defaultFS", defaultUri.toString());
        try {
            FileSystem fs0 = FileSystem.get((Configuration)conf);
            LambdaTestUtils.intercept(IllegalArgumentException.class, (String)"java.net.UnknownHostException", () -> fs0.getCanonicalServiceName());
            conf.setBoolean("fs.azure.override.canonical.service.name", true);
            FileSystem fs1 = FileSystem.newInstance((URI)defaultUri, (Configuration)conf);
            ITestWasbUriAndConfiguration.assertEquals((Object)fs1.getUri().toString(), (Object)fs1.getCanonicalServiceName(), (String)"getCanonicalServiceName() should return URI");
        }
        finally {
            testAccount.cleanup();
            FileSystem.closeAll();
        }
    }
}

