/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.RemoteWasbAuthorizerImpl;
import org.apache.hadoop.fs.azure.WasbAuthorizationException;
import org.apache.hadoop.fs.azure.WasbAuthorizerInterface;
import org.apache.hadoop.fs.azure.WasbRemoteCallHelper;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestWasbRemoteCallHelper
extends AbstractWasbTestBase {
    public static final String EMPTY_STRING = "";
    private static final int INVALID_HTTP_STATUS_CODE_999 = 999;

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.authorization", "true");
        conf.set("fs.azure.authorization.remote.service.urls", "http://localhost1/,http://localhost2/,http://localhost:8080");
        return AzureBlobStorageTestAccount.create(conf);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        boolean useSecureMode = this.fs.getConf().getBoolean("fs.azure.secure.mode", false);
        boolean useAuthorization = this.fs.getConf().getBoolean("fs.azure.authorization", false);
        ((AbstractBooleanAssert)Assumptions.assumeThat((useSecureMode && useAuthorization ? 1 : 0) != 0).as("Test valid when both SecureMode and Authorization are enabled .. skipping", new Object[0])).isTrue();
    }

    @Test
    public void testInvalidStatusCode() throws Throwable {
        ITestWasbRemoteCallHelper.assertThrows(WasbAuthorizationException.class, () -> {
            HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
            HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)mockHttpResponse);
            Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)this.newStatusLine(999));
            this.performop(mockHttpClient);
        });
    }

    @Test
    public void testInvalidContentType() throws Throwable {
        ITestWasbRemoteCallHelper.assertThrows(WasbAuthorizationException.class, () -> {
            HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
            HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)mockHttpResponse);
            Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)this.newStatusLine(200));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "text/plain"));
            this.performop(mockHttpClient);
        });
    }

    @Test
    public void testMissingContentLength() throws Throwable {
        ITestWasbRemoteCallHelper.assertThrows(WasbAuthorizationException.class, () -> {
            HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
            HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)mockHttpResponse);
            Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)this.newStatusLine(200));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
            this.performop(mockHttpClient);
        });
    }

    @Test
    public void testContentLengthExceedsMax() throws Throwable {
        ITestWasbRemoteCallHelper.assertThrows(WasbAuthorizationException.class, () -> {
            HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
            HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)mockHttpResponse);
            Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)this.newStatusLine(200));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "2048"));
            this.performop(mockHttpClient);
        });
    }

    @Test
    public void testInvalidContentLengthValue() throws Throwable {
        ITestWasbRemoteCallHelper.assertThrows(WasbAuthorizationException.class, () -> {
            HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
            HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)mockHttpResponse);
            Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)this.newStatusLine(200));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "20abc48"));
            this.performop(mockHttpClient);
        });
    }

    @Test
    public void testValidJSONResponse() throws Throwable {
        HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
        HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        HttpEntity mockHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)mockHttpResponse);
        Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)this.newStatusLine(200));
        Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
        Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
        Mockito.when((Object)mockHttpResponse.getEntity()).thenReturn((Object)mockHttpEntity);
        Mockito.when((Object)mockHttpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8))).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8))).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8)));
        this.performop(mockHttpClient);
    }

    @Test
    public void testMalFormedJSONResponse() throws Throwable {
        String errorMsg = "com.fasterxml.jackson.core.JsonParseException: Unexpected end-of-input in FIELD_NAME";
        ITestWasbRemoteCallHelper.assertThrows(WasbAuthorizationException.class, () -> {
            HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
            HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            HttpEntity mockHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
            Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)mockHttpResponse);
            Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)this.newStatusLine(200));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
            Mockito.when((Object)mockHttpResponse.getEntity()).thenReturn((Object)mockHttpEntity);
            Mockito.when((Object)mockHttpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(this.malformedJsonResponse().getBytes(StandardCharsets.UTF_8)));
            this.performop(mockHttpClient);
        }, (String)errorMsg);
    }

    @Test
    public void testFailureCodeJSONResponse() throws Throwable {
        String errorMsg = "Remote authorization service encountered an error Unauthorized";
        ITestWasbRemoteCallHelper.assertThrows(WasbAuthorizationException.class, () -> {
            HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
            HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            HttpEntity mockHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
            Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)mockHttpResponse);
            Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)this.newStatusLine(200));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
            Mockito.when((Object)mockHttpResponse.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
            Mockito.when((Object)mockHttpResponse.getEntity()).thenReturn((Object)mockHttpEntity);
            Mockito.when((Object)mockHttpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(this.failureCodeJsonResponse().getBytes(StandardCharsets.UTF_8)));
            this.performop(mockHttpClient);
        }, (String)errorMsg);
    }

    @Test
    public void testWhenOneInstanceIsDown() throws Throwable {
        boolean isAuthorizationCachingEnabled = this.fs.getConf().getBoolean("fs.azure.authorization.caching.enable", false);
        HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
        HttpEntity mockHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        HttpResponse mockHttpResponseService1 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockHttpResponseService1.getStatusLine()).thenReturn((Object)this.newStatusLine(500));
        Mockito.when((Object)mockHttpResponseService1.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
        Mockito.when((Object)mockHttpResponseService1.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
        Mockito.when((Object)mockHttpResponseService1.getEntity()).thenReturn((Object)mockHttpEntity);
        HttpResponse mockHttpResponseService2 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockHttpResponseService2.getStatusLine()).thenReturn((Object)this.newStatusLine(200));
        Mockito.when((Object)mockHttpResponseService2.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
        Mockito.when((Object)mockHttpResponseService2.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
        Mockito.when((Object)mockHttpResponseService2.getEntity()).thenReturn((Object)mockHttpEntity);
        HttpResponse mockHttpResponseServiceLocal = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockHttpResponseServiceLocal.getStatusLine()).thenReturn((Object)this.newStatusLine(500));
        Mockito.when((Object)mockHttpResponseServiceLocal.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
        Mockito.when((Object)mockHttpResponseServiceLocal.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
        Mockito.when((Object)mockHttpResponseServiceLocal.getEntity()).thenReturn((Object)mockHttpEntity);
        Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForService1()))).thenReturn((Object)mockHttpResponseService1);
        Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForService2()))).thenReturn((Object)mockHttpResponseService2);
        Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForServiceLocal()))).thenReturn((Object)mockHttpResponseServiceLocal);
        Mockito.when((Object)mockHttpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8))).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8))).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8)));
        this.performop(mockHttpClient);
        int expectedNumberOfInvocations = isAuthorizationCachingEnabled ? 2 : 3;
        ((HttpClient)Mockito.verify((Object)mockHttpClient, (VerificationMode)Mockito.times((int)expectedNumberOfInvocations))).execute((HttpUriRequest)Mockito.argThat((ArgumentMatcher)new HttpGetForServiceLocal()));
        ((HttpClient)Mockito.verify((Object)mockHttpClient, (VerificationMode)Mockito.times((int)expectedNumberOfInvocations))).execute((HttpUriRequest)Mockito.argThat((ArgumentMatcher)new HttpGetForService2()));
    }

    @Test
    public void testWhenServiceInstancesAreDown() throws Throwable {
        HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
        HttpEntity mockHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        HttpResponse mockHttpResponseService1 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockHttpResponseService1.getStatusLine()).thenReturn((Object)this.newStatusLine(500));
        Mockito.when((Object)mockHttpResponseService1.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
        Mockito.when((Object)mockHttpResponseService1.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
        Mockito.when((Object)mockHttpResponseService1.getEntity()).thenReturn((Object)mockHttpEntity);
        HttpResponse mockHttpResponseService2 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockHttpResponseService2.getStatusLine()).thenReturn((Object)this.newStatusLine(500));
        Mockito.when((Object)mockHttpResponseService2.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
        Mockito.when((Object)mockHttpResponseService2.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
        Mockito.when((Object)mockHttpResponseService2.getEntity()).thenReturn((Object)mockHttpEntity);
        HttpResponse mockHttpResponseService3 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockHttpResponseService3.getStatusLine()).thenReturn((Object)this.newStatusLine(500));
        Mockito.when((Object)mockHttpResponseService3.getFirstHeader("Content-Type")).thenReturn((Object)this.newHeader("Content-Type", "application/json"));
        Mockito.when((Object)mockHttpResponseService3.getFirstHeader("Content-Length")).thenReturn((Object)this.newHeader("Content-Length", "1024"));
        Mockito.when((Object)mockHttpResponseService3.getEntity()).thenReturn((Object)mockHttpEntity);
        Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForService1()))).thenReturn((Object)mockHttpResponseService1);
        Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForService2()))).thenReturn((Object)mockHttpResponseService2);
        Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForServiceLocal()))).thenReturn((Object)mockHttpResponseService3);
        Mockito.when((Object)mockHttpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8))).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8))).thenReturn((Object)new ByteArrayInputStream(this.validJsonResponse().getBytes(StandardCharsets.UTF_8)));
        try {
            this.performop(mockHttpClient);
        }
        catch (WasbAuthorizationException e) {
            e.printStackTrace();
            ((HttpClient)Mockito.verify((Object)mockHttpClient, (VerificationMode)Mockito.atLeast((int)2))).execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForService1()));
            ((HttpClient)Mockito.verify((Object)mockHttpClient, (VerificationMode)Mockito.atLeast((int)2))).execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForService2()));
            ((HttpClient)Mockito.verify((Object)mockHttpClient, (VerificationMode)Mockito.atLeast((int)3))).execute((HttpUriRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpGetForServiceLocal()));
            ((HttpClient)Mockito.verify((Object)mockHttpClient, (VerificationMode)Mockito.times((int)7))).execute((HttpUriRequest)Mockito.any());
        }
    }

    private void performop(HttpClient mockHttpClient) throws Throwable {
        Path testPath = new Path("/", "test.dat");
        RemoteWasbAuthorizerImpl authorizer = new RemoteWasbAuthorizerImpl();
        authorizer.init(this.fs.getConf());
        WasbRemoteCallHelper mockWasbRemoteCallHelper = new WasbRemoteCallHelper(RetryUtils.getMultipleLinearRandomRetry((Configuration)new Configuration(), (String)EMPTY_STRING, (boolean)true, (String)EMPTY_STRING, (String)"1000,3,10000,2"));
        mockWasbRemoteCallHelper.updateHttpClient(mockHttpClient);
        authorizer.updateWasbRemoteCallHelper(mockWasbRemoteCallHelper);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)authorizer);
        this.fs.create(testPath);
        ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
        this.fs.delete(testPath, false);
    }

    private String validJsonResponse() {
        return "{\"responseCode\": 0,\"authorizationResult\": true,\"responseMessage\": \"Authorized\"}";
    }

    private String malformedJsonResponse() {
        return "{\"responseCode\": 0,\"authorizationResult\": true,\"responseMessage\":";
    }

    private String failureCodeJsonResponse() {
        return "{\"responseCode\": 1,\"authorizationResult\": false,\"responseMessage\": \"Unauthorized\"}";
    }

    private StatusLine newStatusLine(final int statusCode) {
        return new StatusLine(){

            public ProtocolVersion getProtocolVersion() {
                return new ProtocolVersion("HTTP", 1, 1);
            }

            public int getStatusCode() {
                return statusCode;
            }

            public String getReasonPhrase() {
                return "Reason Phrase";
            }
        };
    }

    private Header newHeader(final String name, final String value) {
        return new Header(){

            public String getName() {
                return name;
            }

            public String getValue() {
                return value;
            }

            public HeaderElement[] getElements() throws ParseException {
                return new HeaderElement[0];
            }
        };
    }

    private static boolean checkHttpGetMatchHost(HttpGet g, String h) {
        return g != null && g.getURI().getHost().equals(h);
    }

    private class HttpGetForService1
    implements ArgumentMatcher<HttpGet> {
        private HttpGetForService1() {
        }

        public boolean matches(HttpGet httpGet) {
            return ITestWasbRemoteCallHelper.checkHttpGetMatchHost(httpGet, "localhost1");
        }
    }

    private class HttpGetForService2
    implements ArgumentMatcher<HttpGet> {
        private HttpGetForService2() {
        }

        public boolean matches(HttpGet httpGet) {
            return ITestWasbRemoteCallHelper.checkHttpGetMatchHost(httpGet, "localhost2");
        }
    }

    private class HttpGetForServiceLocal
    implements ArgumentMatcher<HttpGet> {
        private HttpGetForServiceLocal() {
        }

        public boolean matches(HttpGet httpGet) {
            try {
                return ITestWasbRemoteCallHelper.checkHttpGetMatchHost(httpGet, InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (UnknownHostException e) {
                return ITestWasbRemoteCallHelper.checkHttpGetMatchHost(httpGet, "localhost");
            }
        }
    }
}

