/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Test;

public class ITestPageBlobOutputStream
extends AbstractWasbTestBase {
    private static final Path TEST_FILE_PATH = new Path("TestPageBlobOutputStream.txt");

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.page.blob.dir", "/");
        return AzureBlobStorageTestAccount.create("testpagebloboutputstream", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.CreateContainer), conf, true);
    }

    @Test
    public void testHflush() throws Exception {
        Path path = this.fs.makeQualified(TEST_FILE_PATH);
        FSDataOutputStream os = this.fs.create(path);
        os.write(1);
        os.hflush();
        this.fs.delete(path, false);
        os.write(2);
        LambdaTestUtils.intercept(IOException.class, (String)"The specified blob does not exist", () -> os.hflush());
        LambdaTestUtils.intercept(IOException.class, (String)"The specified blob does not exist", () -> os.close());
    }

    @Test
    public void testHsync() throws Exception {
        Path path = this.fs.makeQualified(TEST_FILE_PATH);
        FSDataOutputStream os = this.fs.create(path);
        os.write(1);
        os.hsync();
        this.fs.delete(path, false);
        os.write(2);
        LambdaTestUtils.intercept(IOException.class, (String)"The specified blob does not exist", () -> os.hsync());
        LambdaTestUtils.intercept(IOException.class, (String)"The specified blob does not exist", () -> os.close());
    }
}

