/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.Alphanumeric.class)
@Timeout(value=600L)
public class ITestPageBlobInputStream
extends AbstractWasbTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ITestPageBlobInputStream.class);
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int TEST_FILE_SIZE = 0x600000;
    private static final Path TEST_FILE_PATH = new Path("TestPageBlobInputStream.txt");
    private long testFileLength;
    private FileStatus testFileStatus;
    private Path hugefile;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.createTestAccount();
        this.hugefile = this.fs.makeQualified(TEST_FILE_PATH);
        try {
            this.testFileStatus = this.fs.getFileStatus(TEST_FILE_PATH);
            this.testFileLength = this.testFileStatus.getLen();
        }
        catch (FileNotFoundException e) {
            this.testFileLength = 0L;
        }
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.page.blob.dir", "/");
        return AzureBlobStorageTestAccount.create("testpageblobinputstream", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.CreateContainer), conf, true);
    }

    private void createTestFileAndSetLength() throws IOException {
        if (this.fs.exists(TEST_FILE_PATH)) {
            this.testFileStatus = this.fs.getFileStatus(TEST_FILE_PATH);
            this.testFileLength = this.testFileStatus.getLen();
            LOG.info("Reusing test file: {}", (Object)this.testFileStatus);
            return;
        }
        byte[] buffer = new byte[256];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)i;
        }
        LOG.info("Creating test file {} of size: {}", (Object)TEST_FILE_PATH, (Object)0x600000);
        try (FSDataOutputStream outputStream = this.fs.create(TEST_FILE_PATH);){
            for (int bytesWritten = 0; bytesWritten < 0x600000; bytesWritten += buffer.length) {
                outputStream.write(buffer);
            }
            LOG.info("Closing stream {}", (Object)outputStream);
            outputStream.close();
        }
        this.testFileLength = this.fs.getFileStatus(TEST_FILE_PATH).getLen();
    }

    void assumeHugeFileExists() throws IOException {
        ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"huge file not created", (Path)this.hugefile);
        FileStatus status = this.fs.getFileStatus(this.hugefile);
        ContractTestUtils.assertIsFile((Path)this.hugefile, (FileStatus)status);
        ITestPageBlobInputStream.assertTrue((status.getLen() > 0L ? 1 : 0) != 0, (String)("File " + this.hugefile + " is empty"));
    }

    @Test
    public void test_0100_CreateHugeFile() throws IOException {
        this.createTestFileAndSetLength();
    }

    @Test
    public void test_0200_BasicReadTest() throws Exception {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            byte[] buffer = new byte[0x300000];
            long position = 0x500000L;
            inputStream.seek(position);
            int numBytesRead = inputStream.read(buffer, 0, 1024);
            ITestPageBlobInputStream.assertEquals((int)1024, (int)numBytesRead);
            byte[] expected = new byte[0x300000];
            for (int i = 0; i < 1024; ++i) {
                expected[i] = (byte)(((long)i + position) % 256L);
            }
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected, (byte[])buffer);
            int len = 0x100000;
            int offset = buffer.length - len;
            position = 0x300000L;
            inputStream.seek(position);
            numBytesRead = inputStream.read(buffer, offset, len);
            ITestPageBlobInputStream.assertEquals((int)len, (int)numBytesRead);
            for (int i = offset; i < offset + len; ++i) {
                expected[i] = (byte)(((long)i + position) % 256L);
            }
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected, (byte[])buffer);
        }
    }

    @Test
    public void test_0201_RandomReadTest() throws Exception {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            int bufferSize = 4096;
            byte[] buffer = new byte[4096];
            long position = 0L;
            this.verifyConsistentReads(inputStream, buffer, position);
            inputStream.seek(0L);
            this.verifyConsistentReads(inputStream, buffer, position);
            int seekPosition = 2048;
            inputStream.seek((long)seekPosition);
            position = seekPosition;
            this.verifyConsistentReads(inputStream, buffer, position);
            inputStream.seek(0L);
            position = 0L;
            this.verifyConsistentReads(inputStream, buffer, position);
            seekPosition = 5120;
            inputStream.seek((long)seekPosition);
            position = seekPosition;
            this.verifyConsistentReads(inputStream, buffer, position);
            seekPosition = 10240;
            inputStream.seek((long)seekPosition);
            position = seekPosition;
            this.verifyConsistentReads(inputStream, buffer, position);
            seekPosition = 0x401000;
            inputStream.seek((long)seekPosition);
            position = seekPosition;
            this.verifyConsistentReads(inputStream, buffer, position);
            int i = 0x3FF000;
            while (i < 5000) {
                seekPosition = i++;
                inputStream.seek((long)seekPosition);
                position = seekPosition;
                this.verifyConsistentReads(inputStream, buffer, position);
            }
            inputStream.seek(0L);
            position = 0L;
            buffer = new byte[1];
            for (i = 0; i < 5000; ++i) {
                ITestPageBlobInputStream.assertEquals((long)1L, (long)inputStream.skip(1L));
                this.verifyConsistentReads(inputStream, buffer, ++position);
                ++position;
            }
        }
    }

    private void verifyConsistentReads(FSDataInputStream inputStream, byte[] buffer, long position) throws IOException {
        int size = buffer.length;
        int numBytesRead = inputStream.read(buffer, 0, size);
        ITestPageBlobInputStream.assertEquals((int)size, (int)numBytesRead, (String)"Bytes read from stream");
        byte[] expected = new byte[size];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = (byte)((position + (long)i) % 256L);
        }
        ITestPageBlobInputStream.assertArrayEquals((byte[])expected, (byte[])buffer, (String)"Mismatch");
    }

    @Test
    public void test_0301_MarkSupported() throws IOException {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            ITestPageBlobInputStream.assertTrue((boolean)inputStream.markSupported(), (String)"mark is not supported");
        }
    }

    @Test
    public void test_0303_MarkAndResetV1() throws Exception {
        this.assumeHugeFileExists();
        try (final FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            inputStream.mark(1023);
            byte[] buffer = new byte[1024];
            int bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            inputStream.reset();
            ITestPageBlobInputStream.assertEquals((long)0L, (long)inputStream.getPos(), (String)"rest -> pos 0");
            inputStream.mark(8191);
            buffer = new byte[8192];
            bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            LambdaTestUtils.intercept(IOException.class, (String)"Resetting to invalid mark", (Callable)new Callable<FSDataInputStream>(){

                @Override
                public FSDataInputStream call() throws Exception {
                    inputStream.reset();
                    return inputStream;
                }
            });
        }
    }

    @Test
    public void test_0305_SeekToNewSourceV1() throws IOException {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            ITestPageBlobInputStream.assertFalse((boolean)inputStream.seekToNewSource(0L));
        }
    }

    @Test
    public void test_0307_SkipBounds() throws Exception {
        this.assumeHugeFileExists();
        try (final FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            long skipped = inputStream.skip(-1L);
            ITestPageBlobInputStream.assertEquals((long)0L, (long)skipped);
            skipped = inputStream.skip(0L);
            ITestPageBlobInputStream.assertEquals((long)0L, (long)skipped);
            ITestPageBlobInputStream.assertTrue((this.testFileLength > 0L ? 1 : 0) != 0);
            skipped = inputStream.skip(this.testFileLength);
            ITestPageBlobInputStream.assertEquals((long)this.testFileLength, (long)skipped);
            LambdaTestUtils.intercept(EOFException.class, (Callable)new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return inputStream.skip(1L);
                }
            });
        }
    }

    @Test
    public void test_0309_SeekBounds() throws Exception {
        this.assumeHugeFileExists();
        try (final FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            inputStream.seek(0L);
            ITestPageBlobInputStream.assertEquals((long)0L, (long)inputStream.getPos());
            LambdaTestUtils.intercept(EOFException.class, (String)"Cannot seek to a negative offset", (Callable)new Callable<FSDataInputStream>(){

                @Override
                public FSDataInputStream call() throws Exception {
                    inputStream.seek(-1L);
                    return inputStream;
                }
            });
            ITestPageBlobInputStream.assertTrue((this.testFileLength > 0L ? 1 : 0) != 0, (String)("Test file length only " + this.testFileLength));
            inputStream.seek(this.testFileLength);
            ITestPageBlobInputStream.assertEquals((long)this.testFileLength, (long)inputStream.getPos());
            LambdaTestUtils.intercept(EOFException.class, (String)"Attempted to seek or read past the end of the file", (Callable)new Callable<FSDataInputStream>(){

                @Override
                public FSDataInputStream call() throws Exception {
                    inputStream.seek(ITestPageBlobInputStream.this.testFileLength + 1L);
                    return inputStream;
                }
            });
        }
    }

    @Test
    public void test_0311_SeekAndAvailableAndPosition() throws Exception {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            byte[] expected1 = new byte[]{0, 1, 2};
            byte[] expected2 = new byte[]{3, 4, 5};
            byte[] expected3 = new byte[]{1, 2, 3};
            byte[] expected4 = new byte[]{6, 7, 8};
            byte[] buffer = new byte[3];
            int bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected1, (byte[])buffer);
            ITestPageBlobInputStream.assertEquals((long)buffer.length, (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
            bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected2, (byte[])buffer);
            ITestPageBlobInputStream.assertEquals((long)(2 * buffer.length), (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
            int seekPos = 0;
            inputStream.seek((long)seekPos);
            bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected1, (byte[])buffer);
            ITestPageBlobInputStream.assertEquals((long)(buffer.length + seekPos), (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
            seekPos = 1;
            inputStream.seek((long)seekPos);
            bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected3, (byte[])buffer);
            ITestPageBlobInputStream.assertEquals((long)(buffer.length + seekPos), (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
            seekPos = 6;
            inputStream.seek((long)seekPos);
            bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected4, (byte[])buffer);
            ITestPageBlobInputStream.assertEquals((long)(buffer.length + seekPos), (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
        }
    }

    @Test
    public void test_0313_SkipAndAvailableAndPosition() throws IOException {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.fs.open(TEST_FILE_PATH);){
            byte[] expected1 = new byte[]{0, 1, 2};
            byte[] expected2 = new byte[]{3, 4, 5};
            byte[] expected3 = new byte[]{1, 2, 3};
            byte[] expected4 = new byte[]{6, 7, 8};
            ITestPageBlobInputStream.assertEquals((long)this.testFileLength, (long)inputStream.available());
            ITestPageBlobInputStream.assertEquals((long)0L, (long)inputStream.getPos());
            int n = 3;
            long skipped = inputStream.skip((long)n);
            ITestPageBlobInputStream.assertEquals((long)skipped, (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
            ITestPageBlobInputStream.assertEquals((long)skipped, (long)n);
            byte[] buffer = new byte[3];
            int bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected2, (byte[])buffer);
            ITestPageBlobInputStream.assertEquals((long)((long)buffer.length + skipped), (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
            int seekPos = 1;
            inputStream.seek((long)seekPos);
            bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected3, (byte[])buffer);
            ITestPageBlobInputStream.assertEquals((long)(buffer.length + seekPos), (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
            long currentPosition = inputStream.getPos();
            n = 2;
            skipped = inputStream.skip((long)n);
            ITestPageBlobInputStream.assertEquals((long)(currentPosition + skipped), (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
            ITestPageBlobInputStream.assertEquals((long)skipped, (long)n);
            bytesRead = inputStream.read(buffer);
            ITestPageBlobInputStream.assertEquals((int)buffer.length, (int)bytesRead);
            ITestPageBlobInputStream.assertArrayEquals((byte[])expected4, (byte[])buffer);
            ITestPageBlobInputStream.assertEquals((long)((long)buffer.length + skipped + currentPosition), (long)inputStream.getPos());
            ITestPageBlobInputStream.assertEquals((long)(this.testFileLength - inputStream.getPos()), (long)inputStream.available());
        }
    }

    @Test
    public void test_999_DeleteHugeFiles() throws IOException {
        this.fs.delete(TEST_FILE_PATH, false);
    }
}

