/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestWithTimeout;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.Alphanumeric.class)
public class ITestNativeFileSystemStatistics
extends AbstractWasbTestWithTimeout {
    @Test
    public void test_001_NativeAzureFileSystemMocked() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.createMock();
        ITestNativeFileSystemStatistics.assumeNotNull(testAccount);
        this.testStatisticsWithAccount(testAccount);
    }

    @Test
    public void test_002_NativeAzureFileSystemPageBlobLive() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.page.blob.dir", "/");
        conf.set("fs.azure.atomic.rename.dir", "/");
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create(conf);
        ITestNativeFileSystemStatistics.assumeNotNull(testAccount);
        this.testStatisticsWithAccount(testAccount);
    }

    @Test
    public void test_003_NativeAzureFileSystem() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create();
        ITestNativeFileSystemStatistics.assumeNotNull(testAccount);
        this.testStatisticsWithAccount(testAccount);
    }

    private void testStatisticsWithAccount(AzureBlobStorageTestAccount testAccount) throws Exception {
        ITestNativeFileSystemStatistics.assumeNotNull(testAccount);
        NativeAzureFileSystem fs = testAccount.getFileSystem();
        this.testStatistics(fs);
        AzureTestUtils.cleanupTestAccount(testAccount);
    }

    private void testStatistics(NativeAzureFileSystem fs) throws Exception {
        FileSystem.clearStatistics();
        FileSystem.Statistics stats = FileSystem.getStatistics((String)"wasb", NativeAzureFileSystem.class);
        ITestNativeFileSystemStatistics.assertEquals((long)0L, (long)stats.getBytesRead());
        ITestNativeFileSystemStatistics.assertEquals((long)0L, (long)stats.getBytesWritten());
        Path newFile = new Path("testStats");
        AzureTestUtils.writeStringToFile((FileSystem)fs, newFile, "12345678");
        ITestNativeFileSystemStatistics.assertEquals((long)8L, (long)stats.getBytesWritten());
        ITestNativeFileSystemStatistics.assertEquals((long)0L, (long)stats.getBytesRead());
        String readBack = AzureTestUtils.readStringFromFile((FileSystem)fs, newFile);
        ITestNativeFileSystemStatistics.assertEquals((Object)"12345678", (Object)readBack);
        ITestNativeFileSystemStatistics.assertEquals((long)8L, (long)stats.getBytesRead());
        ITestNativeFileSystemStatistics.assertEquals((long)8L, (long)stats.getBytesWritten());
        ITestNativeFileSystemStatistics.assertTrue((boolean)fs.delete(newFile, true));
        ITestNativeFileSystemStatistics.assertEquals((long)8L, (long)stats.getBytesRead());
        ITestNativeFileSystemStatistics.assertEquals((long)8L, (long)stats.getBytesWritten());
    }
}

