/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.test.TestName;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ITestNativeAzureFileSystemContractPageBlobLive
extends FileSystemContractBaseTest {
    private AzureBlobStorageTestAccount testAccount;
    private Path basePath;
    @RegisterExtension
    private TestName methodName = new TestName();

    private void nameThread() {
        Thread.currentThread().setName("JUnit-" + this.methodName.getMethodName());
    }

    private AzureBlobStorageTestAccount createTestAccount() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.page.blob.dir", "/");
        conf.set("fs.azure.atomic.rename.dir", "/");
        return AzureBlobStorageTestAccount.create(conf);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testAccount = this.createTestAccount();
        Assumptions.assumeThat((Object)this.testAccount).isNotNull();
        this.fs = this.testAccount.getFileSystem();
        this.basePath = AzureTestUtils.pathForTests(this.fs, "filesystemcontractpageblob");
    }

    public void tearDown() throws Exception {
        this.testAccount = AzureTestUtils.cleanup(this.testAccount);
        this.fs = null;
    }

    protected int getGlobalTimeout() {
        return 600000;
    }

    public Path getTestBaseDir() {
        return this.basePath;
    }

    @Disabled
    @Test
    public void testMoveFileUnderParent() throws Throwable {
    }

    @Disabled
    @Test
    public void testRenameFileToSelf() throws Throwable {
    }

    @Disabled
    @Test
    public void testRenameChildDirForbidden() throws Exception {
    }

    @Disabled
    @Test
    public void testMoveDirUnderParent() throws Throwable {
    }

    @Disabled
    @Test
    public void testRenameDirToSelf() throws Throwable {
    }
}

