/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.test.TestName;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ITestNativeAzureFileSystemContractLive
extends FileSystemContractBaseTest {
    private AzureBlobStorageTestAccount testAccount;
    private Path basePath;
    @RegisterExtension
    private TestName methodName = new TestName();

    private void nameThread() {
        Thread.currentThread().setName("JUnit-" + this.methodName.getMethodName());
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.nameThread();
        this.testAccount = AzureBlobStorageTestAccount.create();
        if (this.testAccount != null) {
            this.fs = this.testAccount.getFileSystem();
        }
        Assumptions.assumeThat((Object)this.fs).isNotNull();
        this.basePath = this.fs.makeQualified(AzureTestUtils.createTestPath(new Path("NativeAzureFileSystemContractLive")));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.testAccount = AzureTestUtils.cleanup(this.testAccount);
        this.fs = null;
    }

    public Path getTestBaseDir() {
        return this.basePath;
    }

    protected int getGlobalTimeout() {
        return 600000;
    }

    @Disabled
    @Test
    public void testMoveFileUnderParent() throws Throwable {
    }

    @Disabled
    @Test
    public void testRenameFileToSelf() throws Throwable {
    }

    @Disabled
    @Test
    public void testRenameChildDirForbidden() throws Exception {
    }

    @Disabled
    @Test
    public void testMoveDirUnderParent() throws Throwable {
    }

    @Disabled
    @Test
    public void testRenameDirToSelf() throws Throwable {
    }
}

