/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.test.TestName;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ProxyableObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ITestNativeAzureFileSystemContractEmulator
extends FileSystemContractBaseTest {
    private AzureBlobStorageTestAccount testAccount;
    private Path basePath;
    @RegisterExtension
    private TestName methodName = new TestName();

    private void nameThread() {
        Thread.currentThread().setName("JUnit-" + this.methodName.getMethodName());
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.nameThread();
        this.testAccount = AzureBlobStorageTestAccount.createForEmulator();
        if (this.testAccount != null) {
            this.fs = this.testAccount.getFileSystem();
        }
        ((ProxyableObjectAssert)Assumptions.assumeThat((Object)this.fs).as("FileSystem must not be null for this test", new Object[0])).isNotNull();
        this.basePath = this.fs.makeQualified(AzureTestUtils.createTestPath(new Path("ITestNativeAzureFileSystemContractEmulator")));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.testAccount = AzureTestUtils.cleanup(this.testAccount);
        this.fs = null;
    }
}

