/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriException;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UriUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UriUtils.class);
    private static final String ABFS_URI_REGEX = "[^.]+\\.dfs\\.(preprod\\.){0,1}core\\.windows\\.net";
    private static final Pattern ABFS_URI_PATTERN = Pattern.compile("[^.]+\\.dfs\\.(preprod\\.){0,1}core\\.windows\\.net");
    private static final Set<String> FULL_MASK_PARAM_KEYS = new HashSet<String>(Collections.singleton("sig"));
    private static final Set<String> PARTIAL_MASK_PARAM_KEYS = new HashSet<String>(Arrays.asList("skoid", "saoid", "suoid"));
    private static final Character CHAR_MASK = Character.valueOf('X');
    private static final String FULL_MASK = "XXXXX";
    private static final int DEFAULT_QUERY_STRINGBUILDER_CAPACITY = 550;
    private static final int PARTIAL_MASK_VISIBLE_LEN = 18;

    public static boolean containsAbfsUrl(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return ABFS_URI_PATTERN.matcher(string).matches();
    }

    public static String extractAccountNameFromHostName(String hostName) {
        if (hostName == null || hostName.isEmpty()) {
            return null;
        }
        if (!UriUtils.containsAbfsUrl(hostName)) {
            return null;
        }
        String[] splitByDot = hostName.split("\\.");
        if (splitByDot.length == 0) {
            return null;
        }
        return splitByDot[0];
    }

    public static String generateUniqueTestPath() {
        String testUniqueForkId = System.getProperty("test.unique.fork.id");
        return testUniqueForkId == null ? "/test" : "/" + testUniqueForkId + "/test";
    }

    public static String maskUrlQueryParameters(List<NameValuePair> keyValueList, Set<String> queryParamsForFullMask, Set<String> queryParamsForPartialMask) {
        return UriUtils.maskUrlQueryParameters(keyValueList, queryParamsForFullMask, queryParamsForPartialMask, 550);
    }

    public static String maskUrlQueryParameters(List<NameValuePair> keyValueList, Set<String> queryParamsForFullMask, Set<String> queryParamsForPartialMask, int queryLen) {
        StringBuilder maskedUrl = new StringBuilder(queryLen);
        for (NameValuePair keyValuePair : keyValueList) {
            String key = keyValuePair.getName();
            if (key.isEmpty()) {
                throw new IllegalArgumentException("Query param key should not be empty");
            }
            String value = keyValuePair.getValue();
            maskedUrl.append(key);
            maskedUrl.append("=");
            if (value != null && !value.isEmpty()) {
                if (queryParamsForFullMask.contains(key)) {
                    maskedUrl.append(FULL_MASK);
                } else if (queryParamsForPartialMask.contains(key)) {
                    int valueLen = value.length();
                    int maskedLen = valueLen > 18 ? 18 : valueLen / 2;
                    maskedUrl.append(value, 0, valueLen - maskedLen);
                    maskedUrl.append(StringUtils.repeat((char)CHAR_MASK.charValue(), (int)maskedLen));
                } else {
                    maskedUrl.append(value);
                }
            }
            maskedUrl.append("&");
        }
        maskedUrl.deleteCharAt(maskedUrl.length() - 1);
        return maskedUrl.toString();
    }

    public static String encodedUrlStr(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "https%3A%2F%2Ffailed%2Fto%2Fencode%2Furl";
        }
    }

    public static String getMaskedUrl(URL url) {
        String queryString = url.getQuery();
        if (queryString == null) {
            return url.toString();
        }
        List queryKeyValueList = URLEncodedUtils.parse((String)queryString, (Charset)StandardCharsets.UTF_8);
        String maskedQueryString = UriUtils.maskUrlQueryParameters(queryKeyValueList, FULL_MASK_PARAM_KEYS, PARTIAL_MASK_PARAM_KEYS, queryString.length());
        return url.toString().replace(queryString, maskedQueryString);
    }

    public static URL changeUrlFromBlobToDfs(URL url) throws InvalidUriException {
        try {
            url = new URL(UriUtils.replacedUrl(url.toString(), ".blob.", ".dfs."));
        }
        catch (MalformedURLException ex) {
            throw new InvalidUriException(url.toString());
        }
        return url;
    }

    public static URL changeUrlFromDfsToBlob(URL url) throws InvalidUriException {
        try {
            url = new URL(UriUtils.replacedUrl(url.toString(), ".dfs.", ".blob."));
        }
        catch (MalformedURLException ex) {
            throw new InvalidUriException(url.toString());
        }
        return url;
    }

    private static String replacedUrl(String baseUrl, String oldString, String newString) {
        int startIndex = baseUrl.toString().indexOf("//") + 2;
        int endIndex = baseUrl.toString().indexOf("/", startIndex);
        if (oldString == null || newString == null || startIndex < 0 || endIndex > baseUrl.length() || startIndex > endIndex) {
            throw new IllegalArgumentException("Invalid input or indices");
        }
        StringBuilder sb = new StringBuilder(baseUrl);
        int targetIndex = sb.indexOf(oldString, startIndex);
        if (targetIndex == -1 || targetIndex >= endIndex) {
            return baseUrl;
        }
        sb.replace(targetIndex, targetIndex + oldString.length(), newString);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isKeyForDirectorySet(String key, Set<String> dirSet) {
        for (String string : dirSet) {
            void var3_3;
            if (StringUtils.isNotEmpty((CharSequence)string) && !string.endsWith("/")) {
                String string2 = string + "/";
            }
            if (var3_3.isEmpty() || key.startsWith((String)var3_3)) {
                return true;
            }
            try {
                URI uri = new URI((String)var3_3);
                if (null != uri.getAuthority() || !key.startsWith((String)var3_3 + "/")) continue;
                return true;
            }
            catch (URISyntaxException e) {
                LOG.info("URI syntax error creating URI for {}", (Object)var3_3);
            }
        }
        return false;
    }

    private UriUtils() {
    }
}

