/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.ClosedIOException;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.http.HttpClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeepAliveCache
extends Stack<KeepAliveEntry>
implements Closeable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(KeepAliveCache.class);
    private final transient Timer timer;
    private final transient TimerTask timerTask;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private static final AtomicInteger KAC_COUNTER = new AtomicInteger(0);
    private final int maxConn;
    private final long connectionIdleTTL;
    private final AtomicBoolean isPaused = new AtomicBoolean(false);
    private final String accountNamePath;

    @VisibleForTesting
    synchronized void pauseThread() {
        this.isPaused.set(true);
    }

    @VisibleForTesting
    synchronized void resumeThread() {
        this.isPaused.set(false);
    }

    @VisibleForTesting
    public long getConnectionIdleTTL() {
        return this.connectionIdleTTL;
    }

    KeepAliveCache(AbfsConfiguration abfsConfiguration) {
        this.accountNamePath = abfsConfiguration.getAccountName();
        this.timer = new Timer("abfs-kac-" + KAC_COUNTER.getAndIncrement(), true);
        int sysPropMaxConn = Integer.parseInt(System.getProperty("http.maxConnections", "0"));
        int defaultMaxConn = sysPropMaxConn > 0 ? sysPropMaxConn : 5;
        this.maxConn = abfsConfiguration.getInt("fs.azure.apache.http.client.max.cache.connection.size", defaultMaxConn);
        this.connectionIdleTTL = abfsConfiguration.getMaxApacheHttpClientConnectionIdleTime();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                if (KeepAliveCache.this.isPaused.get() || KeepAliveCache.this.isClosed.get()) {
                    return;
                }
                KeepAliveCache.this.evictIdleConnection();
            }
        };
        this.timer.schedule(this.timerTask, 0L, this.connectionIdleTTL);
    }

    synchronized void evictIdleConnection() {
        int i;
        long currentTime = System.currentTimeMillis();
        for (i = 0; i < this.size(); ++i) {
            KeepAliveEntry e = (KeepAliveEntry)this.elementAt(i);
            if (currentTime - e.idleStartTime <= this.connectionIdleTTL && !e.httpClientConnection.isStale()) break;
            HttpClientConnection hc = e.httpClientConnection;
            this.closeHttpClientConnection(hc);
        }
        this.subList(0, i).clear();
    }

    private void closeHttpClientConnection(HttpClientConnection hc) {
        block2: {
            try {
                hc.close();
            }
            catch (IOException ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Close failed for connection: {}", (Object)hc, (Object)ex);
            }
        }
    }

    @Override
    public synchronized void close() {
        boolean closed = this.isClosed.getAndSet(true);
        if (closed) {
            return;
        }
        this.closeInternal();
    }

    @VisibleForTesting
    void closeInternal() {
        this.timerTask.cancel();
        this.timer.purge();
        while (!this.empty()) {
            KeepAliveEntry e = (KeepAliveEntry)this.pop();
            this.closeHttpClientConnection(e.httpClientConnection);
        }
    }

    public synchronized HttpClientConnection get() throws IOException {
        if (this.isClosed.get()) {
            throw new ClosedIOException(this.accountNamePath, "KeepAliveCache is closed");
        }
        if (this.empty()) {
            return null;
        }
        HttpClientConnection hc = null;
        long currentTime = System.currentTimeMillis();
        do {
            KeepAliveEntry e = (KeepAliveEntry)this.pop();
            if (currentTime - e.idleStartTime > this.connectionIdleTTL || e.httpClientConnection.isStale()) {
                this.closeHttpClientConnection(e.httpClientConnection);
                continue;
            }
            hc = e.httpClientConnection;
        } while (hc == null && !this.empty());
        return hc;
    }

    public synchronized boolean put(HttpClientConnection httpClientConnection) {
        if (this.isClosed.get() || this.maxConn == 0) {
            this.closeHttpClientConnection(httpClientConnection);
            return false;
        }
        if (this.size() == this.maxConn) {
            this.closeHttpClientConnection(((KeepAliveEntry)this.get((int)0)).httpClientConnection);
            this.subList(0, 1).clear();
        }
        KeepAliveEntry entry = new KeepAliveEntry(httpClientConnection, System.currentTimeMillis());
        this.push(entry);
        return true;
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    static class KeepAliveEntry {
        private final HttpClientConnection httpClientConnection;
        private final long idleStartTime;

        KeepAliveEntry(HttpClientConnection hc, long idleStartTime) {
            this.httpClientConnection = hc;
            this.idleStartTime = idleStartTime;
        }
    }
}

