/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlockStatus;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AzureBlockManager;
import org.apache.hadoop.fs.azurebfs.services.BlockEntry;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.store.DataBlocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureBlobBlockManager
extends AzureBlockManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);
    private final StringBuilder committedBlockEntries = new StringBuilder();
    private final LinkedList<BlockEntry> blockEntryList = new LinkedList();

    public AzureBlobBlockManager(AbfsOutputStream abfsOutputStream, DataBlocks.BlockFactory blockFactory, int bufferSize) throws AzureBlobFileSystemException {
        super(abfsOutputStream, blockFactory, bufferSize);
        List<String> committedBlocks;
        if (abfsOutputStream.getPosition() > 0L && !abfsOutputStream.isAppendBlob() && !(committedBlocks = this.getBlockList(abfsOutputStream.getTracingContext())).isEmpty()) {
            this.committedBlockEntries.append(String.join((CharSequence)",", committedBlocks));
        }
        LOG.debug("Created a new Blob Block Manager for AbfsOutputStream instance {} for path {}", (Object)abfsOutputStream.getStreamID(), (Object)abfsOutputStream.getPath());
    }

    @Override
    protected synchronized AbfsBlock createBlockInternal(long position) throws IOException {
        if (this.getActiveBlock() == null) {
            this.setBlockCount(this.getBlockCount() + 1L);
            AbfsBlobBlock activeBlock = new AbfsBlobBlock(this.getAbfsOutputStream(), position);
            activeBlock.setBlockEntry(this.addNewEntry(((AbfsBlock)activeBlock).getBlockId(), activeBlock.getOffset()));
            this.setActiveBlock(activeBlock);
        }
        return this.getActiveBlock();
    }

    private List<String> getBlockList(TracingContext tracingContext) throws AzureBlobFileSystemException {
        List<String> committedBlockIdList = new ArrayList<String>();
        AbfsBlobClient blobClient = this.getAbfsOutputStream().getClientHandler().getBlobClient();
        AbfsRestOperation op = blobClient.getBlockList(this.getAbfsOutputStream().getPath(), tracingContext);
        if (op != null && op.getResult() != null) {
            committedBlockIdList = op.getResult().getBlockIdList();
        }
        return committedBlockIdList;
    }

    private synchronized BlockEntry addNewEntry(String blockId, long position) throws IOException {
        BlockEntry lastEntry;
        if (!this.blockEntryList.isEmpty() && position <= (lastEntry = this.blockEntryList.getLast()).getPosition()) {
            throw new IOException("New block position " + position + " must be greater than the last block position " + lastEntry.getPosition() + " for path " + this.getAbfsOutputStream().getPath());
        }
        BlockEntry blockEntry = new BlockEntry(blockId, position, AbfsBlockStatus.NEW);
        this.blockEntryList.addLast(blockEntry);
        LOG.debug("Added block {} at position {} with status NEW.", (Object)blockId, (Object)position);
        return blockEntry;
    }

    protected synchronized void updateEntry(AbfsBlock block) {
        BlockEntry blockEntry = block.getBlockEntry();
        blockEntry.setStatus(AbfsBlockStatus.SUCCESS);
        LOG.debug("Added block {} at position {} with status SUCCESS.", (Object)block.getBlockId(), (Object)blockEntry.getPosition());
    }

    protected synchronized boolean hasBlocksToCommit() throws IOException {
        if (this.blockEntryList.isEmpty()) {
            return false;
        }
        while (!this.blockEntryList.isEmpty()) {
            BlockEntry current = this.blockEntryList.poll();
            if (current.getStatus() != AbfsBlockStatus.SUCCESS) {
                LOG.debug("Block {} with position {} has status {}, flush cannot proceed.", new Object[]{current.getBlockId(), current.getPosition(), current.getStatus()});
                throw new IOException("Flush failed. Block " + current.getBlockId() + " with position " + current.getPosition() + " has status " + current.getStatus() + "for path " + this.getAbfsOutputStream().getPath());
            }
            if (!this.blockEntryList.isEmpty()) {
                BlockEntry next = this.blockEntryList.getFirst();
                if (current.getPosition() >= next.getPosition()) {
                    String errorMessage = "Position check failed. Current block position is greater than or equal to the next block's position.\nCurrent Block Entry:\nBlock ID: " + current.getBlockId() + ", Position: " + current.getPosition() + ", Status: " + current.getStatus() + ", Path: " + this.getAbfsOutputStream().getPath() + ", StreamID: " + this.getAbfsOutputStream().getStreamID() + ", Next block position: " + next.getPosition() + "\n";
                    throw new IOException(errorMessage);
                }
            }
            if (this.committedBlockEntries.length() > 0) {
                this.committedBlockEntries.append(",");
            }
            this.committedBlockEntries.append(current.getBlockId());
            LOG.debug("Block {} added to committed entries.", (Object)current.getBlockId());
        }
        return true;
    }

    protected String getBlockIdToCommit() {
        return this.committedBlockEntries.toString();
    }

    @Override
    public void close() {
        super.close();
        this.committedBlockEntries.setLength(0);
    }
}

