/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;

public abstract class AbstractAbfsStatisticsSource
implements IOStatisticsSource {
    private IOStatisticsStore ioStatisticsStore;

    protected AbstractAbfsStatisticsSource() {
    }

    public IOStatistics getIOStatistics() {
        return this.ioStatisticsStore;
    }

    protected void setIOStatistics(IOStatisticsStore ioStatisticsStore) {
        this.ioStatisticsStore = ioStatisticsStore;
    }

    protected void incCounterValue(String name) {
        this.incCounterValue(name, 1L);
    }

    protected void incCounterValue(String name, long value) {
        this.ioStatisticsStore.incrementCounter(name, value);
    }

    protected Long lookupCounterValue(String name) {
        return this.ioStatisticsStore.counters().getOrDefault(name, 0L);
    }

    protected void setCounterValue(String name, long value) {
        this.ioStatisticsStore.setCounter(name, value);
    }

    protected void incGaugeValue(String name) {
        this.incCounterValue(name, 1L);
    }

    protected Long lookupGaugeValue(String name) {
        return this.ioStatisticsStore.gauges().getOrDefault(name, 0L);
    }

    protected void setGaugeValue(String name, long value) {
        this.ioStatisticsStore.setGauge(name, value);
    }

    protected void addMeanStatistic(String name, long value) {
        this.ioStatisticsStore.addMeanStatisticSample(name, value);
    }

    protected double lookupMeanStatistic(String name) {
        return ((MeanStatistic)this.ioStatisticsStore.meanStatistics().get(name)).mean();
    }

    public String toString() {
        return "AbstractAbfsStatisticsStore{" + this.ioStatisticsStore + "}";
    }
}

