/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.EtagSource;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.util.Preconditions;

public class AbfsLocatedFileStatus
extends LocatedFileStatus
implements EtagSource {
    private static final long serialVersionUID = -8185960773314341594L;
    private final String etag;

    public AbfsLocatedFileStatus(FileStatus status, BlockLocation[] locations) {
        super((FileStatus)Preconditions.checkNotNull((Object)status), locations);
        this.etag = status instanceof EtagSource ? ((EtagSource)status).getEtag() : null;
    }

    public String getEtag() {
        return this.etag;
    }

    public String toString() {
        return "AbfsLocatedFileStatus{etag='" + this.etag + "'} " + super.toString();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

