/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.contracts.services.AbfsPerfLoggable;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.StorageErrorResponseSchema;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbfsHttpOperation
implements AbfsPerfLoggable {
    private final Logger log;
    private static final int CLEAN_UP_BUFFER_SIZE = 65536;
    public static final int ONE_THOUSAND = 1000;
    private static final int ONE_MILLION = 1000000;
    private final String method;
    private final URL url;
    private String maskedUrl;
    private AbfsClient client;
    private String maskedEncodedUrl;
    private int statusCode;
    private String statusDescription;
    private String storageErrorCode = "";
    private String storageErrorMessage = "";
    private String requestId = "";
    private String expectedAppendPos = "";
    private ListResultSchema listResultSchema = null;
    private InputStream listResultStream = null;
    private List<String> blockIdList = null;
    private int bytesSent;
    private int expectedBytesToBeSent;
    private long bytesReceived;
    private long connectionTimeMs;
    private long sendRequestTimeMs;
    private long recvResponseTimeMs;
    private boolean shouldMask = false;
    private boolean connectionDisconnectedOnError = false;
    private final List<AbfsHttpHeader> requestHeaders;
    private final int connectionTimeout;
    private final int readTimeout;

    public static AbfsHttpOperation getAbfsHttpOperationWithFixedResult(URL url, String method, int httpStatus) {
        AbfsHttpOperationWithFixedResult httpOp = new AbfsHttpOperationWithFixedResult(url, method, httpStatus);
        return httpOp;
    }

    public AbfsHttpOperation(Logger log, URL url, String method, List<AbfsHttpHeader> requestHeaders, Duration connectionTimeout, Duration readTimeout, AbfsClient abfsClient) {
        this.log = log;
        this.url = url;
        this.method = method;
        this.requestHeaders = requestHeaders;
        this.connectionTimeout = (int)connectionTimeout.toMillis();
        this.readTimeout = (int)readTimeout.toMillis();
        this.client = abfsClient;
    }

    protected AbfsHttpOperation(URL url, String method, int httpStatus) {
        this.log = LoggerFactory.getLogger(AbfsHttpOperation.class);
        this.url = url;
        this.method = method;
        this.statusCode = httpStatus;
        this.requestHeaders = new ArrayList<AbfsHttpHeader>();
        this.connectionTimeout = 0;
        this.readTimeout = 0;
    }

    int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    List<AbfsHttpHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHost() {
        return this.url.getHost();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public String getStorageErrorCode() {
        return this.storageErrorCode;
    }

    public String getStorageErrorMessage() {
        return this.storageErrorMessage;
    }

    public String getClientRequestId() {
        return this.getRequestProperty("x-ms-client-request-id");
    }

    public String getExpectedAppendPos() {
        return this.expectedAppendPos;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setMaskForSAS() {
        this.shouldMask = true;
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public int getExpectedBytesToBeSent() {
        return this.expectedBytesToBeSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public URL getUrl() {
        return this.url;
    }

    public ListResultSchema getListResultSchema() {
        return this.listResultSchema;
    }

    public InputStream getListResultStream() {
        return this.listResultStream;
    }

    public abstract String getResponseHeader(String var1);

    public abstract Map<String, List<String>> getResponseHeaders();

    public abstract String getResponseHeaderIgnoreCase(String var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.statusCode);
        sb.append(",");
        sb.append(this.storageErrorCode);
        sb.append(",");
        sb.append(this.expectedAppendPos);
        sb.append(",cid=");
        sb.append(this.getClientRequestId());
        sb.append(",rid=");
        sb.append(this.requestId);
        sb.append(",connMs=");
        sb.append(this.connectionTimeMs);
        sb.append(",sendMs=");
        sb.append(this.sendRequestTimeMs);
        sb.append(",recvMs=");
        sb.append(this.recvResponseTimeMs);
        sb.append(",sent=");
        sb.append(this.bytesSent);
        sb.append(",recv=");
        sb.append(this.bytesReceived);
        sb.append(",");
        sb.append(this.method);
        sb.append(",");
        sb.append(this.getMaskedUrl());
        return sb.toString();
    }

    @Override
    public String getLogString() {
        StringBuilder sb = new StringBuilder();
        sb.append("s=").append(this.statusCode).append(" e=").append(this.storageErrorCode).append(" ci=").append(this.getClientRequestId()).append(" ri=").append(this.requestId).append(" ct=").append(this.connectionTimeMs).append(" st=").append(this.sendRequestTimeMs).append(" rt=").append(this.recvResponseTimeMs).append(" bs=").append(this.bytesSent).append(" br=").append(this.bytesReceived).append(" m=").append(this.method).append(" u=").append(this.getMaskedEncodedUrl());
        return sb.toString();
    }

    @VisibleForTesting
    public String getMaskedUrl() {
        if (!this.shouldMask) {
            return this.url.toString();
        }
        if (this.maskedUrl != null) {
            return this.maskedUrl;
        }
        this.maskedUrl = UriUtils.getMaskedUrl(this.url);
        return this.maskedUrl;
    }

    public final String getMaskedEncodedUrl() {
        if (this.maskedEncodedUrl != null) {
            return this.maskedEncodedUrl;
        }
        this.maskedEncodedUrl = UriUtils.encodedUrlStr(this.getMaskedUrl());
        return this.maskedEncodedUrl;
    }

    public abstract void sendPayload(byte[] var1, int var2, int var3) throws IOException;

    public abstract void processResponse(byte[] var1, int var2, int var3) throws IOException;

    public abstract void setRequestProperty(String var1, String var2);

    final void parseResponse(byte[] buffer, int offset, int length) throws IOException {
        if ("HEAD".equals(this.method)) {
            return;
        }
        long startTime = System.nanoTime();
        if (this.statusCode >= 400) {
            this.processStorageErrorResponse();
            this.recvResponseTimeMs += this.elapsedTimeMs(startTime);
            String contentLength = this.getResponseHeader("Content-Length");
            this.bytesReceived = contentLength != null ? Long.parseLong(contentLength) : 0L;
        } else {
            int totalBytesRead;
            try (InputStream stream = this.getContentInputStream();){
                if (this.isNullInputStream(stream)) {
                    return;
                }
                boolean endOfStream = false;
                if ("GET".equals(this.method) && buffer == null) {
                    if (this.url.toString().contains("comp=blocklist")) {
                        this.parseBlockListResponse(stream);
                    } else {
                        this.parseListPathResponse(stream);
                    }
                } else {
                    int bytesRead;
                    if (buffer != null) {
                        for (totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
                            bytesRead = stream.read(buffer, offset + totalBytesRead, length - totalBytesRead);
                            if (bytesRead != -1) continue;
                            endOfStream = true;
                            break;
                        }
                    }
                    if (!endOfStream && stream.read() != -1) {
                        bytesRead = 0;
                        byte[] b = new byte[65536];
                        while ((bytesRead = stream.read(b)) >= 0) {
                            totalBytesRead += bytesRead;
                        }
                    }
                }
            }
            catch (IOException ex) {
                this.log.warn("IO/Network error: {} {}: {}", new Object[]{this.method, this.getMaskedUrl(), ex.getMessage()});
                this.log.debug("IO Error: ", (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                this.log.warn("Unexpected error: {} {}: {}", new Object[]{this.method, this.getMaskedUrl(), ex.getMessage()});
                this.log.debug("Unexpected Error: ", (Throwable)ex);
                throw new IOException(ex);
            }
            finally {
                this.recvResponseTimeMs += this.elapsedTimeMs(startTime);
                this.bytesReceived = totalBytesRead;
            }
        }
    }

    protected abstract InputStream getContentInputStream() throws IOException;

    private void processStorageErrorResponse() {
        try (InputStream stream = this.getErrorStream();){
            if (stream == null) {
                return;
            }
            StorageErrorResponseSchema storageErrorResponse = this.client.processStorageErrorResponse(stream);
            this.storageErrorCode = storageErrorResponse.getStorageErrorCode();
            this.storageErrorMessage = storageErrorResponse.getStorageErrorMessage();
            this.expectedAppendPos = storageErrorResponse.getExpectedAppendPos();
        }
        catch (IOException ex) {
            this.log.debug("Error parsing storage error response", (Throwable)ex);
        }
    }

    protected abstract InputStream getErrorStream() throws IOException;

    private void parseBlockListResponse(InputStream stream) throws IOException {
        if (stream == null || this.blockIdList != null) {
            return;
        }
        this.blockIdList = this.client.parseBlockListResponse(stream);
    }

    private void parseListPathResponse(InputStream stream) throws IOException {
        if (stream == null || this.listResultStream != null) {
            return;
        }
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] tempBuffer = new byte[65536];
            while ((bytesRead = stream.read(tempBuffer, 0, 65536)) != -1) {
                buffer.write(tempBuffer, 0, bytesRead);
            }
            this.listResultStream = new ByteArrayInputStream(buffer.toByteArray());
        }
    }

    public List<String> getBlockIdList() {
        return this.blockIdList;
    }

    final long elapsedTimeMs(long startTime) {
        return (System.nanoTime() - startTime) / 1000000L;
    }

    private boolean isNullInputStream(InputStream stream) {
        return stream == null;
    }

    abstract String getConnProperty(String var1);

    abstract URL getConnUrl();

    abstract Integer getConnResponseCode() throws IOException;

    abstract String getConnResponseMessage() throws IOException;

    abstract Map<String, List<String>> getRequestProperties();

    abstract String getRequestProperty(String var1);

    boolean getConnectionDisconnectedOnError() {
        return this.connectionDisconnectedOnError;
    }

    public abstract String getTracingContextSuffix();

    public final long getSendLatency() {
        return this.sendRequestTimeMs;
    }

    public final long getRecvLatency() {
        return this.recvResponseTimeMs;
    }

    protected void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    protected void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    protected void setRequestId() {
        this.requestId = this.getResponseHeader("x-ms-request-id");
        if (this.requestId == null) {
            this.requestId = "";
        }
    }

    protected void setBytesSent(int bytesSent) {
        this.bytesSent = bytesSent;
    }

    protected void setExpectedBytesToBeSent(int expectedBytesToBeSent) {
        this.expectedBytesToBeSent = expectedBytesToBeSent;
    }

    protected void setConnectionTimeMs(long connectionTimeMs) {
        this.connectionTimeMs = connectionTimeMs;
    }

    protected void setSendRequestTimeMs(long sendRequestTimeMs) {
        this.sendRequestTimeMs = sendRequestTimeMs;
    }

    protected void setRecvResponseTimeMs(long recvResponseTimeMs) {
        this.recvResponseTimeMs = recvResponseTimeMs;
    }

    protected void setConnectionDisconnectedOnError() {
        this.connectionDisconnectedOnError = true;
    }

    protected boolean isConnectionDisconnectedOnError() {
        return this.connectionDisconnectedOnError;
    }

    protected void setListResultSchema(ListResultSchema listResultSchema) {
        this.listResultSchema = listResultSchema;
    }

    public static class AbfsHttpOperationWithFixedResult
    extends AbfsHttpOperation {
        public AbfsHttpOperationWithFixedResult(URL url, String method, int httpStatus) {
            super(url, method, httpStatus);
        }

        @Override
        public void processResponse(byte[] buffer, int offset, int length) throws IOException {
        }

        @Override
        public void setRequestProperty(String key, String value) {
        }

        @Override
        protected InputStream getContentInputStream() throws IOException {
            return null;
        }

        @Override
        protected InputStream getErrorStream() throws IOException {
            return null;
        }

        @Override
        String getConnProperty(String key) {
            return null;
        }

        @Override
        URL getConnUrl() {
            return null;
        }

        @Override
        Integer getConnResponseCode() throws IOException {
            return null;
        }

        @Override
        String getConnResponseMessage() throws IOException {
            return null;
        }

        @Override
        Map<String, List<String>> getRequestProperties() {
            return null;
        }

        @Override
        String getRequestProperty(String headerName) {
            return null;
        }

        @Override
        public String getTracingContextSuffix() {
            return null;
        }

        @Override
        public String getResponseHeader(String httpHeader) {
            return "";
        }

        @Override
        public Map<String, List<String>> getResponseHeaders() {
            return new HashMap<String, List<String>>();
        }

        @Override
        public String getResponseHeaderIgnoreCase(String headerName) {
            return "";
        }

        @Override
        public void sendPayload(byte[] buffer, int offset, int length) throws IOException {
        }
    }

    public static class AbfsHttpOperationWithFixedResultForGetListStatus
    extends AbfsHttpOperation {
        private final ListResultSchema hardSetListResultSchema;

        public AbfsHttpOperationWithFixedResultForGetListStatus(URL url, String method, int httpStatus, ListResultSchema listResult) {
            super(url, method, httpStatus);
            this.hardSetListResultSchema = listResult;
        }

        @Override
        public ListResultSchema getListResultSchema() {
            return this.hardSetListResultSchema;
        }

        @Override
        public void processResponse(byte[] buffer, int offset, int length) throws IOException {
        }

        @Override
        public void setRequestProperty(String key, String value) {
        }

        @Override
        protected InputStream getContentInputStream() throws IOException {
            return null;
        }

        @Override
        protected InputStream getErrorStream() throws IOException {
            return null;
        }

        @Override
        String getConnProperty(String key) {
            return null;
        }

        @Override
        URL getConnUrl() {
            return null;
        }

        @Override
        Integer getConnResponseCode() throws IOException {
            return null;
        }

        @Override
        String getConnResponseMessage() throws IOException {
            return null;
        }

        @Override
        Map<String, List<String>> getRequestProperties() {
            return null;
        }

        @Override
        String getRequestProperty(String headerName) {
            return null;
        }

        @Override
        public String getTracingContextSuffix() {
            return null;
        }

        @Override
        public String getResponseHeader(String httpHeader) {
            return "";
        }

        @Override
        public Map<String, List<String>> getResponseHeaders() {
            return new HashMap<String, List<String>>();
        }

        @Override
        public String getResponseHeaderIgnoreCase(String headerName) {
            return "";
        }

        @Override
        public void sendPayload(byte[] buffer, int offset, int length) throws IOException {
        }
    }

    public static class AbfsHttpOperationWithFixedResultForGetFileStatus
    extends AbfsHttpOperation {
        public AbfsHttpOperationWithFixedResultForGetFileStatus(URL url, String method, int httpStatus) {
            super(url, method, httpStatus);
        }

        @Override
        public String getResponseHeader(String httpHeader) {
            if (httpHeader.equals("x-ms-meta-hdi_isfolder")) {
                return "true";
            }
            return "";
        }

        @Override
        public Map<String, List<String>> getResponseHeaders() {
            return new HashMap<String, List<String>>();
        }

        @Override
        public String getResponseHeaderIgnoreCase(String httpHeader) {
            if (httpHeader.equalsIgnoreCase("x-ms-meta-hdi_isfolder")) {
                return "true";
            }
            return "";
        }

        @Override
        public void processResponse(byte[] buffer, int offset, int length) throws IOException {
        }

        @Override
        public void setRequestProperty(String key, String value) {
        }

        @Override
        protected InputStream getContentInputStream() throws IOException {
            return null;
        }

        @Override
        protected InputStream getErrorStream() throws IOException {
            return null;
        }

        @Override
        String getConnProperty(String key) {
            return null;
        }

        @Override
        URL getConnUrl() {
            return null;
        }

        @Override
        Integer getConnResponseCode() throws IOException {
            return null;
        }

        @Override
        String getConnResponseMessage() throws IOException {
            return null;
        }

        @Override
        Map<String, List<String>> getRequestProperties() {
            return null;
        }

        @Override
        String getRequestProperty(String headerName) {
            return null;
        }

        @Override
        public String getTracingContextSuffix() {
            return null;
        }

        @Override
        public void sendPayload(byte[] buffer, int offset, int length) throws IOException {
        }
    }
}

