/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientTestUtil;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.ListResponseData;
import org.apache.hadoop.fs.azurebfs.services.StaticRetryPolicy;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;

public class TestAbfsRestOperationMockFailures {
    @Test
    public void testClientRequestIdForConnectTimeoutRetry() throws Exception {
        Exception[] exceptions = new Exception[1];
        String[] abbreviations = new String[1];
        exceptions[0] = new SocketTimeoutException("connect timed out");
        abbreviations[0] = "CT";
        this.testClientRequestIdForTimeoutRetry(exceptions, abbreviations, 1, 1);
    }

    @Test
    public void testClientRequestIdForConnectAndReadTimeoutRetry() throws Exception {
        Exception[] exceptions = new Exception[2];
        String[] abbreviations = new String[2];
        exceptions[0] = new SocketTimeoutException("connect timed out");
        abbreviations[0] = "CT";
        exceptions[1] = new SocketTimeoutException("Read timed out");
        abbreviations[1] = "RT";
        this.testClientRequestIdForTimeoutRetry(exceptions, abbreviations, 1, 1);
    }

    @Test
    public void testClientRequestIdForReadTimeoutRetry() throws Exception {
        Exception[] exceptions = new Exception[1];
        String[] abbreviations = new String[1];
        exceptions[0] = new SocketTimeoutException("Read timed out");
        abbreviations[0] = "RT";
        this.testClientRequestIdForTimeoutRetry(exceptions, abbreviations, 1, 0);
    }

    @Test
    public void testClientRequestIdForUnknownHostRetry() throws Exception {
        Exception[] exceptions = new Exception[1];
        String[] abbreviations = new String[1];
        exceptions[0] = new UnknownHostException();
        abbreviations[0] = "UH";
        this.testClientRequestIdForTimeoutRetry(exceptions, abbreviations, 1, 0);
    }

    @Test
    public void testClientRequestIdForConnectionResetRetry() throws Exception {
        Exception[] exceptions = new Exception[1];
        String[] abbreviations = new String[1];
        exceptions[0] = new SocketTimeoutException("Connection reset by peer");
        abbreviations[0] = "CR";
        this.testClientRequestIdForTimeoutRetry(exceptions, abbreviations, 1, 0);
    }

    @Test
    public void testClientRequestIdForUnknownSocketExRetry() throws Exception {
        Exception[] exceptions = new Exception[1];
        String[] abbreviations = new String[1];
        exceptions[0] = new SocketException("unknown");
        abbreviations[0] = "SE";
        this.testClientRequestIdForTimeoutRetry(exceptions, abbreviations, 1, 0);
    }

    @Test
    public void testClientRequestIdForIOERetry() throws Exception {
        Exception[] exceptions = new Exception[1];
        String[] abbreviations = new String[1];
        exceptions[0] = new InterruptedIOException();
        abbreviations[0] = "IOE";
        this.testClientRequestIdForTimeoutRetry(exceptions, abbreviations, 1, 0);
    }

    @Test
    public void testClientRequestIdFor400Retry() throws Exception {
        this.testClientRequestIdForStatusRetry(400, "", "400", 1);
    }

    @Test
    public void testClientRequestIdFor500Retry() throws Exception {
        this.testClientRequestIdForStatusRetry(500, "", "500", 1);
    }

    @Test
    public void testClientRequestIdFor503INGRetry() throws Exception {
        this.testClientRequestIdForStatusRetry(503, AzureServiceErrorCode.INGRESS_OVER_ACCOUNT_LIMIT.getErrorMessage(), "ING", 2);
    }

    @Test
    public void testClientRequestIdFor503EGRRetry() throws Exception {
        this.testClientRequestIdForStatusRetry(503, AzureServiceErrorCode.EGRESS_OVER_ACCOUNT_LIMIT.getErrorMessage(), "EGR", 2);
    }

    @Test
    public void testClientRequestIdFor503OPRRetry() throws Exception {
        this.testClientRequestIdForStatusRetry(503, AzureServiceErrorCode.TPS_OVER_ACCOUNT_LIMIT.getErrorMessage(), "OPR", 2);
    }

    @Test
    public void testClientRequestIdFor503OtherRetry() throws Exception {
        this.testClientRequestIdForStatusRetry(503, AzureServiceErrorCode.OTHER_SERVER_THROTTLING.getErrorMessage(), "OTH", 1);
    }

    @Test
    public void testRetryPolicyWithDifferentFailureReasons() throws Exception {
        AbfsClient abfsClient = (AbfsClient)Mockito.mock(AbfsClient.class);
        ExponentialRetryPolicy exponentialRetryPolicy = (ExponentialRetryPolicy)Mockito.mock(ExponentialRetryPolicy.class);
        StaticRetryPolicy staticRetryPolicy = (StaticRetryPolicy)Mockito.mock(StaticRetryPolicy.class);
        AbfsThrottlingIntercept intercept = (AbfsThrottlingIntercept)Mockito.mock(AbfsThrottlingIntercept.class);
        AbfsClientTestUtil.addGeneralMockBehaviourToAbfsClient(abfsClient, exponentialRetryPolicy, staticRetryPolicy, intercept, (ListResponseData)Mockito.mock(ListResponseData.class));
        AbfsRestOperation abfsRestOperation = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation(AbfsRestOperationType.ReadFile, abfsClient, "PUT", null, new ArrayList(), (AbfsConfiguration)Mockito.mock(AbfsConfiguration.class)));
        AbfsHttpOperation httpOperation = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        AbfsClientTestUtil.addGeneralMockBehaviourToRestOpAndHttpOp(abfsRestOperation, httpOperation);
        Stubber stubber = Mockito.doThrow((Throwable[])new Throwable[]{new SocketTimeoutException("connect timed out")});
        ((AbfsHttpOperation)stubber.doNothing().when((Object)httpOperation)).processResponse((byte[])ArgumentMatchers.nullable(byte[].class), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue(), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
        Mockito.when((Object)httpOperation.getStatusCode()).thenReturn((Object)-1).thenReturn((Object)503);
        TracingContext tracingContext = (TracingContext)Mockito.mock(TracingContext.class);
        ((TracingContext)Mockito.doNothing().when((Object)tracingContext)).setRetryCount(((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
        ((AbfsHttpOperation)Mockito.doReturn((Object)"").when((Object)httpOperation)).getStorageErrorMessage();
        ((AbfsHttpOperation)Mockito.doReturn((Object)"").when((Object)httpOperation)).getStorageErrorCode();
        ((AbfsHttpOperation)Mockito.doReturn((Object)"HEAD").when((Object)httpOperation)).getMethod();
        ((AbfsHttpOperation)Mockito.doReturn((Object)"").when((Object)httpOperation)).getMaskedUrl();
        ((AbfsHttpOperation)Mockito.doReturn((Object)"").when((Object)httpOperation)).getRequestId();
        ((AbfsHttpOperation)Mockito.doReturn((Object)AzureServiceErrorCode.EGRESS_OVER_ACCOUNT_LIMIT.getErrorMessage()).when((Object)httpOperation)).getStorageErrorMessage();
        ((AbfsRestOperation)Mockito.doReturn((Object)tracingContext).when((Object)abfsRestOperation)).createNewTracingContext((TracingContext)ArgumentMatchers.any());
        try {
            abfsRestOperation.execute(tracingContext);
        }
        catch (AbfsRestOperationException ex) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("Status Code must be HTTP_UNAVAILABLE(503)", new Object[0])).isEqualTo(503);
        }
        ((AbfsHttpOperation)Mockito.verify((Object)httpOperation, (VerificationMode)Mockito.times((int)3))).processResponse((byte[])ArgumentMatchers.nullable(byte[].class), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue(), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
        ((AbfsClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)1))).getRetryPolicy("CT");
        ((StaticRetryPolicy)Mockito.verify((Object)staticRetryPolicy, (VerificationMode)Mockito.times((int)1))).shouldRetry(0, -1);
        ((StaticRetryPolicy)Mockito.verify((Object)staticRetryPolicy, (VerificationMode)Mockito.times((int)1))).getRetryInterval(1);
        ((TracingContext)Mockito.verify((Object)tracingContext, (VerificationMode)Mockito.times((int)1))).constructHeader(httpOperation, "CT", "S");
        ((AbfsClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)2))).getRetryPolicy("EGR");
        ((ExponentialRetryPolicy)Mockito.verify((Object)exponentialRetryPolicy, (VerificationMode)Mockito.times((int)1))).shouldRetry(1, 503);
        ((ExponentialRetryPolicy)Mockito.verify((Object)exponentialRetryPolicy, (VerificationMode)Mockito.times((int)1))).shouldRetry(2, 503);
        ((ExponentialRetryPolicy)Mockito.verify((Object)exponentialRetryPolicy, (VerificationMode)Mockito.times((int)1))).getRetryInterval(2);
        ((TracingContext)Mockito.verify((Object)tracingContext, (VerificationMode)Mockito.times((int)1))).constructHeader(httpOperation, "EGR", "E");
        ((AbfsThrottlingIntercept)Mockito.verify((Object)intercept, (VerificationMode)Mockito.times((int)2))).updateMetrics((AbfsRestOperationType)ArgumentMatchers.nullable(AbfsRestOperationType.class), (AbfsHttpOperation)ArgumentMatchers.nullable(AbfsHttpOperation.class));
    }

    private void testClientRequestIdForStatusRetry(int status, String serverErrorMessage, String keyExpected, int numOfTimesCSTMetricsUpdated) throws Exception {
        AbfsClient abfsClient = (AbfsClient)Mockito.mock(AbfsClient.class);
        ExponentialRetryPolicy exponentialRetryPolicy = (ExponentialRetryPolicy)Mockito.mock(ExponentialRetryPolicy.class);
        StaticRetryPolicy staticRetryPolicy = (StaticRetryPolicy)Mockito.mock(StaticRetryPolicy.class);
        AbfsThrottlingIntercept intercept = (AbfsThrottlingIntercept)Mockito.mock(AbfsThrottlingIntercept.class);
        AbfsClientTestUtil.addGeneralMockBehaviourToAbfsClient(abfsClient, exponentialRetryPolicy, staticRetryPolicy, intercept, (ListResponseData)Mockito.mock(ListResponseData.class));
        AbfsRestOperation abfsRestOperation = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation(AbfsRestOperationType.ReadFile, abfsClient, "PUT", null, new ArrayList(), (AbfsConfiguration)Mockito.mock(AbfsConfiguration.class)));
        AbfsHttpOperation httpOperation = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        AbfsClientTestUtil.addGeneralMockBehaviourToRestOpAndHttpOp(abfsRestOperation, httpOperation);
        ((AbfsHttpOperation)Mockito.doNothing().doNothing().when((Object)httpOperation)).processResponse((byte[])ArgumentMatchers.nullable(byte[].class), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue(), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
        int[] statusCount = new int[]{0};
        ((AbfsHttpOperation)Mockito.doAnswer(answer -> {
            if (statusCount[0] <= 10) {
                statusCount[0] = statusCount[0] + 1;
                return status;
            }
            return 200;
        }).when((Object)httpOperation)).getStatusCode();
        ((AbfsHttpOperation)Mockito.doReturn((Object)serverErrorMessage).when((Object)httpOperation)).getStorageErrorMessage();
        TracingContext tracingContext = (TracingContext)Mockito.mock(TracingContext.class);
        ((TracingContext)Mockito.doNothing().when((Object)tracingContext)).setRetryCount(((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
        ((AbfsRestOperation)Mockito.doReturn((Object)tracingContext).when((Object)abfsRestOperation)).createNewTracingContext((TracingContext)ArgumentMatchers.any());
        int[] count = new int[]{0};
        ((TracingContext)Mockito.doAnswer(invocationOnMock -> {
            if (count[0] == 1) {
                Assertions.assertThat((String)((String)invocationOnMock.getArgument(1))).isEqualTo((Object)keyExpected);
            }
            count[0] = count[0] + 1;
            return null;
        }).when((Object)tracingContext)).constructHeader((AbfsHttpOperation)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        abfsRestOperation.execute(tracingContext);
        Assertions.assertThat((int)count[0]).isEqualTo(2);
        ((AbfsThrottlingIntercept)Mockito.verify((Object)intercept, (VerificationMode)Mockito.times((int)numOfTimesCSTMetricsUpdated))).updateMetrics((AbfsRestOperationType)ArgumentMatchers.any(), (AbfsHttpOperation)ArgumentMatchers.any());
    }

    private void testClientRequestIdForTimeoutRetry(Exception[] exceptions, String[] abbreviationsExpected, int len, int numOfCTExceptions) throws Exception {
        AbfsClient abfsClient = (AbfsClient)Mockito.mock(AbfsClient.class);
        ExponentialRetryPolicy exponentialRetryPolicy = (ExponentialRetryPolicy)Mockito.mock(ExponentialRetryPolicy.class);
        StaticRetryPolicy staticRetryPolicy = (StaticRetryPolicy)Mockito.mock(StaticRetryPolicy.class);
        AbfsThrottlingIntercept intercept = (AbfsThrottlingIntercept)Mockito.mock(AbfsThrottlingIntercept.class);
        AbfsClientTestUtil.addGeneralMockBehaviourToAbfsClient(abfsClient, exponentialRetryPolicy, staticRetryPolicy, intercept, (ListResponseData)Mockito.mock(ListResponseData.class));
        AbfsRestOperation abfsRestOperation = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation(AbfsRestOperationType.ReadFile, abfsClient, "PUT", null, new ArrayList(), (AbfsConfiguration)Mockito.mock(AbfsConfiguration.class)));
        AbfsHttpOperation httpOperation = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        AbfsClientTestUtil.addGeneralMockBehaviourToRestOpAndHttpOp(abfsRestOperation, httpOperation);
        Stubber stubber = Mockito.doThrow((Throwable[])new Throwable[]{exceptions[0]});
        for (int iteration = 1; iteration < len; ++iteration) {
            stubber.doThrow(new Throwable[]{exceptions[iteration]});
        }
        ((AbfsHttpOperation)stubber.doNothing().when((Object)httpOperation)).processResponse((byte[])ArgumentMatchers.nullable(byte[].class), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue(), ((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
        ((AbfsHttpOperation)Mockito.doReturn((Object)200).when((Object)httpOperation)).getStatusCode();
        TracingContext tracingContext = (TracingContext)Mockito.mock(TracingContext.class);
        ((TracingContext)Mockito.doNothing().when((Object)tracingContext)).setRetryCount(((Integer)ArgumentMatchers.nullable(Integer.TYPE)).intValue());
        ((AbfsRestOperation)Mockito.doReturn((Object)tracingContext).when((Object)abfsRestOperation)).createNewTracingContext((TracingContext)ArgumentMatchers.any());
        int[] count = new int[]{0};
        ((TracingContext)Mockito.doAnswer(invocationOnMock -> {
            if (count[0] > 0 && count[0] <= len) {
                Assertions.assertThat((String)((String)invocationOnMock.getArgument(1))).isEqualTo((Object)abbreviationsExpected[count[0] - 1]);
            }
            count[0] = count[0] + 1;
            return null;
        }).when((Object)tracingContext)).constructHeader((AbfsHttpOperation)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        abfsRestOperation.execute(tracingContext);
        Assertions.assertThat((int)count[0]).isEqualTo(len + 1);
        ((AbfsClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)numOfCTExceptions))).getRetryPolicy("CT");
    }
}

