/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.EtagSource;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.commit.ResilientCommitByRename;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientRenameResult;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAbfsRenameRetryRecovery
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestAbfsRenameRetryRecovery.class);
    private boolean isNamespaceEnabled = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);

    @Test
    public void testRenameFailuresDueToIncompleteMetadata() throws Exception {
        String sourcePath = this.getMethodName() + "Source";
        String destNoParentPath = "/NoParent/Dest";
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient mockClient = ITestAbfsClient.getMockAbfsClient(fs.getAbfsStore().getClient(), fs.getAbfsStore().getAbfsConfiguration());
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.mock(AbfsCounters.class);
        Mockito.when((Object)mockClient.getAbfsCounters()).thenReturn((Object)abfsCounters);
        AbfsRestOperation successOp = new AbfsRestOperation(AbfsRestOperationType.RenamePath, mockClient, "PUT", null, null, mockClient.getAbfsConfiguration());
        AbfsClientRenameResult successResult = (AbfsClientRenameResult)Mockito.mock(AbfsClientRenameResult.class);
        ((AbfsClientRenameResult)Mockito.doReturn((Object)successOp).when((Object)successResult)).getOp();
        Mockito.when((Object)successResult.isIncompleteMetadataState()).thenReturn((Object)false);
        AbfsRestOperation failedOp = new AbfsRestOperation(AbfsRestOperationType.RenamePath, mockClient, "PUT", null, null, mockClient.getAbfsConfiguration());
        AbfsClientRenameResult recoveredMetaDataIncompleteResult = (AbfsClientRenameResult)Mockito.mock(AbfsClientRenameResult.class);
        ((AbfsClientRenameResult)Mockito.doReturn((Object)failedOp).when((Object)recoveredMetaDataIncompleteResult)).getOp();
        Mockito.when((Object)recoveredMetaDataIncompleteResult.isIncompleteMetadataState()).thenReturn((Object)true);
        AbfsRestOperationException destParentNotFound = this.getMockAbfsRestOperationException(AzureServiceErrorCode.RENAME_DESTINATION_PARENT_PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.RENAME_DESTINATION_PARENT_PATH_NOT_FOUND.getErrorCode());
        Mockito.when((Object)mockClient.renamePath(sourcePath, destNoParentPath, null, null, null, false)).thenThrow(new Throwable[]{destParentNotFound}).thenReturn((Object)recoveredMetaDataIncompleteResult);
        LambdaTestUtils.intercept(AzureBlobFileSystemException.class, () -> mockClient.renamePath(sourcePath, destNoParentPath, null, null, null, false));
        AbfsClientRenameResult resultOfSecondRenameCall = mockClient.renamePath(sourcePath, destNoParentPath, null, null, null, false);
        ((ObjectAssert)Assertions.assertThat((Object)resultOfSecondRenameCall).describedAs("This result should be recovered result due to MetaData being in incomplete state", new Object[0])).isSameAs((Object)recoveredMetaDataIncompleteResult);
        TestAbfsRenameRetryRecovery.assertTrue((String)"Metadata incomplete state should be true if a rename is retried after no Parent directory is found", (boolean)resultOfSecondRenameCall.isIncompleteMetadataState());
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.times((int)2))).renamePath(sourcePath, destNoParentPath, null, null, null, false);
    }

    AbfsClient getMockAbfsClient() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient spyClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsStore().getClient());
        AbfsConfiguration spiedConf = (AbfsConfiguration)Mockito.spy((Object)fs.getAbfsStore().getAbfsConfiguration());
        ((AbfsConfiguration)Mockito.doReturn((Object)2000).when((Object)spiedConf)).getHttpConnectionTimeout();
        ((AbfsConfiguration)Mockito.doReturn((Object)30000).when((Object)spiedConf)).getHttpReadTimeout();
        ((AbfsClient)Mockito.doReturn((Object)spiedConf).when((Object)spyClient)).getAbfsConfiguration();
        ((AbfsClient)Mockito.doAnswer(answer -> {
            AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.RenamePath, spyClient, "PUT", (URL)answer.getArgument(0), (List)answer.getArgument(1), spyClient.getAbfsConfiguration());
            AbfsRestOperation spiedOp = (AbfsRestOperation)Mockito.spy((Object)op);
            this.addSpyBehavior(spiedOp, op, spyClient);
            return spiedOp;
        }).when((Object)spyClient)).createRenameRestOperation((URL)Mockito.any(URL.class), ArgumentMatchers.anyList());
        ((AbfsClient)Mockito.doCallRealMethod().when((Object)spyClient)).getPathStatus(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (TracingContext)Mockito.any(TracingContext.class), (ContextEncryptionAdapter)Mockito.any(ContextEncryptionAdapter.class));
        return spyClient;
    }

    private void addSpyBehavior(AbfsRestOperation spiedRestOp, AbfsRestOperation normalRestOp, AbfsClient client) throws IOException {
        AbfsHttpOperation failingOperation = (AbfsHttpOperation)Mockito.spy((Object)normalRestOp.createHttpOperation());
        AbfsHttpOperation normalOp1 = normalRestOp.createHttpOperation();
        this.executeThenFail(client, normalRestOp, failingOperation, normalOp1);
        AbfsHttpOperation normalOp2 = normalRestOp.createHttpOperation();
        normalOp2.setRequestProperty("Authorization", client.getAccessToken());
        ((AbfsRestOperation)Mockito.doReturn((Object)failingOperation).doReturn((Object)normalOp2).when((Object)spiedRestOp)).createHttpOperation();
    }

    private void executeThenFail(AbfsClient client, AbfsRestOperation normalRestOp, AbfsHttpOperation failingOperation, AbfsHttpOperation normalOp) throws IOException {
        ((AbfsHttpOperation)Mockito.doAnswer(answer -> {
            LOG.info("Executing first attempt with post-operation fault injection");
            byte[] buffer = (byte[])answer.getArgument(0);
            int offset = (Integer)answer.getArgument(1);
            int length = (Integer)answer.getArgument(2);
            normalRestOp.signRequest(normalOp, length);
            normalOp.sendPayload(buffer, offset, length);
            normalOp.processResponse(buffer, offset, length);
            LOG.info("Actual outcome is {} \"{}\" \"{}\"; injecting failure", new Object[]{normalOp.getStatusCode(), normalOp.getStorageErrorCode(), normalOp.getStorageErrorMessage()});
            throw new SocketException("connection-reset");
        }).when((Object)failingOperation)).sendPayload((byte[])Mockito.nullable(byte[].class), ((Integer)Mockito.nullable(Integer.TYPE)).intValue(), ((Integer)Mockito.nullable(Integer.TYPE)).intValue());
    }

    @Test
    public void testRenameRecoveryEtagMatchFsLevel() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        Assume.assumeTrue((boolean)fs.getAbfsStore().getIsNamespaceEnabled(testTracingContext));
        AbfsClient mockClient = this.getMockAbfsClient();
        String base = "/" + this.getMethodName();
        String path1 = base + "/dummyFile1";
        String path2 = base + "/dummyFile2";
        this.touch(new Path(path1));
        this.setAbfsClient(abfsStore, mockClient);
        AbfsCounters counter = mockClient.getAbfsCounters();
        IOStatistics ioStats = counter.getIOStatistics();
        Long connMadeBeforeRename = IOStatisticAssertions.lookupCounterStatistic((IOStatistics)ioStats, (String)AbfsStatistic.CONNECTIONS_MADE.getStatName());
        Long renamePathAttemptsBeforeRename = IOStatisticAssertions.lookupCounterStatistic((IOStatistics)ioStats, (String)AbfsStatistic.RENAME_PATH_ATTEMPTS.getStatName());
        fs.rename(new Path(path1), new Path(path2));
        int totalConnections = 4;
        if (!this.getConfiguration().getIsClientTransactionIdEnabled()) {
            ++totalConnections;
        }
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)ioStats, (String)AbfsStatistic.CONNECTIONS_MADE.getStatName()).isEqualTo((long)totalConnections + connMadeBeforeRename);
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)ioStats, (String)AbfsStatistic.RENAME_PATH_ATTEMPTS.getStatName()).isEqualTo(1L + renamePathAttemptsBeforeRename);
    }

    @Test
    public void testRenameRecoveryEtagMismatchFsLevel() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        Assume.assumeTrue((boolean)fs.getAbfsStore().getIsNamespaceEnabled(testTracingContext));
        AbfsClient mockClient = this.getMockAbfsClient();
        String base = "/" + this.getMethodName();
        String path1 = base + "/dummyFile1";
        String path2 = base + "/dummyFile2";
        fs.create(new Path(path2));
        this.setAbfsClient(abfsStore, mockClient);
        TestAbfsRenameRetryRecovery.assertEquals((Object)false, (Object)fs.rename(new Path(path1), new Path(path2)));
    }

    @Test
    public void testRenameRecoveryFailsForDirFsLevel() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        Assume.assumeTrue((boolean)fs.getAbfsStore().getIsNamespaceEnabled(testTracingContext));
        AbfsClient mockClient = this.getMockAbfsClient();
        String dir1 = "/dummyDir1";
        String dir2 = "/dummyDir2";
        Path path1 = new Path(dir1);
        Path path2 = new Path(dir2);
        fs.mkdirs(path1);
        this.setAbfsClient(abfsStore, mockClient);
        AbfsCounters counter = mockClient.getAbfsCounters();
        IOStatistics ioStats = counter.getIOStatistics();
        Long connMadeBeforeRename = IOStatisticAssertions.lookupCounterStatistic((IOStatistics)ioStats, (String)AbfsStatistic.CONNECTIONS_MADE.getStatName());
        Long renamePathAttemptsBeforeRename = IOStatisticAssertions.lookupCounterStatistic((IOStatistics)ioStats, (String)AbfsStatistic.RENAME_PATH_ATTEMPTS.getStatName());
        boolean renameResult = fs.rename(path1, path2);
        if (this.getConfiguration().getIsClientTransactionIdEnabled()) {
            TestAbfsRenameRetryRecovery.assertTrue((boolean)renameResult);
        } else {
            TestAbfsRenameRetryRecovery.assertFalse((boolean)renameResult);
        }
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)ioStats, (String)AbfsStatistic.CONNECTIONS_MADE.getStatName()).isEqualTo(4L + connMadeBeforeRename);
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)ioStats, (String)AbfsStatistic.RENAME_PATH_ATTEMPTS.getStatName()).isEqualTo(1L + renamePathAttemptsBeforeRename);
    }

    private static void expectErrorCode(AzureServiceErrorCode code, AbfsRestOperationException e) throws AbfsRestOperationException {
        if (e.getErrorCode() != code) {
            throw e;
        }
    }

    @Test
    public void testDirRenameRecoveryUnsupported() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        Assume.assumeTrue((boolean)fs.getAbfsStore().getIsNamespaceEnabled(testTracingContext));
        AbfsClient spyClient = this.getMockAbfsClient();
        String base = "/" + this.getMethodName();
        String path1 = base + "/dummyDir1";
        String path2 = base + "/dummyDir2";
        fs.mkdirs(new Path(path1));
        if (this.getConfiguration().getIsClientTransactionIdEnabled()) {
            TestAbfsRenameRetryRecovery.assertTrue((boolean)fs.rename(new Path(path1), new Path(path2)));
        } else {
            TestAbfsRenameRetryRecovery.expectErrorCode(AzureServiceErrorCode.SOURCE_PATH_NOT_FOUND, (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> spyClient.renamePath(path1, path2, null, testTracingContext, null, false)));
        }
    }

    @Test
    public void testExistingPathCorrectlyRejected() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        Assume.assumeTrue((boolean)fs.getAbfsStore().getIsNamespaceEnabled(testTracingContext));
        AbfsClient spyClient = this.getMockAbfsClient();
        String base = "/" + this.getMethodName();
        String path1 = base + "/dummyDir1";
        String path2 = base + "/dummyDir2";
        this.touch(new Path(path1));
        this.touch(new Path(path2));
        TestAbfsRenameRetryRecovery.expectErrorCode(AzureServiceErrorCode.PATH_ALREADY_EXISTS, (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> spyClient.renamePath(path1, path2, null, testTracingContext, null, false)));
    }

    @Test
    public void testRenameRecoveryUnsupportedForFlatNamespace() throws Exception {
        Assume.assumeTrue((!this.isNamespaceEnabled ? 1 : 0) != 0);
        this.assumeDfsServiceType();
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        AbfsClient mockClient = this.getMockAbfsClient();
        String base = "/" + this.getMethodName();
        String path1 = base + "/dummyFile1";
        String path2 = base + "/dummyFile2";
        this.touch(new Path(path1));
        this.setAbfsClient(abfsStore, mockClient);
        AbfsCounters counter = mockClient.getAbfsCounters();
        IOStatistics ioStats = counter.getIOStatistics();
        Long connMadeBeforeRename = IOStatisticAssertions.lookupCounterStatistic((IOStatistics)ioStats, (String)AbfsStatistic.CONNECTIONS_MADE.getStatName());
        Long renamePathAttemptsBeforeRename = IOStatisticAssertions.lookupCounterStatistic((IOStatistics)ioStats, (String)AbfsStatistic.RENAME_PATH_ATTEMPTS.getStatName());
        TestAbfsRenameRetryRecovery.expectErrorCode(AzureServiceErrorCode.SOURCE_PATH_NOT_FOUND, (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> mockClient.renamePath(path1, path2, null, testTracingContext, null, false)));
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)ioStats, (String)AbfsStatistic.CONNECTIONS_MADE.getStatName()).isEqualTo(2L + connMadeBeforeRename);
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)ioStats, (String)AbfsStatistic.RENAME_PATH_ATTEMPTS.getStatName()).isEqualTo(1L + renamePathAttemptsBeforeRename);
    }

    @Test
    public void testResilientCommitOperation() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        AzureBlobFileSystemStore store = fs.getAbfsStore();
        Assume.assumeTrue((boolean)store.getIsNamespaceEnabled(testTracingContext));
        this.setAbfsClient(store, this.getMockAbfsClient());
        String base = "/" + this.getMethodName();
        String path1 = base + "/dummyDir1";
        String path2 = base + "/dummyDir2";
        Path source = new Path(path1);
        this.touch(source);
        String sourceTag = ((EtagSource)fs.getFileStatus(source)).getEtag();
        ResilientCommitByRename commit = fs.createResilientCommitSupport(source);
        Pair outcome = commit.commitSingleFileByRename(source, new Path(path2), sourceTag);
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)outcome.getKey())).describedAs("recovery flag", new Object[0])).isTrue();
    }

    @Test
    public void testResilientCommitOperationTagMismatch() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        TracingContext testTracingContext = this.getTestTracingContext(fs, false);
        AzureBlobFileSystemStore store = fs.getAbfsStore();
        Assume.assumeTrue((boolean)store.getIsNamespaceEnabled(testTracingContext));
        this.setAbfsClient(store, this.getMockAbfsClient());
        String base = "/" + this.getMethodName();
        String path1 = base + "/dummyDir1";
        String path2 = base + "/dummyDir2";
        Path source = new Path(path1);
        this.touch(source);
        ResilientCommitByRename commit = fs.createResilientCommitSupport(source);
        if (this.getConfiguration().getIsClientTransactionIdEnabled()) {
            Pair response = commit.commitSingleFileByRename(source, new Path(path2), "not the right tag");
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)response.getKey())).describedAs("Recovery using client transaction ID", new Object[0])).isTrue();
        } else {
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> commit.commitSingleFileByRename(source, new Path(path2), "not the right tag"));
        }
    }

    private AbfsRestOperationException getMockAbfsRestOperationException(int statusCode, String errorCode) {
        return new AbfsRestOperationException(statusCode, errorCode, "No Parent found for the Destination file", new Exception());
    }
}

