/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.azurebfs.enums.AbfsBackoffMetricsEnum;
import org.apache.hadoop.fs.azurebfs.enums.RetryValue;
import org.apache.hadoop.fs.azurebfs.enums.StatisticTypeEnum;
import org.apache.hadoop.fs.azurebfs.services.AbfsBackoffMetrics;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class TestAbfsBackoffMetrics {
    private AbfsBackoffMetrics metrics;
    private static final int TOTAL_COUNTERS = 22;
    private static final int TOTAL_GAUGES = 21;

    @Before
    public void setUp() {
        this.metrics = new AbfsBackoffMetrics();
    }

    @Test
    public void retrievesMetricNamesBasedOnStatisticType() {
        String[] counterMetrics = this.metrics.getMetricNamesByType(StatisticTypeEnum.TYPE_COUNTER);
        String[] gaugeMetrics = this.metrics.getMetricNamesByType(StatisticTypeEnum.TYPE_GAUGE);
        ((AbstractIntegerAssert)Assertions.assertThat((int)counterMetrics.length).describedAs("Counter metrics should have 22 elements", new Object[0])).isEqualTo(22);
        ((AbstractIntegerAssert)Assertions.assertThat((int)gaugeMetrics.length).describedAs("Gauge metrics should have 21 elements", new Object[0])).isEqualTo(21);
    }

    @Test
    public void retrievesValueOfSpecificMetric() {
        this.metrics.setMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED, 5L, RetryValue.ONE);
        ((AbstractLongAssert)Assertions.assertThat((long)this.metrics.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED, RetryValue.ONE)).describedAs("Number of request succeeded for retry 1 should be 5", new Object[0])).isEqualTo(5L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.metrics.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED, RetryValue.TWO)).describedAs("Number of request succeeded for other retries except 1 should be 0", new Object[0])).isEqualTo(0L);
    }

    @Test
    public void incrementsValueOfSpecificMetric() {
        this.metrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED, RetryValue.ONE);
        ((AbstractLongAssert)Assertions.assertThat((long)this.metrics.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED, RetryValue.ONE)).describedAs("Number of request succeeded for retry 1 should be 1", new Object[0])).isEqualTo(1L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.metrics.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED, RetryValue.THREE)).describedAs("Number of request succeeded for other retries except 1 should be 0", new Object[0])).isEqualTo(0L);
    }

    @Test
    public void returnsStringRepresentationOfEmptyBackoffMetrics() {
        ((AbstractLongAssert)Assertions.assertThat((long)this.metrics.getMetricValue(AbfsBackoffMetricsEnum.TOTAL_NUMBER_OF_REQUESTS)).describedAs("String representation of backoff metrics should be empty", new Object[0])).isEqualTo(0L);
        ((AbstractStringAssert)Assertions.assertThat((String)this.metrics.toString()).describedAs("String representation of backoff metrics should be empty", new Object[0])).isEmpty();
    }

    @Test
    public void returnsStringRepresentationOfBackoffMetrics() {
        this.metrics.incrementMetricValue(AbfsBackoffMetricsEnum.TOTAL_NUMBER_OF_REQUESTS);
        ((AbstractLongAssert)Assertions.assertThat((long)this.metrics.getMetricValue(AbfsBackoffMetricsEnum.TOTAL_NUMBER_OF_REQUESTS)).describedAs("String representation of backoff metrics should not be empty", new Object[0])).isEqualTo(1L);
        ((AbstractStringAssert)Assertions.assertThat((String)this.metrics.toString()).describedAs("String representation of backoff metrics should not be empty", new Object[0])).contains(new CharSequence[]{"$TR=1"});
    }
}

