/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.BlobRenameHandler;
import org.apache.hadoop.fs.azurebfs.services.PathInformation;
import org.apache.hadoop.fs.azurebfs.services.RenameAtomicity;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public final class RenameAtomicityTestUtils {
    private RenameAtomicityTestUtils() {
    }

    public static void addCreatePathMock(AbfsBlobClient client, Answer answer) {
        ((AbfsBlobClient)Mockito.doAnswer(clientHandlerAns -> {
            BlobRenameHandler renameHandler = (BlobRenameHandler)Mockito.spy((Object)((BlobRenameHandler)clientHandlerAns.callRealMethod()));
            ((BlobRenameHandler)Mockito.doAnswer(getRenameAtomicityAns -> {
                RenameAtomicity renameAtomicity = (RenameAtomicity)Mockito.spy((Object)((RenameAtomicity)getRenameAtomicityAns.callRealMethod()));
                ((RenameAtomicity)Mockito.doAnswer((Answer)answer).when((Object)renameAtomicity)).createRenamePendingJson((Path)Mockito.any(Path.class), (byte[])Mockito.any(byte[].class));
                return renameAtomicity;
            }).when((Object)renameHandler)).getRenameAtomicity((PathInformation)Mockito.any(PathInformation.class));
            return renameHandler;
        }).when((Object)client)).getBlobRenameHandler(Mockito.anyString(), Mockito.anyString(), (String)Mockito.nullable(String.class), Mockito.anyBoolean(), (TracingContext)Mockito.any(TracingContext.class));
    }

    public static void addReadPathMock(RenameAtomicity redoRenameAtomicity, Answer answer) throws AzureBlobFileSystemException {
        ((RenameAtomicity)Mockito.doAnswer((Answer)answer).when((Object)redoRenameAtomicity)).readRenamePendingJson((Path)Mockito.any(Path.class), Mockito.anyInt());
    }
}

