/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsNoOpThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingInterceptFactory;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;

public class ITestExponentialRetryPolicy
extends AbstractAbfsIntegrationTest {
    private final int maxRetryCount = 30;
    private final int noRetryCount = 0;
    private final int retryCount = new Random().nextInt(30);
    private final int retryCountBeyondMax = 31;
    private static final String TEST_PATH = "/testfile";
    private static final double MULTIPLYING_FACTOR = 1.5;
    private static final int ANALYSIS_PERIOD = 10000;
    private static final String DUMMY_ACCOUNT_NAME = "dummy.dfs.core.windows.net";
    private static final String DUMMY_ACCOUNT_NAME_1 = "dummy1.dfs.core.windows.net";
    private static final String DUMMY_ACCOUNT_KEY = "dummyKey";

    @Test
    public void testDifferentMaxIORetryCount() throws Exception {
        AbfsConfiguration abfsConfig = this.getAbfsConfig();
        abfsConfig.setMaxIoRetries(0);
        this.testMaxIOConfig(abfsConfig);
        abfsConfig.setMaxIoRetries(this.retryCount);
        this.testMaxIOConfig(abfsConfig);
        abfsConfig.setMaxIoRetries(31);
        this.testMaxIOConfig(abfsConfig);
    }

    @Test
    public void testDefaultMaxIORetryCount() throws Exception {
        AbfsConfiguration abfsConfig = this.getAbfsConfig();
        ((AbstractIntegerAssert)Assertions.assertThat((int)abfsConfig.getMaxIoRetries()).describedAs("Max retry count should be %s", new Object[]{30})).isEqualTo(30);
        this.testMaxIOConfig(abfsConfig);
    }

    @Test
    public void testClientSideThrottlingConfigs() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setBoolean("fs.azure.enable.autothrottling", true);
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, DUMMY_ACCOUNT_NAME);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfsConfiguration.isAutoThrottlingEnabled()).describedAs("Client-side throttling enabled by configuration key", new Object[0])).isTrue();
        configuration.unset("fs.azure.enable.autothrottling");
        AbfsConfiguration abfsConfiguration2 = new AbfsConfiguration(configuration, DUMMY_ACCOUNT_NAME);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfsConfiguration2.isAutoThrottlingEnabled()).describedAs("Client-side throttling should be disabled by default", new Object[0])).isFalse();
    }

    @Test
    public void testThrottlingIntercept() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.setBoolean("fs.azure.enable.autothrottling", false);
        configuration.set("fs.azure.account.key.dummy.dfs.core.windows.net", DUMMY_ACCOUNT_KEY);
        configuration.set("fs.azure.account.key.dummy1.dfs.core.windows.net", DUMMY_ACCOUNT_KEY);
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, DUMMY_ACCOUNT_NAME);
        AbfsClient abfsClient = ITestAbfsClient.createTestClientFromCurrentContext(fs.getAbfsStore().getClient(), abfsConfiguration);
        AbfsThrottlingIntercept intercept = abfsClient.getIntercept();
        ((ObjectAssert)Assertions.assertThat((Object)intercept).describedAs("AbfsNoOpThrottlingIntercept instance expected", new Object[0])).isInstanceOf(AbfsNoOpThrottlingIntercept.class);
        configuration.setBoolean("fs.azure.enable.autothrottling", true);
        configuration.setBoolean("fs.azure.account.throttling.enabled", true);
        AbfsConfiguration abfsConfiguration1 = new AbfsConfiguration(configuration, DUMMY_ACCOUNT_NAME_1);
        AbfsClient abfsClient1 = ITestAbfsClient.createTestClientFromCurrentContext(fs.getAbfsStore().getClient(), abfsConfiguration1);
        intercept = abfsClient1.getIntercept();
        ((ObjectAssert)Assertions.assertThat((Object)intercept).describedAs("AbfsClientThrottlingIntercept instance expected", new Object[0])).isInstanceOf(AbfsClientThrottlingIntercept.class);
    }

    @Test
    public void testCreateMultipleAccountThrottling() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        String accountName = config.get("fs.azure.account.name");
        if (accountName == null) {
            accountName = config.get("fs.azure.abfs.account1.name");
        }
        Assume.assumeTrue((String)"Not set: fs.azure.abfs.account1.name", (accountName != null && !accountName.isEmpty() ? 1 : 0) != 0);
        Configuration rawConfig1 = new Configuration();
        rawConfig1.addResource("azure-test.xml");
        AbfsRestOperation successOp = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        AbfsHttpOperation http500Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Mockito.when((Object)http500Op.getStatusCode()).thenReturn((Object)500);
        Mockito.when((Object)successOp.getResult()).thenReturn((Object)http500Op);
        AbfsConfiguration configuration = (AbfsConfiguration)Mockito.mock(AbfsConfiguration.class);
        Mockito.when((Object)configuration.getAnalysisPeriod()).thenReturn((Object)10000);
        Mockito.when((Object)configuration.isAutoThrottlingEnabled()).thenReturn((Object)true);
        Mockito.when((Object)configuration.accountThrottlingEnabled()).thenReturn((Object)false);
        AbfsThrottlingIntercept instance1 = AbfsThrottlingInterceptFactory.getInstance((String)accountName, (AbfsConfiguration)configuration);
        String accountName1 = config.get("fs.azure.abfs.account1.name");
        Assume.assumeTrue((String)"Not set: fs.azure.abfs.account1.name", (accountName1 != null && !accountName1.isEmpty() ? 1 : 0) != 0);
        AbfsThrottlingIntercept instance2 = AbfsThrottlingInterceptFactory.getInstance((String)accountName1, (AbfsConfiguration)configuration);
        ((ObjectAssert)Assertions.assertThat((Object)instance1).describedAs("if singleton is enabled, for different accounts both the instances should return same value", new Object[0])).isEqualTo((Object)instance2);
        Mockito.when((Object)configuration.accountThrottlingEnabled()).thenReturn((Object)true);
        AbfsThrottlingIntercept instance3 = AbfsThrottlingInterceptFactory.getInstance((String)accountName, (AbfsConfiguration)configuration);
        AbfsThrottlingIntercept instance4 = AbfsThrottlingInterceptFactory.getInstance((String)accountName1, (AbfsConfiguration)configuration);
        AbfsThrottlingIntercept instance5 = AbfsThrottlingInterceptFactory.getInstance((String)accountName, (AbfsConfiguration)configuration);
        ((ObjectAssert)Assertions.assertThat((Object)instance3).describedAs("iff singleton is not enabled, for different accounts instances should return different value", new Object[0])).isNotEqualTo((Object)instance4);
        ((ObjectAssert)Assertions.assertThat((Object)instance3).describedAs("if singleton is not enabled, for same accounts instances should return same value", new Object[0])).isEqualTo((Object)instance5);
    }

    @Test
    public void testOperationOnAccountIdle() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient client = fs.getAbfsStore().getClient();
        AbfsConfiguration configuration1 = client.getAbfsConfiguration();
        Assume.assumeTrue((boolean)configuration1.isAutoThrottlingEnabled());
        Assume.assumeTrue((boolean)configuration1.accountThrottlingEnabled());
        AbfsClientThrottlingIntercept accountIntercept = (AbfsClientThrottlingIntercept)client.getIntercept();
        byte[] b = new byte[32768];
        new Random().nextBytes(b);
        Path testPath = this.path(TEST_PATH);
        try (FSDataOutputStream stream = fs.create(testPath);){
            stream.write(b);
        }
        int sleepTime = (int)((double)this.getAbfsConfig().getAccountOperationIdleTimeout() * 1.5);
        Thread.sleep(sleepTime);
        try (FSDataInputStream streamRead = fs.open(testPath);){
            streamRead.read(b);
        }
        AzureBlobFileSystem fs1 = new AzureBlobFileSystem();
        Configuration config = new Configuration(this.getRawConfiguration());
        String accountName1 = config.get("fs.azure.abfs.account1.name");
        Assume.assumeTrue((String)"Not set: fs.azure.abfs.account1.name", (accountName1 != null && !accountName1.isEmpty() ? 1 : 0) != 0);
        String abfsUrl1 = this.getFileSystemName() + "12@" + accountName1;
        URI defaultUri1 = null;
        defaultUri1 = new URI("abfss", abfsUrl1, null, null, null);
        fs1.initialize(defaultUri1, this.getRawConfiguration());
        AbfsClient client1 = fs1.getAbfsStore().getClient();
        AbfsClientThrottlingIntercept accountIntercept1 = (AbfsClientThrottlingIntercept)client1.getIntercept();
        try (FSDataOutputStream stream1 = fs1.create(testPath);){
            stream1.write(b);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)accountIntercept.getWriteThrottler().getIsOperationOnAccountIdle().get()).describedAs("Write analyzer for first account should be idle the first time", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)accountIntercept.getReadThrottler().getIsOperationOnAccountIdle().get()).describedAs("Read analyzer for first account should not be idle", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)accountIntercept1.getWriteThrottler().getIsOperationOnAccountIdle().get()).describedAs("Write analyzer for second account should not be idle", new Object[0])).isFalse();
        try (FSDataOutputStream stream2 = fs.create(testPath);){
            stream2.write(b);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)accountIntercept.getWriteThrottler().getIsOperationOnAccountIdle().get()).describedAs("Write analyzer for first account should not be idle second time", new Object[0])).isFalse();
    }

    @Test
    public void testAbfsConfigConstructor() throws Exception {
        ExponentialRetryPolicy template = new ExponentialRetryPolicy(this.getAbfsConfig().getMaxIoRetries());
        int testModifier = 1;
        int expectedMaxRetries = template.getMaxRetryCount() + testModifier;
        int expectedMinBackoff = template.getMinBackoff() + testModifier;
        int expectedMaxBackoff = template.getMaxBackoff() + testModifier;
        int expectedDeltaBackoff = template.getDeltaBackoff() + testModifier;
        Configuration config = new Configuration(this.getRawConfiguration());
        config.setInt("fs.azure.io.retry.max.retries", expectedMaxRetries);
        config.setInt("fs.azure.io.retry.min.backoff.interval", expectedMinBackoff);
        config.setInt("fs.azure.io.retry.max.backoff.interval", expectedMaxBackoff);
        config.setInt("fs.azure.io.retry.backoff.interval", expectedDeltaBackoff);
        ExponentialRetryPolicy policy = new ExponentialRetryPolicy(new AbfsConfiguration(config, "dummyAccountName"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)policy.getMaxRetryCount()).describedAs("Max retry count was not set as expected.", new Object[0])).isEqualTo(expectedMaxRetries);
        ((AbstractIntegerAssert)Assertions.assertThat((int)policy.getMinBackoff()).describedAs("Min backoff interval was not set as expected.", new Object[0])).isEqualTo(expectedMinBackoff);
        ((AbstractIntegerAssert)Assertions.assertThat((int)policy.getMaxBackoff()).describedAs("Max backoff interval was not set as expected", new Object[0])).isEqualTo(expectedMaxBackoff);
        ((AbstractIntegerAssert)Assertions.assertThat((int)policy.getDeltaBackoff()).describedAs("Delta backoff interval was not set as expected.", new Object[0])).isEqualTo(expectedDeltaBackoff);
    }

    private AbfsConfiguration getAbfsConfig() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        return new AbfsConfiguration(config, "dummyAccountName");
    }

    private void testMaxIOConfig(AbfsConfiguration abfsConfig) {
        int localRetryCount;
        ExponentialRetryPolicy retryPolicy = new ExponentialRetryPolicy(abfsConfig.getMaxIoRetries());
        for (localRetryCount = 0; localRetryCount < abfsConfig.getMaxIoRetries(); ++localRetryCount) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)retryPolicy.shouldRetry(localRetryCount, -1)).describedAs("Retry should be allowed when retryCount less than max count configured.", new Object[0])).isTrue();
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)localRetryCount).describedAs("When all retries are exhausted, the retryCount will be same as max configured.", new Object[0])).isEqualTo(abfsConfig.getMaxIoRetries());
    }
}

