/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.extensions.KerberizedAbfsCluster;
import org.apache.hadoop.fs.azurebfs.extensions.StubAbfsTokenIdentifier;
import org.apache.hadoop.fs.azurebfs.extensions.StubDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestDTManagerLifecycle
extends AbstractAbfsTestWithTimeout {
    public static final String RENEWER = "resourcemanager";
    private Configuration conf;
    public static final String ABFS = "abfs://testing@account.dfs.core.windows.net";
    public static final URI FSURI = KerberizedAbfsCluster.newURI("abfs://testing@account.dfs.core.windows.net");
    public static final Text OWNER = new Text("owner");
    public static final Text KIND2 = new Text("kind2");

    @Before
    public void setup() throws Exception {
        this.conf = StubDelegationTokenManager.useStubDTManager(new Configuration());
    }

    @After
    public void teardown() throws Exception {
    }

    protected void assertTokenKind(Text kind, Token<DelegationTokenIdentifier> dt) {
        TestDTManagerLifecycle.assertEquals((String)"Token Kind", (Object)kind, (Object)dt.getKind());
    }

    @Test
    public void testClassicLifecycle() throws Throwable {
        AbfsDelegationTokenManager manager = new AbfsDelegationTokenManager(this.conf);
        StubDelegationTokenManager stub = this.getTokenManager(manager);
        TestDTManagerLifecycle.assertTrue((String)("Not initialized: " + stub), (boolean)stub.isInitialized());
        Token<DelegationTokenIdentifier> dt = stub.getDelegationToken(RENEWER);
        this.assertTokenKind(StubAbfsTokenIdentifier.TOKEN_KIND, dt);
        TestDTManagerLifecycle.assertNull((String)("canonicalServiceName in " + stub), (Object)manager.getCanonicalServiceName());
        TestDTManagerLifecycle.assertEquals((String)("Issued count number in " + stub), (long)1L, (long)stub.getIssued());
        StubAbfsTokenIdentifier id = StubAbfsTokenIdentifier.decodeIdentifier(dt);
        TestDTManagerLifecycle.assertEquals((String)("Sequence number in " + id), (long)1L, (long)id.getSequenceNumber());
        stub.renewDelegationToken(dt);
        TestDTManagerLifecycle.assertEquals((String)("Renewal count in " + stub), (long)1L, (long)stub.getRenewals());
        stub.cancelDelegationToken(dt);
        TestDTManagerLifecycle.assertEquals((String)("Cancel count in " + stub), (long)1L, (long)stub.getCancellations());
    }

    protected StubDelegationTokenManager getTokenManager(AbfsDelegationTokenManager manager) {
        return (StubDelegationTokenManager)manager.getTokenManager();
    }

    @Test
    public void testBindingLifecycle() throws Throwable {
        AbfsDelegationTokenManager manager = new AbfsDelegationTokenManager(this.conf);
        StubDelegationTokenManager stub = this.getTokenManager(manager);
        TestDTManagerLifecycle.assertTrue((String)("Not initialized: " + stub), (boolean)stub.isInitialized());
        stub.bind(FSURI, this.conf);
        TestDTManagerLifecycle.assertEquals((String)("URI in " + stub), (Object)FSURI, (Object)stub.getFsURI());
        StubAbfsTokenIdentifier.decodeIdentifier(stub.getDelegationToken(RENEWER));
        stub.close();
        TestDTManagerLifecycle.assertTrue((String)("Not closed: " + stub), (boolean)stub.isClosed());
        stub.close();
        TestDTManagerLifecycle.assertTrue((String)("Not closed: " + stub), (boolean)stub.isClosed());
    }

    @Test
    public void testBindingThroughManager() throws Throwable {
        AbfsDelegationTokenManager manager = new AbfsDelegationTokenManager(this.conf);
        manager.bind(FSURI, this.conf);
        StubDelegationTokenManager stub = this.getTokenManager(manager);
        TestDTManagerLifecycle.assertEquals((String)("Service in " + manager), (Object)ABFS, (Object)stub.createServiceText().toString());
        TestDTManagerLifecycle.assertEquals((String)("Binding URI of " + stub), (Object)FSURI, (Object)stub.getFsURI());
        Token token = manager.getDelegationToken(RENEWER);
        TestDTManagerLifecycle.assertEquals((String)("Service in " + token), (Object)ABFS, (Object)token.getService().toString());
        StubAbfsTokenIdentifier.decodeIdentifier(token);
        this.assertTokenKind(StubAbfsTokenIdentifier.TOKEN_KIND, (Token<DelegationTokenIdentifier>)token);
        stub.setKind(KIND2);
        Token dt2 = manager.getDelegationToken("");
        this.assertTokenKind(KIND2, (Token<DelegationTokenIdentifier>)dt2);
        TestDTManagerLifecycle.assertNull((String)"Token is of unknown kind, must not decode", (Object)dt2.decodeIdentifier());
        manager.close();
        TestDTManagerLifecycle.assertTrue((String)("Not closed: " + stub), (boolean)stub.isClosed());
    }

    @Test
    public void testRenewalThroughManager() throws Throwable {
        Token<DelegationTokenIdentifier> dt = StubDelegationTokenManager.createToken(0, FSURI, OWNER, new Text(RENEWER));
        AbfsDelegationTokenManager manager = new AbfsDelegationTokenManager(this.conf);
        StubDelegationTokenManager stub = this.getTokenManager(manager);
        TestDTManagerLifecycle.assertNull((String)("Stub should not bebound " + stub), (Object)stub.getFsURI());
        StubAbfsTokenIdentifier dtId = (StubAbfsTokenIdentifier)dt.decodeIdentifier();
        String idStr = dtId.toString();
        TestDTManagerLifecycle.assertEquals((String)("URI in " + idStr), (Object)FSURI, (Object)dtId.getUri());
        TestDTManagerLifecycle.assertEquals((String)("renewer in " + idStr), (Object)RENEWER, (Object)dtId.getRenewer().toString());
        manager.renewDelegationToken(dt);
        TestDTManagerLifecycle.assertEquals((String)("Renewal count in " + stub), (long)1L, (long)stub.getRenewals());
        manager.cancelDelegationToken(dt);
        TestDTManagerLifecycle.assertEquals((String)("Cancel count in " + stub), (long)1L, (long)stub.getCancellations());
        manager.close();
        TestDTManagerLifecycle.assertTrue((String)("Not closed: " + stub), (boolean)stub.isClosed());
    }
}

