/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.ServiceSASGenerator;
import org.apache.hadoop.security.AccessControlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSASTokenProvider
implements SASTokenProvider {
    private byte[] accountKey;
    private ServiceSASGenerator generator;
    private boolean skipAuthorizationForTestSetup = false;
    private static final Logger LOG = LoggerFactory.getLogger(MockSASTokenProvider.class);

    private String generateSAS(byte[] accountKey, String accountName, String fileSystemName) {
        String containerSAS = "";
        try {
            containerSAS = this.generator.getContainerSASWithFullControl(accountName, fileSystemName);
        }
        catch (InvalidConfigurationValueException e) {
            LOG.debug(e.getMessage());
            containerSAS = "";
        }
        return containerSAS;
    }

    public void initialize(Configuration configuration, String accountName) throws IOException {
        try {
            AbfsConfiguration abfsConfig = new AbfsConfiguration(configuration, accountName);
            this.accountKey = Base64.decode((String)abfsConfig.getStorageAccountKey());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        this.generator = new ServiceSASGenerator(this.accountKey);
    }

    public String getSASToken(String accountName, String fileSystem, String path, String operation) throws IOException, AccessControlException {
        if (!this.isSkipAuthorizationForTestSetup() && path.contains("unauthorized")) {
            throw new AccessControlException("The user is not authorized to perform this operation.");
        }
        return this.generateSAS(this.accountKey, accountName, fileSystem);
    }

    public boolean isSkipAuthorizationForTestSetup() {
        return this.skipAuthorizationForTestSetup;
    }

    public void setSkipAuthorizationForTestSetup(boolean skipAuthorizationForTestSetup) {
        this.skipAuthorizationForTestSetup = skipAuthorizationForTestSetup;
    }
}

