/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.extensions.ClassicDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.extensions.KerberizedAbfsCluster;
import org.apache.hadoop.fs.azurebfs.extensions.StubAbfsTokenIdentifier;
import org.apache.hadoop.fs.azurebfs.extensions.StubDelegationTokenManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DtUtilShell;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAbfsDelegationTokens
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsDelegationTokens.class);
    private static KerberizedAbfsCluster cluster;
    private UserGroupInformation aliceUser;

    @BeforeClass
    public static void setupCluster() throws Exception {
        ITestAbfsDelegationTokens.resetUGI();
        cluster = new KerberizedAbfsCluster();
        cluster.init(new Configuration());
        cluster.start();
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        ITestAbfsDelegationTokens.resetUGI();
        ServiceOperations.stopQuietly((Logger)LOG, (Service)cluster);
    }

    @Override
    public void setup() throws Exception {
        Configuration conf = this.getRawConfiguration();
        cluster.bindConfToCluster(conf);
        conf.setBoolean("hadoop.security.token.service.use_ip", false);
        ITestAbfsDelegationTokens.resetUGI();
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.aliceUser = cluster.createAliceUser();
        ITestAbfsDelegationTokens.assertSecurityEnabled();
        UserGroupInformation.setLoginUser((UserGroupInformation)this.aliceUser);
        StubDelegationTokenManager.useStubDTManager(conf);
        FileSystem.closeAllForUGI((UserGroupInformation)UserGroupInformation.getLoginUser());
        super.setup();
        ITestAbfsDelegationTokens.assertNotNull((String)"No StubDelegationTokenManager created in filesystem init", (Object)this.getStubDTManager());
    }

    protected StubDelegationTokenManager getStubDTManager() throws IOException {
        return (StubDelegationTokenManager)this.getDelegationTokenManager().getTokenManager();
    }

    @Override
    public void teardown() throws Exception {
        FileSystem.closeAllForUGI((UserGroupInformation)UserGroupInformation.getLoginUser());
        super.teardown();
    }

    public static void assertSecurityEnabled() {
        ITestAbfsDelegationTokens.assertTrue((String)"Security is needed for this test", (boolean)UserGroupInformation.isSecurityEnabled());
    }

    protected static void resetUGI() {
        UserGroupInformation.reset();
    }

    protected static Credentials mkTokens(FileSystem fs) throws IOException {
        Credentials cred = new Credentials();
        fs.addDelegationTokens("rm/rm1@EXAMPLE.COM", cred);
        return cred;
    }

    @Test
    public void testTokenManagerBinding() throws Throwable {
        StubDelegationTokenManager instance = this.getStubDTManager();
        ITestAbfsDelegationTokens.assertNotNull((String)"No StubDelegationTokenManager created in filesystem init", (Object)instance);
        ITestAbfsDelegationTokens.assertTrue((String)("token manager not initialized: " + instance), (boolean)instance.isInitialized());
    }

    @Test
    public void testCanonicalization() throws Throwable {
        String service = this.getCanonicalServiceName();
        ITestAbfsDelegationTokens.assertNotNull((String)("No canonical service name from filesystem " + this.getFileSystem()), (Object)service);
        ITestAbfsDelegationTokens.assertEquals((String)"canonical URI and service name mismatch", (Object)this.getFilesystemURI(), (Object)new URI(service));
    }

    protected URI getFilesystemURI() throws IOException {
        return this.getFileSystem().getUri();
    }

    protected String getCanonicalServiceName() throws IOException {
        return this.getFileSystem().getCanonicalServiceName();
    }

    @Test
    public void testDefaultCanonicalization() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.clearTokenServiceName();
        ITestAbfsDelegationTokens.assertEquals((String)"canonicalServiceName is not the default", (Object)this.getDefaultServiceName((FileSystem)fs), (Object)this.getCanonicalServiceName());
    }

    protected String getDefaultServiceName(FileSystem fs) {
        return SecurityUtil.buildDTServiceName((URI)fs.getUri(), (int)0);
    }

    protected void clearTokenServiceName() throws IOException {
        this.getStubDTManager().setCanonicalServiceName(null);
    }

    @Test
    public void testRequestToken() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        Credentials credentials = ITestAbfsDelegationTokens.mkTokens((FileSystem)fs);
        ITestAbfsDelegationTokens.assertEquals((String)"Number of collected tokens", (long)1L, (long)credentials.numberOfTokens());
        this.verifyCredentialsContainsToken(credentials, (FileSystem)fs);
    }

    @Test
    public void testRequestTokenDefault() throws Throwable {
        this.clearTokenServiceName();
        AzureBlobFileSystem fs = this.getFileSystem();
        ITestAbfsDelegationTokens.assertEquals((String)"canonicalServiceName is not the default", (Object)this.getDefaultServiceName((FileSystem)fs), (Object)fs.getCanonicalServiceName());
        Credentials credentials = ITestAbfsDelegationTokens.mkTokens((FileSystem)fs);
        ITestAbfsDelegationTokens.assertEquals((String)"Number of collected tokens", (long)1L, (long)credentials.numberOfTokens());
        this.verifyCredentialsContainsToken(credentials, this.getDefaultServiceName((FileSystem)fs), this.getFilesystemURI().toString());
    }

    public void verifyCredentialsContainsToken(Credentials credentials, FileSystem fs) throws IOException {
        this.verifyCredentialsContainsToken(credentials, fs.getCanonicalServiceName(), fs.getUri().toString());
    }

    public StubAbfsTokenIdentifier verifyCredentialsContainsToken(Credentials credentials, String serviceName, String tokenService) throws IOException {
        Token token = credentials.getToken(new Text(serviceName));
        ITestAbfsDelegationTokens.assertEquals((String)("Token Kind in " + token), (Object)StubAbfsTokenIdentifier.TOKEN_KIND, (Object)token.getKind());
        ITestAbfsDelegationTokens.assertEquals((String)("Token Service Kind in " + token), (Object)tokenService, (Object)token.getService().toString());
        StubAbfsTokenIdentifier abfsId = (StubAbfsTokenIdentifier)token.decodeIdentifier();
        LOG.info("Created token {}", (Object)abfsId);
        ITestAbfsDelegationTokens.assertEquals((String)("token URI in " + abfsId), (Object)tokenService, (Object)abfsId.getUri().toString());
        return abfsId;
    }

    @Test
    public void testJobsCollectTokens() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        Credentials credentials = new Credentials();
        Path root = fs.makeQualified(new Path("/"));
        Path[] paths = new Path[]{root};
        Configuration conf = fs.getConf();
        TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])paths, (Configuration)conf);
        this.verifyCredentialsContainsToken(credentials, (FileSystem)fs);
    }

    protected String dtutil(int expected, Configuration conf, String ... args) throws Exception {
        ByteArrayOutputStream dtUtilContent = new ByteArrayOutputStream();
        DtUtilShell dt = new DtUtilShell();
        dt.setOut(new PrintStream(dtUtilContent));
        dtUtilContent.reset();
        int r = (Integer)LambdaTestUtils.doAs((UserGroupInformation)this.aliceUser, () -> ToolRunner.run((Configuration)conf, (Tool)dt, (String[])args));
        String s = dtUtilContent.toString();
        LOG.info("\n{}", (Object)s);
        ITestAbfsDelegationTokens.assertEquals((String)("Exit code from command dtutil " + StringUtils.join((CharSequence)" ", (String[])args) + " with output " + s), (long)expected, (long)r);
        return s;
    }

    @Test
    public void testDTUtilShell() throws Throwable {
        File tokenfile = cluster.createTempTokenFile();
        String tfs = tokenfile.toString();
        String fsURI = this.getFileSystem().getUri().toString();
        this.dtutil(0, this.getRawConfiguration(), "get", fsURI, "-format", "protobuf", tfs);
        ITestAbfsDelegationTokens.assertTrue((String)("not created: " + tokenfile), (boolean)tokenfile.exists());
        ITestAbfsDelegationTokens.assertTrue((String)("File is empty " + tokenfile), (tokenfile.length() > 0L ? 1 : 0) != 0);
        ITestAbfsDelegationTokens.assertTrue((String)("File only contains header " + tokenfile), (tokenfile.length() > 6L ? 1 : 0) != 0);
        String printed = this.dtutil(0, this.getRawConfiguration(), "print", tfs);
        ITestAbfsDelegationTokens.assertTrue((String)("no " + fsURI + " in " + printed), (boolean)printed.contains(fsURI));
        ITestAbfsDelegationTokens.assertTrue((String)("no StubAbfsTokenIdentifier in " + printed), (boolean)printed.contains("StubAbfsTokenIdentifier"));
    }

    @Test
    public void testBaseDTLifecycle() throws Throwable {
        Configuration conf = new Configuration(this.getRawConfiguration());
        ClassicDelegationTokenManager.useClassicDTManager(conf);
        try (FileSystem fs = FileSystem.newInstance((URI)this.getFilesystemURI(), (Configuration)conf);){
            Credentials credentials = ITestAbfsDelegationTokens.mkTokens(fs);
            ITestAbfsDelegationTokens.assertEquals((String)"Number of collected tokens", (long)1L, (long)credentials.numberOfTokens());
            this.verifyCredentialsContainsToken(credentials, fs.getCanonicalServiceName(), "abfs://user@unset.dfs.core.windows.net/");
        }
    }
}

