/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contract;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.contracts.services.DfsListResultSchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestDfsListJsonParser {
    @Test
    public void testMatchingJSON() throws IOException {
        String matchingJson = "{ \"paths\": [ { \"contentLength\": \"0\", \"etag\": \"0x8D8186452785ADA\", \"group\": \"$superuser\", \"lastModified\": \"Wed, 24 Jun 2020 17:30:43 GMT\", \"name\": \"dest/filename\", \"owner\": \"$superuser\", \"permissions\": \"rw-r--r--\" } ] } ";
        ObjectMapper objectMapper = new ObjectMapper();
        DfsListResultSchema listResultSchema = (DfsListResultSchema)objectMapper.readValue(matchingJson, DfsListResultSchema.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)listResultSchema.paths().size()).describedAs("Only one path is expected as present in the input JSON", new Object[0])).isEqualTo(1);
        ListResultEntrySchema path = (ListResultEntrySchema)listResultSchema.paths().get(0);
        ((AbstractLongAssert)Assertions.assertThat((Long)path.contentLength()).describedAs("contentLength should match the value in the input JSON", new Object[0])).isEqualTo(0L);
        ((AbstractStringAssert)Assertions.assertThat((String)path.eTag()).describedAs("eTag should match the value in the input JSON", new Object[0])).isEqualTo((Object)"0x8D8186452785ADA");
        ((AbstractStringAssert)Assertions.assertThat((String)path.group()).describedAs("group should match the value in the input JSON", new Object[0])).isEqualTo((Object)"$superuser");
        ((AbstractStringAssert)Assertions.assertThat((String)path.lastModified()).describedAs("lastModified should match the value in the input JSON", new Object[0])).isEqualTo((Object)"Wed, 24 Jun 2020 17:30:43 GMT");
        ((AbstractStringAssert)Assertions.assertThat((String)path.name()).describedAs("lastModified should match the value in the input JSON", new Object[0])).isEqualTo((Object)"dest/filename");
        ((AbstractStringAssert)Assertions.assertThat((String)path.owner()).describedAs("lastModified should match the value in the input JSON", new Object[0])).isEqualTo((Object)"$superuser");
        ((AbstractStringAssert)Assertions.assertThat((String)path.permissions()).describedAs("lastModified should match the value in the input JSON", new Object[0])).isEqualTo((Object)"rw-r--r--");
    }

    @Test
    public void testJSONWithUnknownFields() throws IOException {
        String matchingJson = "{ \"paths\": [ { \"contentLength\": \"0\", \"unknownProperty\": \"132374934429527192\", \"etag\": \"0x8D8186452785ADA\", \"group\": \"$superuser\", \"lastModified\": \"Wed, 24 Jun 2020 17:30:43 GMT\", \"name\": \"dest/filename\", \"owner\": \"$superuser\", \"permissions\": \"rw-r--r--\" } ] } ";
        ObjectMapper objectMapper = new ObjectMapper();
        DfsListResultSchema listResultSchema = (DfsListResultSchema)objectMapper.readValue(matchingJson, DfsListResultSchema.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)listResultSchema.paths().size()).describedAs("Only one path is expected as present in the input JSON", new Object[0])).isEqualTo(1);
        ListResultEntrySchema path = (ListResultEntrySchema)listResultSchema.paths().get(0);
        ((AbstractLongAssert)Assertions.assertThat((Long)path.contentLength()).describedAs("contentLength should match the value in the input JSON", new Object[0])).isEqualTo(0L);
        ((AbstractStringAssert)Assertions.assertThat((String)path.eTag()).describedAs("eTag should match the value in the input JSON", new Object[0])).isEqualTo((Object)"0x8D8186452785ADA");
        ((AbstractStringAssert)Assertions.assertThat((String)path.group()).describedAs("group should match the value in the input JSON", new Object[0])).isEqualTo((Object)"$superuser");
        ((AbstractStringAssert)Assertions.assertThat((String)path.lastModified()).describedAs("lastModified should match the value in the input JSON", new Object[0])).isEqualTo((Object)"Wed, 24 Jun 2020 17:30:43 GMT");
        ((AbstractStringAssert)Assertions.assertThat((String)path.name()).describedAs("lastModified should match the value in the input JSON", new Object[0])).isEqualTo((Object)"dest/filename");
        ((AbstractStringAssert)Assertions.assertThat((String)path.owner()).describedAs("lastModified should match the value in the input JSON", new Object[0])).isEqualTo((Object)"$superuser");
        ((AbstractStringAssert)Assertions.assertThat((String)path.permissions()).describedAs("lastModified should match the value in the input JSON", new Object[0])).isEqualTo((Object)"rw-r--r--");
    }
}

