/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.ITestAbfsReadWriteAndSeek;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemAppend;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemAttributes;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemCreate;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemDelete;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemFlush;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemListStatus;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFilesystemAcl;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Preconditions;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTracingContext
extends AbstractAbfsIntegrationTest {
    private static final String[] CLIENT_CORRELATIONID_LIST = new String[]{"valid-corr-id-123", "inval!d", ""};
    private static final int HTTP_CREATED = 201;

    @Test
    public void testClientCorrelationId() throws Exception {
        this.checkCorrelationConfigValidation(CLIENT_CORRELATIONID_LIST[0], true);
        this.checkCorrelationConfigValidation(CLIENT_CORRELATIONID_LIST[1], false);
        this.checkCorrelationConfigValidation(CLIENT_CORRELATIONID_LIST[2], false);
    }

    private String getOctalNotation(FsPermission fsPermission) {
        Preconditions.checkNotNull((Object)fsPermission, (Object)"fsPermission");
        return String.format("%04d", fsPermission.toOctal());
    }

    private String getRelativePath(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return path.toUri().getPath();
    }

    public void checkCorrelationConfigValidation(String clientCorrelationId, boolean includeInHeader) throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.set("fs.azure.client.correlationid", clientCorrelationId);
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);){
            String correlationID = fs.getClientCorrelationId();
            if (includeInHeader) {
                ((AbstractStringAssert)Assertions.assertThat((String)correlationID).describedAs("Correlation ID should match config when valid", new Object[0])).isEqualTo((Object)clientCorrelationId);
            } else {
                ((AbstractStringAssert)Assertions.assertThat((String)correlationID).describedAs("Invalid ID should be replaced with empty string", new Object[0])).isEqualTo((Object)"");
            }
            TracingContext tracingContext = new TracingContext(clientCorrelationId, fs.getFileSystemId(), FSOperationType.TEST_OP, TracingHeaderFormat.ALL_ID_FORMAT, null);
            boolean isNamespaceEnabled = fs.getIsNamespaceEnabled(tracingContext);
            String path = this.getRelativePath(new Path("/testDir"));
            AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(isNamespaceEnabled, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
            AbfsRestOperation op = fs.getAbfsClient().createPath(path, true, true, permissions, false, null, null, tracingContext);
            int statusCode = op.getResult().getStatusCode();
            ((AbstractIntegerAssert)Assertions.assertThat((int)statusCode).describedAs("Request should not fail", new Object[0])).isEqualTo(201);
            String requestHeader = op.getResult().getClientRequestId().replace("[", "").replace("]", "");
            ((AbstractStringAssert)Assertions.assertThat((String)requestHeader).describedAs("Client Request Header should match TracingContext", new Object[0])).isEqualTo((Object)op.getLastTracingContext().getHeader());
        }
    }

    @Ignore
    @Test
    public void runCorrelationTestForAllMethods() throws Exception {
        HashMap<AbstractAbfsIntegrationTest, Method> testClasses = new HashMap<AbstractAbfsIntegrationTest, Method>();
        testClasses.put(new ITestAzureBlobFileSystemListStatus(), ITestAzureBlobFileSystemListStatus.class.getMethod("testListPath", new Class[0]));
        testClasses.put(new ITestAbfsReadWriteAndSeek(16384, true, HttpOperationType.JDK_HTTP_URL_CONNECTION), ITestAbfsReadWriteAndSeek.class.getMethod("testReadAheadRequestID", new Class[0]));
        testClasses.put(new ITestAbfsReadWriteAndSeek(16384, true, HttpOperationType.APACHE_HTTP_CLIENT), ITestAbfsReadWriteAndSeek.class.getMethod("testReadAheadRequestID", new Class[0]));
        testClasses.put(new ITestAbfsReadWriteAndSeek(16384, false, HttpOperationType.JDK_HTTP_URL_CONNECTION), ITestAbfsReadWriteAndSeek.class.getMethod("testReadAndWriteWithDifferentBufferSizesAndSeek", new Class[0]));
        testClasses.put(new ITestAbfsReadWriteAndSeek(16384, false, HttpOperationType.APACHE_HTTP_CLIENT), ITestAbfsReadWriteAndSeek.class.getMethod("testReadAndWriteWithDifferentBufferSizesAndSeek", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemAppend(), ITestAzureBlobFileSystemAppend.class.getMethod("testTracingForAppend", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemFlush(), ITestAzureBlobFileSystemFlush.class.getMethod("testTracingHeaderForAppendBlob", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemCreate(), ITestAzureBlobFileSystemCreate.class.getMethod("testDefaultCreateOverwriteFileTest", new Class[0]));
        testClasses.put(new ITestAzureBlobFilesystemAcl(), ITestAzureBlobFilesystemAcl.class.getMethod("testDefaultAclRenamedFile", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemDelete(), ITestAzureBlobFileSystemDelete.class.getMethod("testDeleteFirstLevelDirectory", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemCreate(), ITestAzureBlobFileSystemCreate.class.getMethod("testCreateNonRecursive", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemAttributes(), ITestAzureBlobFileSystemAttributes.class.getMethod("testSetGetXAttr", new Class[0]));
        testClasses.put(new ITestAzureBlobFilesystemAcl(), ITestAzureBlobFilesystemAcl.class.getMethod("testEnsureAclOperationWorksForRoot", new Class[0]));
        for (AbstractAbfsIntegrationTest testClass : testClasses.keySet()) {
            try {
                testClass.setup();
                ((Method)testClasses.get((Object)testClass)).invoke((Object)testClass, new Object[0]);
                testClass.teardown();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AssumptionViolatedException) continue;
                throw new IOException(((Method)testClasses.get((Object)testClass)).getName() + " failed tracing context validation test");
            }
        }
    }

    @Test
    public void testExternalOps() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.HAS_PATH_CAPABILITY, false, 0));
        fs.getAbfsStore().setNamespaceEnabled(Trilean.UNKNOWN);
        fs.hasPathCapability(new Path("/"), "fs.capability.paths.acls");
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        Assume.assumeTrue((boolean)this.getConfiguration().isCheckAccessEnabled());
        Assume.assumeTrue((this.getAuthType() == AuthType.OAuth ? 1 : 0) != 0);
        fs.setListenerOperation(FSOperationType.ACCESS);
        fs.getAbfsStore().setNamespaceEnabled(Trilean.TRUE);
        fs.access(new Path("/"), FsAction.READ);
    }

    @Test
    public void testRetryPrimaryRequestIdWhenInitiallySuppliedEmpty() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String fileSystemId = fs.getFileSystemId();
        String clientCorrelationId = fs.getClientCorrelationId();
        TracingHeaderFormat tracingHeaderFormat = TracingHeaderFormat.ALL_ID_FORMAT;
        TracingContext tracingContext = new TracingContext(clientCorrelationId, fileSystemId, FSOperationType.CREATE_FILESYSTEM, tracingHeaderFormat, (Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE_FILESYSTEM, false, 0));
        AbfsHttpOperation abfsHttpOperation = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        ((AbfsHttpOperation)Mockito.doNothing().when((Object)abfsHttpOperation)).setRequestProperty(Mockito.anyString(), Mockito.anyString());
        tracingContext.constructHeader(abfsHttpOperation, null, "E");
        String header = tracingContext.getHeader();
        String clientRequestIdUsed = header.split(":")[1];
        String[] clientRequestIdUsedParts = clientRequestIdUsed.split("-");
        String assertionPrimaryId = clientRequestIdUsedParts[clientRequestIdUsedParts.length - 1];
        tracingContext.setRetryCount(1);
        tracingContext.setListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE_FILESYSTEM, false, 1));
        tracingContext.constructHeader(abfsHttpOperation, "RT", "E");
        header = tracingContext.getHeader();
        String primaryRequestId = header.split(":")[3];
        ((AbstractStringAssert)Assertions.assertThat((String)primaryRequestId).describedAs("PrimaryRequestId in a retried request's tracingContext should be equal to last part of original request's clientRequestId UUID", new Object[0])).isEqualTo((Object)assertionPrimaryId);
    }

    @Test
    public void testRetryPrimaryRequestIdWhenInitiallySuppliedNonEmpty() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String fileSystemId = fs.getFileSystemId();
        String clientCorrelationId = fs.getClientCorrelationId();
        TracingHeaderFormat tracingHeaderFormat = TracingHeaderFormat.ALL_ID_FORMAT;
        TracingContext tracingContext = new TracingContext(clientCorrelationId, fileSystemId, FSOperationType.CREATE_FILESYSTEM, tracingHeaderFormat, (Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE_FILESYSTEM, false, 0));
        tracingContext.setPrimaryRequestID();
        AbfsHttpOperation abfsHttpOperation = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        ((AbfsHttpOperation)Mockito.doNothing().when((Object)abfsHttpOperation)).setRequestProperty(Mockito.anyString(), Mockito.anyString());
        tracingContext.constructHeader(abfsHttpOperation, null, "E");
        String header = tracingContext.getHeader();
        String assertionPrimaryId = header.split(":")[3];
        tracingContext.setRetryCount(1);
        tracingContext.setListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE_FILESYSTEM, false, 1));
        tracingContext.constructHeader(abfsHttpOperation, "RT", "E");
        header = tracingContext.getHeader();
        String primaryRequestId = header.split(":")[3];
        ((AbstractStringAssert)Assertions.assertThat((String)primaryRequestId).describedAs("PrimaryRequestId in a retried request's tracingContext should be equal to PrimaryRequestId in the original request.", new Object[0])).isEqualTo((Object)assertionPrimaryId);
    }

    @Test
    public void testTracingContextHeaderForRetrypolicy() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String fileSystemId = fs.getFileSystemId();
        String clientCorrelationId = fs.getClientCorrelationId();
        TracingHeaderFormat tracingHeaderFormat = TracingHeaderFormat.ALL_ID_FORMAT;
        TracingContext tracingContext = new TracingContext(clientCorrelationId, fileSystemId, FSOperationType.CREATE_FILESYSTEM, tracingHeaderFormat, (Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE_FILESYSTEM, false, 0));
        tracingContext.setPrimaryRequestID();
        AbfsHttpOperation abfsHttpOperation = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        ((AbfsHttpOperation)Mockito.doNothing().when((Object)abfsHttpOperation)).setRequestProperty(Mockito.anyString(), Mockito.anyString());
        tracingContext.constructHeader(abfsHttpOperation, null, null);
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), null, null);
        tracingContext.constructHeader(abfsHttpOperation, null, "S");
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), null, null);
        tracingContext.constructHeader(abfsHttpOperation, null, "E");
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), null, null);
        tracingContext.constructHeader(abfsHttpOperation, "CT", null);
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), "CT", null);
        tracingContext.constructHeader(abfsHttpOperation, "CT", "S");
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), "CT", "S");
        tracingContext.constructHeader(abfsHttpOperation, "CT", "E");
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), "CT", "E");
        tracingContext.constructHeader(abfsHttpOperation, "503", null);
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), "503", null);
        tracingContext.constructHeader(abfsHttpOperation, "503", "S");
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), "503", null);
        tracingContext.constructHeader(abfsHttpOperation, "503", "E");
        this.checkHeaderForRetryPolicyAbbreviation(tracingContext.getHeader(), "503", null);
    }

    private void checkHeaderForRetryPolicyAbbreviation(String header, String expectedFailureReason, String expectedRetryPolicyAbbreviation) {
        String[] headerContents = header.split(":");
        String previousReqContext = headerContents[6];
        if (expectedFailureReason != null) {
            ((AbstractStringAssert)Assertions.assertThat((String)previousReqContext.split("_")[1]).describedAs("Failure reason Is not as expected", new Object[0])).isEqualTo((Object)expectedFailureReason);
            if (expectedRetryPolicyAbbreviation != null) {
                ((ObjectArrayAssert)Assertions.assertThat((Object[])previousReqContext.split("_")).describedAs("Retry Count, Failure Reason and Retry Policy should be present", new Object[0])).hasSize(3);
                ((AbstractStringAssert)Assertions.assertThat((String)previousReqContext.split("_")[2]).describedAs("Retry policy is not as expected", new Object[0])).isEqualTo((Object)expectedRetryPolicyAbbreviation);
            } else {
                ((ObjectArrayAssert)Assertions.assertThat((Object[])previousReqContext.split("_")).describedAs("Retry Count and Failure Reason should be present", new Object[0])).hasSize(2);
            }
        } else {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])previousReqContext.split("_")).describedAs("Only Retry Count should be present", new Object[0])).hasSize(1);
        }
    }
}

